# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lt_autosnap']

package_data = \
{'': ['*']}

install_requires = \
['single-version>=1.5.1,<2.0.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.8,<0.9']}

entry_points = \
{'console_scripts': ['ltautosnap = lt_autosnap.cli:cli']}

setup_kwargs = {
    'name': 'lt-autosnap',
    'version': '0.2.1',
    'description': 'LVM snapshot automation based on smbsnap from Samba.org',
    'long_description': '# lt-autosnap <!-- omit in toc -->\n\n- [1. DISCLAIMER](#1-disclaimer)\n- [2. Changelog](#2-changelog)\n- [3. Introduction](#3-introduction)\n- [4. Requirements](#4-requirements)\n  - [4.1 Python Dependencies](#41-python-dependencies)\n- [5. Installation](#5-installation)\n  - [5.1 Isolated install (RECOMMENDED)](#51-isolated-install-recommended)\n  - [5.2 Root user install](#52-root-user-install)\n  - [5.3 System pip](#53-system-pip)\n- [6. Configuration](#6-configuration)\n  - [6.1 Parameters](#61-parameters)\n    - [6.1.2 Volume](#612-volume)\n    - [6.1.3 Snap set](#613-snap-set)\n- [6.2 `/etc/ltautosnap.conf`](#62-etcltautosnapconf)\n- [7. Usage](#7-usage)\n\n## 1. DISCLAIMER\n\nDue to the following factors:\n\n- This software is intended to be run with root privileges\n- This software manages logical volumes on your machine, including creationg and deletion of snapshots\n- There may be bugs in this software\n\n...be advised that this software has the ability to at the least cause you **DATA LOSS** and at the worst\n**SEVERELY DAMAGE OR IMPAIR** your operating system. **THIS IS NOT BACKUP SOFTWARE**.\n\nSee [LICENSE.txt](LICENSE.txt) for further disclaimers.\n\n## 2. Changelog\n\n[See CHANGELOG.md](CHANGELOG.md)\n\n## 3. Introduction\n\nThe purpose of this tool is to automate management of LVM thin pool snapshots. It is intended to be used with\ncron or systemd timers for scheduling.\n\n[There is a guide on the Samba\nwebsite](https://wiki.samba.org/index.php/Rotating_LVM_snapshots_for_shadow_copy) for setting up rotating LVM\nsnapshots for use with Samba\'s implementation of Volume Shadow Copy. This script is based on the Bash script\nin that guide. It can mount snapshots to a specified path with dirnames compatible with Volume Shadow Copy,\ne.g. `@GMT-2022.04.28-22.35.17`. For more on setting up Samba for shadow copies, see\n[https://www.samba.org/samba/docs/current/man-html/vfs_shadow_copy2.8.html](https://www.samba.org/samba/docs/current/man-html/vfs_shadow_copy2.8.html)\n\n## 4. Requirements\n\nThis tool requires Python 3.6 or later. For recent Linux distributions the system Python interpreter should\nsuffice. `pip` or `pip3` is required for installation, so you may need to install `python3-pip` or similar\npackage.\n\n### 4.1 Python Dependencies\n\nSince I expect this to be a system package, I tried to minimize the dependencies it would install.\n\n- If you are using Python 3.6, pip will install the `dataclasses` backport for 3.6.\n- pip will install `single-version` for package version management.\n\n## 5. Installation\n\n### 5.1 Isolated install (RECOMMENDED)\n\nThis installs lt-autosnap to an isolated environment. You have to add the bin path to your `PATH` or call\nthe executable directly.\n\nRequires `python3-venv` to be installed on Ubuntu-like OSes.\n\nThe below sets up a virtual environment in `/opt/venv/lt-autosnap`. Adjust as you prefer.\n```bash\n# ## All as root\nmkdir -p /opt/venv\n# Create virtual environment. Substitute virtualenv if you prefer.\npython3 -m venv /opt/venv/lt-autosnap\n# install lt-autosnap\n/opt/venv/lt-autosnap/bin/pip install lt-autosnap\n# To add to PATH for bash\necho \'export PATH="$PATH:/opt/venv/lt-autosnap/bin"\' > /etc/profile.d/lt-autosnap.sh\n# --AND/OR-- To add to PATH for csh\necho \'setenv PATH "$PATH:/opt/venv/lt-autosnap/bin"\' > /etc/profile.d/lt-autosnap.sh\n# --OR-- just use the full path when you need to run lt-autosnap\n/opt/venv/lt-autosnap/bin/ltautosnap\n```\n\n### 5.2 Root user install\n\nThis install to `root`\'s `~/.local` dir, which may or may be in `PATH` (see root\'s `~/.bashrc` file.)\n\n```bash\nsudo pip install --user lt-autosnap\n```\n\n### 5.3 System pip\n\nIt is generally not recommended to install stuff with `pip` as root, however this package has minimal\ndependencies (just `single-version` and `python3-dataclasses` for Python 3.6). This has the benefit of the\n`ltautosnap` command being in your PATH without any extra work. Just run:\n\n```bash\n# as root\n# generally installs to /usr/local. Specify --prefix to install somewhere else.\npip3 install lt-autosnap\n```\n\n## 6. Configuration\n\n### 6.1 Parameters\n\nEach configuration file typically contains one or more **volume** and **snap set** definitions. These are\ndefined as follows:\n\n#### 6.1.2 Volume\n\nAn LVM thin volume that `ltautosnap` will act upon. Configurable options include:\n\n- Where to mount snapshots of the volume\n- Options to pass the mount command when mounting snapshots\n- Which snapset definitions to use\n- A maximum percent-full value after which the `ltautosnap check` command will start emitting warnings that\n  the pool is running out of space.\n\n#### 6.1.3 Snap set\n\nA scheme for making snapshots. Configuration options include:\n\n- The period of time between snapshots (`ltautosnap autosnap` uses this to determine whether to create new\n  snapshots)\n- The maximum number of snapshots to keep (oldest are deleted with `ltautosnap clean`)\n\nEach volume may have multiple snapsets and nultiple volumes may use the same snapset definition.\n\n## 6.2 `/etc/ltautosnap.conf`\n\n1. Create a config file with `ltautosnap genconf > ltautosnap.conf`. Internal comments provide guidance on\n   how to configure volumes and snap sets.\n2. Modify the config file with the details about your volumes and desired snap sets and, as root, copy it to\n   `/etc/ltautosnap.conf`.\n\n## 7. Usage\n\nMost commands require root privileges, even `list`, since it runs `lvs` which usually requires root.\n\n- Output of `ltautosnap --help`:\n  ```text\n  usage: ltautosnap [-h] [--autoclean] [--config CONFIG] [-v] [-d] [-V]\n                    command [volume] [snap_set]\n\n  Automated LVM thin volume snapshot management\n\n  positional arguments:\n    command          Command to execute. Valid commands are mount, umount, snap,\n                     clean, autosnap, check, list, remove, and genconf. See below\n                     for more details.\n    volume           Number of the volume, or "all" for all volumes\n    snap_set         Number of the snaphot-set. Optional for all commands except\n                     snap, autosnap, and clean.\n\n  optional arguments:\n    -h, --help       show this help message and exit\n    --autoclean      If command is autosnap, run clean after creating the new\n                     snapshots.\n    --config CONFIG  Alternate configuration file. Default is /etc/ltautosnap.conf\n    -v               Increment the logging verbosity level.\n                     None for WARNING, -v for INFO, -vv for DEBUG\n    -d, --daemon     Make logging appropriate for file output.\n    -V, --version    show program\'s version number and exit\n\n  Detailed Command description:\n\n  Note, in most of the below commands, "all" (without quotes) can be used to\n  repeat the operation on all volumes, and the snap set number may be omitted to\n  operate on all snap sets.\n\n  ltautosnap mount <vol_n>|all [<snap_set_n>]\n      Mounts snapshots of the specified volume and snap set(s) to new directories\n      under the \'snap_mount_base\' location configured for the volume. The mount\n      point will have a name like \'@GMT-<snapshot datetime>\'. If NOMOUNT is\n      specified for \'snap_mount_base\', an error will be raised.\n\n  ltautosnap umount <vol_n>|all [<snap_set_n>]\n      Unmount any mounted snapshots for the specified volume and snap set(s).\n\n  ltautosnap snap <vol_n>|all [<snap_set_n]\n      Create a snapshot for the specified volume and snap set(s). This will always\n      create a snapshot, regardless of the snap set definition.\n\n  ltautosnap clean <vol_n>|all [<snap_set_n]\n      For the specified volume and snap set[s], determine if there are more\n      snapshots than defined in the snap set\'s \'count\' parameter. If so, unmount\n      and delete the oldest snapshot[s] as necessary to meet the \'count\'. Also run\n      the `fstrim` command on the filesystem of the volume so `lvs` returns the\n      correct total used capacity of the pool.\n\n  ltautosnap autosnap <vol_n>|all [<snap_set_n] [--autoclean]\n      For the specified volume and snap set[s], create a snapshot only if the time\n      since the most recent snapshot of the snap set is greater than the period of\n      the snap set. Perform the \'mount\' command for the volume and snap set[s]. If\n      --autoclean is specified, run the \'clean\' command afterwards.\n\n  ltautosnap check <vol_n>|all\n      Check that the data usage of the pool for the specified volume has not\n      exceeded its \'warning_pct\' configuration parameter.\n\n  ltautosnap list <vol_n>|all [<snap_set_n]\n      List all snapshots of the given volume and snap set[s].\n\n  ltautosnap remove <vol_n>|all [<snap_set_n]\n      Removes all snapshots in the specified snap set[s] of the volume.\n      `ltautosnap umount` must be run first.\n\n  ltautosnap genconf\n      Print an example configuration file to stdout.\n\n  For more help, see README at https://gitlab.com/randallpittman/lt-autosnap\n  ```\n- As root, create a crontab file at `/etc/cron.d/ltautosnap` to generate snaps.\n\n   Examples:\n\n   ```bash\n   # If desired, set an email address to send error messages\n   #   Cron will usually email stdout and stderr if you have mail set up with\n   #   Postfix or similar MTA.\n   MAILTO=example@example.org\n   LTAUTOSNAP=/opt/venv/lt-autosnap/bin/ltautosnap  # or whatever you get from `which ltautosnap`\n\n   # Generate a snapshot for vol0, set0 every day at midnight, no matter what\n   0 0 * * *  root $LTAUTOSNAP snap 0 0\n\n   # Every hour at 3 minutes after the hour, for vol0, set1, if a period has\n   #   elapsed since the last snap of the set, create another one.\n   3 * * * *  root $LTAUTOSNAP autosnap 0 1\n\n   # Every day at 3 AM remove all extra snaps (beyond each snapset\'s count)\n   #   starting with the oldest\n   0 3 * * *  root $LTAUTOSNAP clean all\n\n   # Every hour at 5 after, for volume 1, automatically create new snaps as needed\n   #   and clean old ones for all snap sets.\n   5 0 * * *  root $LTAUTOSNAP autosnap 1 --autoclean\n\n   # Every day at noon, check if each volume\'s pool has exceeded the warning level\n   #   This will log a warning to stderr if the warning level has been exceeded.\n   #   If MAILTO is set and your MTA is configured, you\'ll be emailed only if the\n   #   warning percent is exceeded.\n   0 12 * * *  root $LTAUTOSNAP check all\n\n   # On the first day of the month, do the same but print the % used space to\n   #   stderr no matter what. If MAILTO is set and your MTA is configued, you\'ll\n   #   be emailed the volume usage every month.\n   0 0 1 * *  root $LTAUTOSNAP check all -v\n   ```\n',
    'author': 'Randall Pittman',
    'author_email': 'randall.pittman@oregonstate.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/randallpittman/lt-autosnap',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.8,<4.0.0',
}


setup(**setup_kwargs)
