import enum

FALLBACK_TERMINAL_WIDTH = 80

ENOENT = "lss: cannot access '%s': No such file or directory"
ENOTDIR = "lss: '%s' is not a directory"
STOPITER = "'%s': broken reparse point encountered, iteration stopped"


class Category(enum.IntEnum):
    BROKEN_LINK = enum.auto()
    DIRECTORY = enum.auto()
    SYMLINK = enum.auto()
    REPARSE_POINT = enum.auto()
    FILE = enum.auto()

    EXECUTABLE = enum.auto()
    CODE = enum.auto()
    ARCHIVE = enum.auto()
    IMAGE = enum.auto()
    VIDEO = enum.auto()
    AUDIO = enum.auto()


EXTENSION_TO_CATEGORY = {
    '.7z': Category.ARCHIVE,
    '.a': Category.ARCHIVE,
    '.apk': Category.ARCHIVE,
    '.ar': Category.ARCHIVE,
    '.bz2': Category.ARCHIVE,
    '.cab': Category.ARCHIVE,
    '.cpio': Category.ARCHIVE,
    '.deb': Category.ARCHIVE,
    '.dmg': Category.ARCHIVE,
    '.egg': Category.ARCHIVE,
    '.gz': Category.ARCHIVE,
    '.iso': Category.ARCHIVE,
    '.jar': Category.ARCHIVE,
    '.lha': Category.ARCHIVE,
    '.mar': Category.ARCHIVE,
    '.pak': Category.ARCHIVE,
    '.pea': Category.ARCHIVE,
    '.rar': Category.ARCHIVE,
    '.rpm': Category.ARCHIVE,
    '.s7z': Category.ARCHIVE,
    '.shar': Category.ARCHIVE,
    '.tar': Category.ARCHIVE,
    '.tbz2': Category.ARCHIVE,
    '.tgz': Category.ARCHIVE,
    '.tlz': Category.ARCHIVE,
    '.war': Category.ARCHIVE,
    '.whl': Category.ARCHIVE,
    '.xpi': Category.ARCHIVE,
    '.xz': Category.ARCHIVE,
    '.zip': Category.ARCHIVE,
    '.zipx': Category.ARCHIVE,

    '.bat': Category.EXECUTABLE,
    '.exe': Category.EXECUTABLE,
    '.msi': Category.EXECUTABLE,

    '.c': Category.CODE,
    '.cc': Category.CODE,
    '.class': Category.CODE,
    '.clj': Category.CODE,
    '.cljc': Category.CODE,
    '.cljs': Category.CODE,
    '.coffee': Category.CODE,
    '.cp': Category.CODE,
    '.cpp': Category.CODE,
    '.cs': Category.CODE,
    '.csproj': Category.CODE,
    '.css': Category.CODE,
    '.csx': Category.CODE,
    '.cxx': Category.CODE,
    '.d': Category.CODE,
    '.dart': Category.CODE,
    '.diff': Category.CODE,
    '.el': Category.CODE,
    '.gd': Category.CODE,
    '.go': Category.CODE,
    '.h': Category.CODE,
    '.html': Category.CODE,
    '.ipynb': Category.CODE,
    '.java': Category.CODE,
    '.js': Category.CODE,
    '.lua': Category.CODE,
    '.m': Category.CODE,
    '.m4': Category.CODE,
    '.patch': Category.CODE,
    '.php': Category.CODE,
    '.pl': Category.CODE,
    '.po': Category.CODE,
    '.py': Category.CODE,
    '.rb': Category.CODE,
    '.rs': Category.CODE,
    '.sh': Category.CODE,
    '.swift': Category.CODE,
    '.vb': Category.CODE,
    '.vcxproj': Category.CODE,
    '.vue': Category.CODE,
    '.xcodeproj': Category.CODE,
    '.xml': Category.CODE,

    '.3dm': Category.IMAGE,
    '.3ds': Category.IMAGE,
    '.ai': Category.IMAGE,
    '.bmp': Category.IMAGE,
    '.dds': Category.IMAGE,
    '.dwg': Category.IMAGE,
    '.dxf': Category.IMAGE,
    '.eps': Category.IMAGE,
    '.gif': Category.IMAGE,
    '.gpx': Category.IMAGE,
    '.jpeg': Category.IMAGE,
    '.jpg': Category.IMAGE,
    '.kml': Category.IMAGE,
    '.kmz': Category.IMAGE,
    '.max': Category.IMAGE,
    '.png': Category.IMAGE,
    '.ps': Category.IMAGE,
    '.psd': Category.IMAGE,
    '.svg': Category.IMAGE,
    '.tga': Category.IMAGE,
    '.thm': Category.IMAGE,
    '.tif': Category.IMAGE,
    '.tiff': Category.IMAGE,
    '.webp': Category.IMAGE,
    '.xcf': Category.IMAGE,

    '.aac': Category.AUDIO,
    '.aiff': Category.AUDIO,
    '.ape': Category.AUDIO,
    '.au': Category.AUDIO,
    '.flac': Category.AUDIO,
    '.gsm': Category.AUDIO,
    '.it': Category.AUDIO,
    '.m3u': Category.AUDIO,
    '.m4a': Category.AUDIO,
    '.mid': Category.AUDIO,
    '.mod': Category.AUDIO,
    '.mp3': Category.AUDIO,
    '.mpa': Category.AUDIO,
    '.pls': Category.AUDIO,
    '.ra': Category.AUDIO,
    '.s3m': Category.AUDIO,
    '.sid': Category.AUDIO,
    '.wav': Category.AUDIO,
    '.wma': Category.AUDIO,
    '.xm': Category.AUDIO,

    '.3g2': Category.VIDEO,
    '.3gp': Category.VIDEO,
    '.aaf': Category.VIDEO,
    '.asf': Category.VIDEO,
    '.avchd': Category.VIDEO,
    '.avi': Category.VIDEO,
    '.drc': Category.VIDEO,
    '.flv': Category.VIDEO,
    '.m2v': Category.VIDEO,
    '.m4p': Category.VIDEO,
    '.m4v': Category.VIDEO,
    '.mkv': Category.VIDEO,
    '.mng': Category.VIDEO,
    '.mov': Category.VIDEO,
    '.mp2': Category.VIDEO,
    '.mp4': Category.VIDEO,
    '.mpe': Category.VIDEO,
    '.mpeg': Category.VIDEO,
    '.mpg': Category.VIDEO,
    '.mpv': Category.VIDEO,
    '.mxf': Category.VIDEO,
    '.nsv': Category.VIDEO,
    '.ogg': Category.VIDEO,
    '.ogm': Category.VIDEO,
    '.ogv': Category.VIDEO,
    '.qt': Category.VIDEO,
    '.rm': Category.VIDEO,
    '.rmvb': Category.VIDEO,
    '.roq': Category.VIDEO,
    '.srt': Category.VIDEO,
    '.svi': Category.VIDEO,
    '.vob': Category.VIDEO,
    '.webm': Category.VIDEO,
    '.wmv': Category.VIDEO,
    '.yuv': Category.VIDEO,
}
