Linkedin-Search-Groups is a python library to search keyword in groups and then scrape groups data on linkedin using browser automation. 
It currently runs only on windows.

### Example
In this example we first import library, then we login with cookies and then search and scrape data of a groups.
```sh
from linkedin_search_groups_scraper import *
true=True;false=False
list_of_cookies=[
{
    "domain": ".linkedin.com",
    "expirationDate": 1676463230,
    "hostOnly": false,
    "httpOnly": false,
    "name": "_ga",
    "path": "/",
    "sameSite": "unspecified",
    "secure": false,
    "session": false,
    "storeId": "0",
    "value": "GA1.2.1029585723.1610264105",
    "id": 1
}]
#please replace the above sample cookies with your cookies, can see below link of how to fetch cookies
linkedin.login_cookie(cookies=list_of_cookies)
linkedin.search_groups(keyword='python')
response=linkedin.groups_results()
data=response['body']
#data=[{"Title": "Python Developers Community", "Group Link": "https://www.linkedin.com/groups/2066905?lipi=urn%3Ali%3Apage%3Ad_flagship3_search_srp_groups%3B4Mre2pq1Rx%2BnW82LOLYJ%2Bg%3D%3D", "Members": "196k"}]
```

This module depends on the following python modules
* [requests](https://pypi.org/project/requests/)
* [bot_studio](https://pypi.org/project/bot_studio/)

#### BotStudio
[bot_studio](https://pypi.org/project/bot_studio/) is needed for browser automation. As soon as this library is imported in code, automated browser will open up. Complete documentation for Linkedin Automation available [here](https://linkedin-api.datakund.com/en/latest/)

### Installation

```sh
pip install linkedin-search-groups-scraper
```

### Import
```sh
from linkedin_search_groups_scraper import *
```

### Login with credentials
```sh
linkedin.login(username="linkedin username",password="linkedin password")
```

### Login with cookies
```sh
linkedin.login_cookie(cookies=list_of_cookies)
```

### Search in groups
```sh
linkedin.search_groups(keyword='search keyword')
```

### Get Search Results
```sh
response=linkedin.groups_results()
data=response['body']
```

### Send Feedback to Developers
```sh
bot_studio.send_feedback(feedback="Need help with this ......")
```

### Cookies
To login with cookies [Edit this Cookie Extension](https://chrome.google.com/webstore/detail/editthiscookie/fngmhnnpilhplaeedifhccceomclgfbg?hl=en) can be added to browser. Please check [this](https://abhishek-chaudhary.medium.com/how-to-get-cookies-of-any-website-from-browser-22b3d6348ed2) link how to get cookies to login to your linkedin.

### Contact Us
* [Telegram](https://t.me/datakund)
* [Website](https://datakund.com)

