Linkedin-Post-Scraper-With-Python is a python library to scrape post data on linkedin using browser automation. 
It currently runs only on windows.

### Example
In this example we first import library, then we login with cookies and then scrape data of a post.
```sh
from linkedin_post_scraper_with_python import *
true=True;false=False
list_of_cookies=[
{
    "domain": ".linkedin.com",
    "expirationDate": 1676463230,
    "hostOnly": false,
    "httpOnly": false,
    "name": "_ga",
    "path": "/",
    "sameSite": "unspecified",
    "secure": false,
    "session": false,
    "storeId": "0",
    "value": "GA1.2.1029585723.1610264105",
    "id": 1
}]
#please replace the above sample cookies with your cookies, can see below link of how to fetch cookies
linkedin.login_cookie(cookies=list_of_cookies)
response=linkedin.get_post(post_link='https://www.linkedin.com/posts/apeksha-jogiya-0144123b_hrinsight-hrthings-hrjobs-activity-6765881152038322176-WS3F')
data=response['body']
```

This module depends on the following python modules
* [requests](https://pypi.org/project/requests/)
* [btstudio](https://pypi.org/project/btstudio/)

#### BotStudio
[btstudio](https://pypi.org/project/btstudio/) is needed for browser automation. As soon as this library is imported in code, automated browser will open up. Complete documentation for Linkedin Automation available [here](https://linkedin-api.datakund.com/en/latest/)

### Installation

```sh
pip install linkedin-post-scraper-with-python
```

### Import
```sh
from linkedin_post_scraper_with_python import *
```

### Login with credentials
```sh
linkedin.login(username="linkedin username",password="linkedin password")
```

### Login with cookies
```sh
linkedin.login_cookie(cookies=list_of_cookies)
```

### Get Post data 
```sh
response=linkedin.get_post(post_link='post_link')
data=response['body']
```

### Send Feedback to Developers
```sh
btstudio.send_feedback(feedback="Need help with this ......")
```

### Cookies
To login with cookies [Edit this Cookie Extension](https://chrome.google.com/webstore/detail/editthiscookie/fngmhnnpilhplaeedifhccceomclgfbg?hl=en) can be added to browser. Please check [this](https://abhishek-chaudhary.medium.com/how-to-get-cookies-of-any-website-from-browser-22b3d6348ed2) link how to get cookies to login to your linkedin.

### Contact Us
* [Telegram](https://t.me/datakund)
* [Website](https://datakund.com)

