# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lightautoml',
 'lightautoml.addons',
 'lightautoml.addons.interpretation',
 'lightautoml.addons.uplift',
 'lightautoml.addons.utilization',
 'lightautoml.automl',
 'lightautoml.automl.gpu',
 'lightautoml.automl.presets',
 'lightautoml.dataset',
 'lightautoml.dataset.gpu',
 'lightautoml.image',
 'lightautoml.ml_algo',
 'lightautoml.ml_algo.gpu',
 'lightautoml.ml_algo.torch_based',
 'lightautoml.ml_algo.torch_based.gpu',
 'lightautoml.ml_algo.tuning',
 'lightautoml.ml_algo.tuning.gpu',
 'lightautoml.pipelines',
 'lightautoml.pipelines.features',
 'lightautoml.pipelines.features.gpu',
 'lightautoml.pipelines.ml',
 'lightautoml.pipelines.selection',
 'lightautoml.reader',
 'lightautoml.reader.gpu',
 'lightautoml.report',
 'lightautoml.tasks',
 'lightautoml.tasks.gpu',
 'lightautoml.tasks.losses',
 'lightautoml.tasks.losses.gpu',
 'lightautoml.text',
 'lightautoml.transformers',
 'lightautoml.transformers.gpu',
 'lightautoml.utils',
 'lightautoml.validation',
 'lightautoml.validation.gpu']

package_data = \
{'': ['*'],
 'lightautoml.automl.presets': ['tabular_configs/*'],
 'lightautoml.report': ['lama_report_templates/*']}

install_requires = \
['autowoe>=1.2',
 'catboost>=0.26.1',
 'cmaes',
 'dataclasses==0.6',
 'holidays',
 'jinja2',
 'joblib',
 'json2html',
 'lightgbm>=2.3,<3.0',
 'networkx',
 'optuna',
 'pandas==1.1.5',
 'poetry-core>=1.0.0,<2.0.0',
 'pyyaml',
 'scikit-learn>=0.22',
 'scipy<=1.5.4',
 'seaborn',
 'torch<1.9',
 'tqdm']

extras_require = \
{':python_full_version == "3.6.1" and sys_platform == "win32"': ['torch==1.7.0'],
 ':python_version < "3.7"': ['numpy<=1.19.5'],
 ':python_version < "3.8"': ['importlib-metadata>=1.0,<2.0'],
 ':python_version >= "3.7"': ['numpy>=1.2'],
 'afg': ['featuretools'],
 'all': ['gensim>=4',
         'nltk',
         'transformers>=4',
         'albumentations==1.0.3',
         'efficientnet-pytorch',
         'opencv-python==4.5.2.52',
         'PyWavelets',
         'scikit-image>=0.17,<0.18',
         'torchvision',
         'featuretools',
         'weasyprint>=52.5,<53.0',
         'cffi>=1.14.5,<2.0.0'],
 'all:python_full_version == "3.6.1" and sys_platform == "win32"': ['torchvision==0.8.0'],
 'cv': ['albumentations==1.0.3',
        'efficientnet-pytorch',
        'opencv-python==4.5.2.52',
        'PyWavelets',
        'scikit-image>=0.17,<0.18',
        'torchvision'],
 'cv:python_full_version == "3.6.1" and sys_platform == "win32"': ['torchvision==0.8.0'],
 'nlp': ['gensim>=4', 'nltk', 'transformers>=4'],
 'report': ['weasyprint>=52.5,<53.0', 'cffi>=1.14.5,<2.0.0']}

setup_kwargs = {
    'name': 'lightautoml-gpu',
    'version': '1.0.0',
    'description': 'Fast and customizable framework for automatic ML model creation with GPU acceleration (AutoML)',
    'long_description': 'Long description of LightAutoML-GPU',
    'author': 'Alexander Ryzhkov',
    'author_email': 'alexmryzhkov@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://lightautoml.readthedocs.io/en/latest/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.1,<3.10',
}


setup(**setup_kwargs)
