#[macro_use]
extern crate criterion;
use criterion::{black_box, Criterion};

use light_curve_common::linspace;
use light_curve_interpol::Interpolator;

#[allow(clippy::unreadable_literal)]
#[allow(clippy::excessive_precision)]
fn bench_interpolator(c: &mut Criterion) {
    let initial_xy = [
        5.8197500000e+04,
        3.3450298683e-06,
        5.8217500000e+04,
        3.3697679858e-06,
        5.8217500000e+04,
        3.2688876925e-06,
        5.8218500000e+04,
        3.3853221282e-06,
        5.8218500000e+04,
        3.2538685178e-06,
        5.8219500000e+04,
        3.4419138827e-06,
        5.8219500000e+04,
        3.3573761424e-06,
        5.8230400000e+04,
        3.2003685946e-06,
        5.8242500000e+04,
        3.3174164969e-06,
        5.8244500000e+04,
        3.3204733580e-06,
        5.8246400000e+04,
        3.3542853083e-06,
        5.8247500000e+04,
        3.3884415614e-06,
        5.8249500000e+04,
        3.3790918744e-06,
        5.8249500000e+04,
        3.3790918744e-06,
        5.8254500000e+04,
        3.3296608521e-06,
        5.8255500000e+04,
        3.3604698246e-06,
        5.8256400000e+04,
        3.2960971218e-06,
        5.8256500000e+04,
        3.2900310752e-06,
        5.8257400000e+04,
        3.3296608521e-06,
        5.8257500000e+04,
        3.4009480651e-06,
        5.8258500000e+04,
        3.3728730866e-06,
        5.8262400000e+04,
        3.3604698246e-06,
        5.8263400000e+04,
        3.3759810486e-06,
        5.8266400000e+04,
        3.3021743527e-06,
        5.8268500000e+04,
        3.3419504003e-06,
        5.8269400000e+04,
        3.2960971218e-06,
        5.8270400000e+04,
        3.3450298683e-06,
        5.8271400000e+04,
        3.3542853083e-06,
        5.8272500000e+04,
        3.3327289958e-06,
        5.8273400000e+04,
        3.3728730866e-06,
        5.8274500000e+04,
        3.3052171687e-06,
        5.8275400000e+04,
        3.3357999666e-06,
        5.8277400000e+04,
        3.3946890538e-06,
        5.8278400000e+04,
        3.3759810486e-06,
        5.8279400000e+04,
        3.3450298683e-06,
        5.8280400000e+04,
        3.2478801876e-06,
        5.8281500000e+04,
        3.3388737673e-06,
        5.8282400000e+04,
        3.3635663575e-06,
        5.8283400000e+04,
        3.3327289958e-06,
        5.8285400000e+04,
        3.3946890538e-06,
        5.8286500000e+04,
        3.3790918744e-06,
        5.8287500000e+04,
        3.3822055667e-06,
        5.8288500000e+04,
        3.3511973197e-06,
        5.8289400000e+04,
        3.3450298683e-06,
        5.8290500000e+04,
        3.3419504003e-06,
        5.8291500000e+04,
        3.3388737673e-06,
        5.8292500000e+04,
        3.2991343379e-06,
        5.8293300000e+04,
        3.3481121739e-06,
        5.8294500000e+04,
        3.0366867885e-06,
        5.8296400000e+04,
        3.3666657437e-06,
        5.8298400000e+04,
        3.3511973197e-06,
        5.8299400000e+04,
        3.3697679858e-06,
        5.8300400000e+04,
        3.3542853083e-06,
        5.8301500000e+04,
        3.3511973197e-06,
        5.8302400000e+04,
        3.2688876925e-06,
        5.8303400000e+04,
        3.3296608521e-06,
        5.8304400000e+04,
        3.3978171183e-06,
        5.8305400000e+04,
        3.3327289958e-06,
        5.8307400000e+04,
        3.3635663575e-06,
        5.8310400000e+04,
        3.3853221282e-06,
        5.8312400000e+04,
        3.3327289958e-06,
        5.8313400000e+04,
        3.3666657437e-06,
        5.8314400000e+04,
        3.3822055667e-06,
        5.8315400000e+04,
        3.3204733580e-06,
        5.8316400000e+04,
        3.3450298683e-06,
        5.8318400000e+04,
        3.3419504003e-06,
        5.8319500000e+04,
        3.3697679858e-06,
        5.8320400000e+04,
        3.3978171183e-06,
        5.8321500000e+04,
        3.3296608521e-06,
        5.8322400000e+04,
        3.4355794790e-06,
        5.8323500000e+04,
        3.3113112148e-06,
        5.8324500000e+04,
        3.3265955329e-06,
        5.8325500000e+04,
        3.3511973197e-06,
        5.8326400000e+04,
        3.3327289958e-06,
        5.8327400000e+04,
        3.3021743527e-06,
        5.8328400000e+04,
        3.3082627886e-06,
        5.8329400000e+04,
        3.2839761925e-06,
        5.8330400000e+04,
        3.2658783217e-06,
        5.8332300000e+04,
        3.3021743527e-06,
        5.8333300000e+04,
        3.2508729739e-06,
        5.8334300000e+04,
        3.3511973197e-06,
        5.8336300000e+04,
        3.3635663575e-06,
        5.8337300000e+04,
        3.3666657437e-06,
        5.8338300000e+04,
        3.2930627018e-06,
        5.8342300000e+04,
        3.2991343379e-06,
        5.8343300000e+04,
        3.2688876925e-06,
        5.8344400000e+04,
        3.3759810486e-06,
        5.8345300000e+04,
        3.3666657437e-06,
        5.8346400000e+04,
        3.2839761925e-06,
        5.8347400000e+04,
        3.3174164969e-06,
        5.8349300000e+04,
        3.3265955329e-06,
        5.8351400000e+04,
        3.3357999666e-06,
        5.8352300000e+04,
        3.4009480651e-06,
        5.8353200000e+04,
        3.4009480651e-06,
        5.8353400000e+04,
        3.3573761424e-06,
        5.8354300000e+04,
        3.3052171687e-06,
        5.8354400000e+04,
        3.3388737673e-06,
        5.8355300000e+04,
        3.3204733580e-06,
        5.8355400000e+04,
        3.3143624501e-06,
        5.8356400000e+04,
        3.2991343379e-06,
        5.8356500000e+04,
        3.2839761925e-06,
        5.8357200000e+04,
        3.3666657437e-06,
        5.8357400000e+04,
        3.2839761925e-06,
        5.8358300000e+04,
        3.3542853083e-06,
        5.8359300000e+04,
        3.3481121739e-06,
        5.8359300000e+04,
        3.2991343379e-06,
        5.8360300000e+04,
        3.3481121739e-06,
        5.8361300000e+04,
        3.3113112148e-06,
        5.8362300000e+04,
        3.4009480651e-06,
        5.8363300000e+04,
        3.3419504003e-06,
        5.8364300000e+04,
        3.3978171183e-06,
        5.8365300000e+04,
        3.3481121739e-06,
        5.8366300000e+04,
        3.3635663575e-06,
        5.8367300000e+04,
        3.3511973197e-06,
        5.8368300000e+04,
        3.3388737673e-06,
        5.8369400000e+04,
        3.3666657437e-06,
        5.8370300000e+04,
        3.3419504003e-06,
        5.8371300000e+04,
        3.3419504003e-06,
        5.8372300000e+04,
        3.3296608521e-06,
        5.8373300000e+04,
        3.3235330358e-06,
        5.8374300000e+04,
        3.3113112148e-06,
        5.8375400000e+04,
        3.3357999666e-06,
        5.8376400000e+04,
        3.3822055667e-06,
        5.8377300000e+04,
        3.3573761424e-06,
        5.8378300000e+04,
        3.3357999666e-06,
        5.8379300000e+04,
        3.3573761424e-06,
        5.8380300000e+04,
        3.3915638691e-06,
        5.8382300000e+04,
        3.3357999666e-06,
        5.8383300000e+04,
        3.3481121739e-06,
        5.8384200000e+04,
        3.3265955329e-06,
        5.8385200000e+04,
        3.4009480651e-06,
        5.8386300000e+04,
        3.2900310752e-06,
        5.8387400000e+04,
        3.3235330358e-06,
        5.8388200000e+04,
        3.3481121739e-06,
        5.8389300000e+04,
        3.2181034431e-06,
        5.8390200000e+04,
        3.2930627018e-06,
        5.8400200000e+04,
        3.2151408248e-06,
        5.8424200000e+04,
        3.3327289958e-06,
        5.8425100000e+04,
        3.4009480651e-06,
        5.8428100000e+04,
        3.3419504003e-06,
        5.8429100000e+04,
        3.3542853083e-06,
        5.8430200000e+04,
        3.2870022397e-06,
        5.8431200000e+04,
        3.4072186166e-06,
        5.8433100000e+04,
        3.3450298683e-06,
        5.8434200000e+04,
        3.3450298683e-06,
        5.8435100000e+04,
        3.3542853083e-06,
        5.8436100000e+04,
        3.3697679858e-06,
        5.8437300000e+04,
        3.3388737673e-06,
        5.8441300000e+04,
        3.2718998362e-06,
        5.8442300000e+04,
        3.2870022397e-06,
        5.8457200000e+04,
        3.3481121739e-06,
        5.8469100000e+04,
        3.2900310752e-06,
        5.8471100000e+04,
        3.3204733580e-06,
        5.8472100000e+04,
        3.3143624501e-06,
        5.8474100000e+04,
        3.3388737673e-06,
        5.8475200000e+04,
        3.2389183500e-06,
    ];
    let initial_x: Vec<_> = initial_xy.iter().step_by(2).cloned().collect();
    let initial_y: Vec<_> = initial_xy.iter().skip(1).step_by(2).cloned().collect();
    let target_x = linspace(58194.5_f32, 58482.5, 145);
    let interpolator = Interpolator {
        target_x,
        left: 0.,
        right: 0.,
    };

    c.bench_function("intepolator", move |b| {
        b.iter(|| interpolator.interpolate(black_box(&initial_x[..]), black_box(&initial_y[..])))
    });
}

criterion_group!(benches, bench_interpolator);
criterion_main!(benches);
