<p align="center">
    <img src="https://github.com/Simple2006/libmaths/blob/main/libmaths.PNG?raw=true" width = 300 height = 300 >
</p>

# libmaths

![python](https://img.shields.io/badge/python-3.8%20%7C%203.9-blueviolet)
![License](https://img.shields.io/badge/license-MIT-informational)
![pypi](https://img.shields.io/badge/PyPi-v0.1.1-important)

libmaths was created not only as a learning experience for me,
but as a way to make mathematical models in seconds for Python users
using math in their code. With pre-programmed mathematical functions ranging
from linear to sextic and more, graphing in your code will be a breeze.

## Quick Demo

<p align="center">
    <img src="https://raw.githubusercontent.com/Simple2006/libmaths/main/libmaths_example.gif" width = 580 height = 326>
    <br />
</p>

## Installation

The package is available on PyPI. Install with:

``` shell
pip install libmaths
```
or
```shell
pip3 install libmaths
```

libmaths only supports Python 3.8 and above, so please make sure you are on the
newest version.

## General Usage

There are many functions, but here is one example:

```python
from libmaths import polynomial
```

After that, graphing a quadratic function is as simple as:

``` python
polynomial.quadratic(2, 4, 6)
```

If you need more assistance, examples are provided
[here.](https://github.com/Simple2006/libmaths/blob/main/examples/libmathsGraph.ipynb)

## General Information

libmaths was created by me, a 14-year old high schooler at Lynbrook High School 3 days ago on 2/20/2021. libmaths exists to help reduce the incapability to make quick and accurate models in Python within seconds. With a limited usage of external libraries and access to a multitude of functions, libmaths' variety is one of the many things that makes it unique. With the creation of this library, I hope to bring simplicity and accuracy together.

## Documentation

I am currently working on getting the documentation out to a website. It will be added upon completion.

## Mathematical Functions

The mathematical functions provided in libmaths are listed below:

1.  **Graphable Functions**
    -   Linear
        -   Slope Intercept Form
        -   Point Slope Form
        -   Constant
    -   Polynomial
        -   Standard Quadratic
        -   Vertex Form Quadratic
        -   Cubic
        -   Quartic
        -   Quintic
        -   Sextic
    -   Trigonometry
        -   Sine
        -   Cosine
        -   Tangent

2. **Visualizeable Functions**
    -   Constant Graph
        -   ReLU
        -   Sigmoid

3. **Others**
    -   Output / Graphable Functions
        -   Logarithmic
        -   Absolute Value
        -   Sigmoid -> Int Output
        -   Relu -> Int Output
        -   isPrime
        -   isSquare
        -   Divisor

## Public References

r/Python : [r/Python Post](https://www.reddit.com/r/Python/comments/lr583o/python_math_library_made_in_3_days_as_a_14/)

## Future Plans

In the future, I plan on adding several different complex functions.

## Contributing

First, install the required libraries:
```bash
pip install -r requirements.txt
```

Please remember that I am a high school student with less than half a year of experience in Python programming. I already know you can do better than me! If you have any issues, suggestions, or requests, please feel free to contact me by opening an issue or on my linkedin which can be found in my profile page.

Thanks for contributing!

## Resources

Over the three days spent in creating this library, I used plenty of resources which can be found in my code. You will see links under many of my functions which you can read about the concepts in.

## Feedback, comments, or questions

If you have any feedback or something you would like to tell me, please
do not hesitate to share! Feel free to comment here on github or reach
out to me through <vinayven01@gmail.com>!

©Vinay Venkatesh 2021
