import csv as _csv
import collections as _collections
import pandas as _pd


def reader(target):
    return _csv.reader(target, dialect=Dialect)

def writer(target):
    return _csv.writer(target, dialect=Dialect)

def read_DataFrame(file, **kwargs):
    with DictReader.open_file(file, **kwargs) as dictReader:
        return _pd.DataFrame(dictReader)

def write_DataFrame(file, dataFrame):
    with DictWriter.open_file(file) as dictWriter:
        dictWriter.fieldnames = dataFrame.columns
        for i, row in dataFrame.iterrows():
            dictWriter.writerow(row)



class Dialect(_csv.Dialect):
    delimiter = '\t'
    doublequote = False
    escapechar = None
    lineterminator = '\n'
    quotechar = '"'
    quoting = _csv.QUOTE_NONE
    skipinitialspace = False
    strict = True



class _DictHandler:
    class _Manager:
        def __enter__(self):
            self._manager = open(
                file=self._file, 
                mode=self._DictHandler_cls._mode,
            )
            stream = self._manager.__enter__()
            return self._DictHandler_cls.from_stream(stream, **self._kwargs)
        def __exit__(self, *args, **kwargs):
            return self._manager.__exit__(*args, **kwargs)        
    @classmethod
    def from_handler(cls, handler, **kwargs):
        return cls(handler, **kwargs)
    @classmethod
    def from_stream(cls, stream, **kwargs):
        return cls(cls._handler(stream), **kwargs)
    @classmethod
    def open_file(cls, file, **kwargs):
        ans = _DictHandler._Manager()
        ans._DictHandler_cls = cls
        ans._file = file
        ans._kwargs = kwargs
        return ans
    def __init__(self, handler, *, fieldnames=None):
        cls = type(self)
        if not hasattr(cls, cls._handler_function):
            setattr(cls, cls._handler_function, cls.handle)
        if not hasattr(cls, cls._handler.__name__):
            setattr(cls, cls._handler.__name__, property(cls._get_handler))
            #setattr(cls, cls._handler.__name__, property(cls._get_handler))
        self.line_num = 0
        self.handler = handler
        self.fieldnames = fieldnames
    @property
    def handler(self):
        return self._handler
    @handler.setter
    def handler(self, value):
        cls = type(self)
        if not hasattr(value, cls._handler_function):
            value = cls._handler(value)
        self._handler = value
    def _get_handler(self):
        return self.handler
    def _set_handler(self, value):
        self.handler = value
    def _set_fieldnames(self, value):
        if value is None:
            pass
        elif type(value) is int:
            if value < 0:
                raise ValueError("The property fieldnames cannot be a negative integer! ")
        else:
            value = tuple(value)
            errors = list()
            if hasattr(self, '_fieldnames'):
                if type(self._fieldnames) is int:
                    if len(value) != self._fieldnames:
                        errors.append(
                            ValueError(
                                "The header has not the preset width! "
                            )
                        )
            for item, count in _collections.Counter(value).items():
                if count > 1:
                    errors.append(
                        KeyError(
                            f"The fieldname {item} occures more than once! "
                        )
                    )
            if len(errors):
                raise ExceptionGroup("Improperly formatted! ", errors)
        self._fieldnames = value
    def use_handler(self, *args, **kwargs):
        cls = type(self)
        func = getattr(self.handler, cls._handler_function)
        return func(*args, **kwargs)
    def handle(self, *args, **kwargs):
        ans = self._handle(*args, **kwargs)
        self.line_num += 1
        return ans




class DictReader(_DictHandler):
    _handler = reader
    _handler_function = '__next__'
    _mode = 'r'
    def __iter__(self):
        return self
    @property
    def fieldnames(self):
        if (self._fieldnames is None) or (type(self._fieldnames) is int):
            self.fieldnames = self.use_handler()
        return self._fieldnames
    @fieldnames.setter
    def fieldnames(self, value):
        self._set_fieldnames(value)
    def _handle(self):
        fieldnames = self.fieldnames
        line = self.use_handler()
        if len(fieldnames) != len(line):
            raise ValueError(f"Row {self.line_num} has wrong width! ")
        return dict(zip(fieldnames, line))




class DictWriter(_DictHandler):
    _handler = writer
    _handler_function = 'writerow'
    _mode = 'w'
    @property
    def fieldnames(self):
        return self._fieldnames
    @fieldnames.setter
    def fieldnames(self, value):
        self._set_fieldnames(value)
        if type(self._fieldnames) is tuple:
            self.use_handler(self._fieldnames)
    def _handle(self, row):
        if (self.fieldnames is None) or (type(self.fieldnames) is int):
            self.fieldnames = row.keys()
        else:
            errors = list()
            for x in row.keys():
                if x not in self.fieldnames:
                    errors.append(
                        KeyError(
                            f"The key {x} is missing! "
                        )
                    )
            for x in self.fieldnames:
                if x not in row.keys():
                    errors.append(
                        KeyError(
                            f"The key {x} is unexpected! "
                        )
                    )
            if len(errors):
                raise ExceptionGroup("Improper row! ", errors)
        values = [row[x] for x in self.fieldnames]
        self.use_handler(values)


