# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['leonardorpires',
 'leonardorpires.infrastructure',
 'leonardorpires.infrastructure.azure',
 'leonardorpires.infrastructure.azure.authentication',
 'leonardorpires.infrastructure.azure.key_vault',
 'leonardorpires.infrastructure.azure.purview',
 'leonardorpires.infrastructure.common',
 'leonardorpires.infrastructure.integration',
 'leonardorpires.infrastructure.integration.database',
 'leonardorpires.infrastructure.integration.datadog',
 'leonardorpires.infrastructure.integration.git',
 'leonardorpires.infrastructure.integration.mlflow',
 'leonardorpires.infrastructure.integration.ms_teams',
 'leonardorpires.infrastructure.integration.servicebus',
 'leonardorpires.infrastructure.metadata',
 'leonardorpires.infrastructure.presto',
 'leonardorpires.infrastructure.rabbitmq',
 'leonardorpires.infrastructure.restapi',
 'leonardorpires.infrastructure.service',
 'leonardorpires.infrastructure.service.metadata',
 'leonardorpires.infrastructure.service.metadata.entity',
 'leonardorpires.infrastructure.service.metadata.mapper',
 'leonardorpires.infrastructure.service.metadata.repository',
 'leonardorpires.infrastructure.service.monitor',
 'leonardorpires.infrastructure.service.monitor.log',
 'leonardorpires.infrastructure.service.monitor.metric',
 'leonardorpires.infrastructure.service.monitor.notifier',
 'leonardorpires.infrastructure.sharepoint',
 'leonardorpires.infrastructure.smb',
 'leonardorpires.infrastructure.source',
 'leonardorpires.infrastructure.spark',
 'leonardorpires.ingestion',
 'leonardorpires.ingestion.config',
 'leonardorpires.ingestion.enums',
 'leonardorpires.ingestion.extract',
 'leonardorpires.ingestion.extract.readers',
 'leonardorpires.ingestion.load',
 'leonardorpires.ingestion.load.writers',
 'leonardorpires.ingestion.pipeline',
 'leonardorpires.ingestion.task',
 'leonardorpires.ingestion.task.entity',
 'leonardorpires.ingestion.task.source_tasks',
 'leonardorpires.ingestion.transform',
 'leonardorpires.ingestion.transform.transformations',
 'leonardorpires.ingestion.transform.transformations.custom',
 'leonardorpires.ingestion.utils',
 'leonardorpires.ingestion.validator',
 'leonardorpires.ingestion.validator.messages',
 'leonardorpires.intelligence',
 'leonardorpires.intelligence.analysis',
 'leonardorpires.intelligence.features',
 'leonardorpires.intelligence.metrics',
 'leonardorpires.intelligence.models',
 'leonardorpires.intelligence.models.base',
 'leonardorpires.intelligence.models.distributed',
 'leonardorpires.intelligence.models.nlp',
 'leonardorpires.intelligence.predict',
 'leonardorpires.intelligence.train',
 'leonardorpires.intelligence.utils',
 'leonardorpires.intelligence.workflow']

package_data = \
{'': ['*'], 'leonardorpires': ['config/*']}

install_requires = \
['Office365-REST-Python-Client==2.3.9',
 'SQLAlchemy==1.4.9',
 'azure-identity==1.5.0',
 'azure-keyvault-secrets==4.2.0',
 'azure-servicebus==7.8.0',
 'cerberus==1.3.2',
 'datadog==0.44.0',
 'loguru==0.6.0',
 'mlflow==1.25.1',
 'pandas==1.3.5',
 'pika==1.2.0',
 'protobuf==3.20.0',
 'psycopg2-binary==2.8.6',
 'pymsteams==0.2.1',
 'python-semantic-release==7.31.4',
 'pyyaml==5.4.1',
 'smbprotocol==1.8.3',
 'sphinx==5.0.0',
 'sqlalchemy-utils==0.38.2',
 'toml==0.10.0',
 'trino==0.305.0']

setup_kwargs = {
    'name': 'leonardorpires',
    'version': '2.5.1',
    'description': 'This library provides tools for building Extract, Transform, and Load modules using Apache Spark and Pandas. It is a central framework to help create Data Pipeline and Machine Learning Models. ',
    'long_description': "# PyIris\n\n[![Travis](https://img.shields.io/travis/compbiocore/cbc-documentation-templates.svg?style=flat-square)](https://travis-ci.org/compbiocore/cbc-documentation-templates)\n[![Coverage](https://img.shields.io/coveralls/github/jekyll/jekyll.svg?style=flat-square)](http://www.coverage.com) \n[![Docs](https://img.shields.io/badge/docs-stable-blue.svg?style=flat-square)](https://compbiocore.github.io/cbc-documentation-templates)\n\nThis library provides tools for building Extract, Transform, and Load modules using Apache Spark and Pandas. It is a central framework to help create Data Pipeline and Machine Learning Models.\n\nTo understand the main concepts and the main features you can check [PyIris Documentation][15], which is hosted by Read the Docs.\n\nTo learn how to use Pyiris, see [code examples][16].\n\n## Contributing\nAll contributions are welcome! Feel free to open Pull Requests. Check the development and [Contributing Guidelines][13].\n\n## Bugs/Issues Reporting\nFor reporting unexpected behaviour in API, open issues on the [Iris Customer Board][12]. \n\n## Owners\nThis project is maintained by Iris Data Platform Team.\nYou can find us in [Teams][14]. Please, don't hesitate to reach us if you have any questions.\n\n[1]: https://github.com/cervejaria-ambev/pyiris/tree/master/docs\n[2]: https://github.com/cervejaria-ambev/pyiris/tree/master/examples \n[3]: https://github.com/cervejaria-ambev/pyiris/blob/master/CONTRIBUTING.md\n[4]: https://dev.azure.com/AMBEV-SA/IRIS-Analytics%20Platform/_boards/board/t/AnalyticsTeam/Customer%20Service\n[5]: https://teams.microsoft.com/l/channel/19%3addd4f0795de14bc9a29bc25638e789b9%40thread.tacv2/%255BIris%255D%2520-%2520Data%2520Ingestion?groupId=a1e63d39-3fbc-4957-9478-b6063de0ebca&tenantId=cef04b19-7776-4a94-b89b-375c77a8f936\n[1]: https://www.jetbrains.com/pycharm/\n[2]: https://code.visualstudio.com/\n[3]: https://www.python.org/downloads/release/python-370/\n[4]: http://gnuwin32.sourceforge.net/packages/make.htm\n[5]: https://pypi.org/project/pip/\n[6]: https://azure.microsoft.com/pt-br/services/devops/\n[7]: https://python-semantic-release.readthedocs.io/en/latest/index.html\n[8]: https://github.com/cervejaria-ambev/pyiris/releases\n[9]: https://github.com/angular/angular.js/blob/master/DEVELOPERS.md#-git-commit-guidelines\n[10]: https://pypi.org/project/commitizen/\n[11]: https://www.conventionalcommits.org/en/v1.0.0-beta.2/\n[12]: https://dev.azure.com/AMBEV-SA/IRIS-Analytics%20Platform/_boards/board/t/AnalyticsTeam/Customer%20Service\n[13]: https://github.com/cervejaria-ambev/pyiris/blob/master/CONTRIBUTING.md\n[14]: https://teams.microsoft.com/l/channel/19%3addd4f0795de14bc9a29bc25638e789b9%40thread.tacv2/%255BIris%255D%2520-%2520Data%2520Ingestion?groupId=a1e63d39-3fbc-4957-9478-b6063de0ebca&tenantId=cef04b19-7776-4a94-b89b-375c77a8f936\n[15]: https://stpyiris.z13.web.core.windows.net/index.html\n[16]: https://medium.com/@Web_Bailey/github-feature-branch-workflow-db3b24535d53\n[17]: https://www.python.org/dev/peps/pep-0257/\n[18]: https://pypi.org/project/pycodestyle/#description\n[19]: https://github.com/psf/black\n[20]: https://pycqa.github.io/isort/\n[21]: https://flake8.pycqa.org/en/latest/index.html\n",
    'author': 'Iris - Data Platform Team',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/cervejaria-ambev/pyiris',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.0,<3.9.0',
}


setup(**setup_kwargs)
