# Generated by Django 4.1.4 on 2023-01-01 08:34

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Champion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('roles', models.TextField(blank=True, null=True)),
                ('lanes', models.TextField(blank=True, null=True)),
                ('date_created', models.DateTimeField(blank=True, default=None, null=True)),
                ('date_modified', models.DateTimeField(blank=True, default=None, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Skin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tier', models.CharField(choices=[('ULTIMATE', 'Ultimate'), ('MYTHIC', 'Mythic'), ('LEGENDARY', 'Legendary'), ('EPIC', 'Epic'), ('STANDARD', 'Standard'), ('BUDGET', 'Budget'), ('LIMITED', 'Limited'), ('UNKNOWN', 'Unknown')], default=None, max_length=9)),
                ('name', models.CharField(max_length=50)),
                ('value', models.IntegerField(blank=True, default=None, null=True)),
                ('date_created', models.DateTimeField(blank=True, default=None, null=True)),
                ('date_modified', models.DateTimeField(blank=True, default=None, null=True)),
                ('champion', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='skins', to='lsb.champion')),
            ],
            options={
                'verbose_name': 'Skin',
                'verbose_name_plural': 'Skins',
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=100, unique=True)),
                ('password', models.CharField(max_length=255)),
                ('region', models.CharField(choices=[('EUW', 'EUW'), ('EUNE', 'EUNE'), ('NA', 'NA'), ('OC1', 'OCE'), ('RU', 'RU'), ('TR', 'TR'), ('LA1', 'LAN'), ('LA2', 'LAS'), ('BR', 'BR'), ('JP', 'JP')], default='EUW', max_length=4)),
                ('level', models.FloatField()),
                ('blue_essence', models.PositiveIntegerField()),
                ('orange_essence', models.PositiveIntegerField()),
                ('mythic_essence', models.PositiveIntegerField()),
                ('discrete_level', models.PositiveIntegerField()),
                ('discrete_blue_essence', models.PositiveIntegerField()),
                ('is_purchased', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(blank=True, default=None, null=True)),
                ('date_modified', models.DateTimeField(blank=True, default=None, null=True)),
                ('all_skins', models.ManyToManyField(blank=True, related_name='all_skins_products', to='lsb.skin')),
                ('owned_skins', models.ManyToManyField(blank=True, related_name='owned_skin_products', to='lsb.skin')),
                ('permanent_skins', models.ManyToManyField(blank=True, related_name='permanent_skin_products', to='lsb.skin')),
                ('skins', models.ManyToManyField(blank=True, to='lsb.skin')),
            ],
        ),
    ]
