# -*- coding:utf-8 -*-
'''
@Project  : lb_toolkits
@File     : config.py
@Modify Time      @Author    @Version    
--------------    -------    --------    
2022/7/15 10:22      Lee       1.0 
@Description
------------------------------------
 
'''
import os
import sys
import numpy as np
import pyorbital
Deg2Rad = np.pi / 180.0         #  角度转弧度*/
Rad2Deg = 180.0 / np.pi         # 弧度转角度

# /**********************************************************************/
# /*****************                                    *****************/
# /*****************       	地球物理参数表        *****************/
# /*****************                                    *****************/
# /**********************************************************************/

AE      =    6378.137   		 # 标准地球赤道半径(公里)WGS84标准
FINV	=    298.257223563        # 地球扁率       :
E2   	=    0.0066943800699785	 # 地球偏心率平方
GME     =    398601.80          	 # 引力常数GM(m**3/(s**2))
J2      = -.0010826517		     # 地球带谐项
J3      =  .0000025450306   		 # 地球带谐项
J4      =  .0000016714987		 # 地球带谐项
J5      =  .00000020672093		 # 地球带谐项
E21     =  .9933056
E2E21   =  .006739502
# ne STP=ANG    .054100                   # 两个扫描点之间的角度
# ne STP=TIM    .02500e-3                 # 两个扫描点之间的时间
HNGTIM  =  8.615e-3               # 两个扫描点之间半点的时间
TIMLIM  =  0.16666666666666       #  1/6秒

Deg2Rad = 0.0174532925199433      #  角度转弧度*/
Rad2Deg	= 57.29577951308232	      # 弧度转角度 */


ScanInfo = {
    'FY1D': {
        'MERSI': [110.8, 2048, 0.0541,  0.000025],
        'VIRR':  [110.8, 2048, 0.0541,  0.000025],
    },

    'FY3A': {
        'MERSI': [110.8, 2048, 0.0541,  0.000025],
        'VIRR':  [110.8, 2048, 0.0541015625, 0.000025],
        'MWRI':  [110.8, 2048, 0.0541,  0.000025],
        'IRAS':  [ 99.0,   56, 1.76785, 0.000025],
        'MWHS':  [106.7,   98, 1.08877, 0.000025],
        'MWTS':  [ 96.6,   15, 6.44,    0.000025],
        'TOU':   [108.0,   31, 3.483870, 0.000025],
        'SBUS':  [14.08,    4, 3.51897, 0.000025],
        'ERM':   [100.0,  150, 0.6667,  0.000025],
    },

    'FY3B': {
        'MERSI': [110.800003, 2048, 0.054100, 0.000025],
        'VIRR':  [110.800003, 2048, 0.054100, 0.000025],
        'MWRI':  [110.8,      2048, 0.0541,   0.000025],
        'IRAS':  [99.0,         56, 1.76785,  0.000025],
        'MWHS':  [106.7,        98, 1.08877,  0.000025],
        'MWTS':  [96.6,         15, 6.44,     0.000025],
        'TOU':   [108.0,        31, 3.483870, 0.000025],
        'SBUS':  [ 14.08,        4, 3.51897,  0.000025],
        'ERM':   [100,         150, 0.6667,   0.000025],
    },

    'FY3C': {
        'MERSI': [110.800003, 2048, 0.054100, 0.000025],
        'VIRR':  [110.800003, 2048, 0.054100, 0.000025],
        'MWRI':  [110.8,      2048, 0.0541,   0.000025],
        'IRAS':  [99.0,         56, 1.76785,  0.000025],
        'MWHS':  [106.7,        98, 1.08877,  0.000025],
        'MWTS':  [96.6,         15, 6.44,     0.000025],
        'TOU':   [108.0,        31, 3.483870, 0.000025],
        'SBUS':  [14.08,         4, 3.51897,  0.000025],
        'ERM':   [100,         150, 0.6667,   0.000025],
        'GNOS':  [100,         150, 0.6667,   0.000025],
    },

    'FY3D': {
        'MERSI': [110.800003, 2048, 0.054100, 0.000025],
        'VIRR':  [110.800003, 2048, 0.054100, 0.000025],
        'MWRI':  [110.8,      2048, 0.0541,   0.000025],
        'IRAS':  [99.0,         56, 1.76785,  0.000025],
        'MWHS':  [106.7,        98, 1.08877,  0.000025],
        'MWTS':  [96.6,         15, 6.44,     0.000025],
        'TOU':   [108.0,        31, 3.483870, 0.000025],
        'SBUS':  [ 14.08,        4, 3.51897,  0.000025],
        'ERM':   [100,         150, 0.6667,   0.000025],
    },

    'TERRA': {
        'MODIS': [110.8, 2048, 0.0541,  0.000025],
    },

    'AQUA':  {
        'MODIS': [110.8, 2048, 0.0541,  0.000025],
    },

    'NA17': {
        'AVHRR': [110.8, 2048, 0.0541,  0.000025],
    },

    'HY1B': {
        'CCD':   [110.8, 2048, 0.0541,  0.000025],
        'CZI':   [114.0, 1664, 0.0686,  0.000032],
    },

    'NA16': {
        'AVHRR': [36.0,  2048, 0.0176, 0.000008],
    },

    'NA18': {
        'AVHRR': [110.8, 2048, 0.0541, 0.000025],
    },

    'TAN1': {
        'CAPI':  [110.800003, 2048, 0.054100, 0.000025],
    },

    'OCO2': {
        'OCO2':  [110.800003, 2048, 0.054100, 0.000025],
    },
}
