import struct
import asyncio
from enum import IntEnum
# size 4字节，cmd 4字节，data n字节


class ReverseProto:
    def __init__(self, owner, reader: asyncio.StreamReader, writer: asyncio.StreamWriter):
        self.owner = owner
        self.reader = reader
        self.writer = writer
        self.status = 0

    def heart(self):
        if self.writer.is_closing():
            return
        data = b'hello'
        self.writer.write(struct.pack("!II", len(data), 12345))
        self.writer.write(data)
        asyncio.get_event_loop().call_later(1, self.heart)

    async def run(self):
        try:
            while not self.writer.is_closing():
                header = await self.reader.readexactly(8)
                size, cmd = struct.unpack("!II", header)
                data = await self.reader.readexactly(size)
                await self.owner.on_read(cmd, data)
        except:
            pass
        await self.owner.close()

    async def send(self, cmd: int, data: bytes):
        if self.writer.is_closing():
            return
        self.writer.write(struct.pack("!II", len(data), cmd))
        self.writer.write(data)
        await self.writer.drain()


class ReverseCmd(IntEnum):
    OpenServer = 1              # 服务器开一个服务器，监听某端口
    OnRemoteConnect = 2         # 开的服务器被连接了，开两个连接，一个连接到本地服务，一个连接到服务器用于传输数据
    TransData = 3               # 传输 用户数据
    RegistLocal = 4
