"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTarballFromUrl = extractTarballFromUrl;
exports.getLocalRegistryTarballUri = getLocalRegistryTarballUri;
var _debug = _interopRequireDefault(require("debug"));
var _url = _interopRequireDefault(require("url"));
var _url2 = require("@verdaccio/url");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:core:url');
function extractTarballFromUrl(url) {
  // @ts-ignore
  return _url.default.parse(url).pathname.replace(/^.*\//, '');
}
/**
 * Filter a tarball url.
 * @param {*} uri
 * @return {String} a parsed url
 */
function getLocalRegistryTarballUri(uri, pkgName, requestOptions, urlPrefix) {
  var _requestOptions$heade;
  const currentHost = requestOptions === null || requestOptions === void 0 ? void 0 : (_requestOptions$heade = requestOptions.headers) === null || _requestOptions$heade === void 0 ? void 0 : _requestOptions$heade.host;
  if (!currentHost) {
    return uri;
  }
  const tarballName = extractTarballFromUrl(uri);
  debug('tarball name %o', tarballName);
  // header only set with proxy that setup with HTTPS
  const domainRegistry = (0, _url2.getPublicUrl)(urlPrefix || '', requestOptions);
  return `${domainRegistry}${pkgName}/-/${tarballName}`;
}
//# sourceMappingURL=getLocalRegistryTarballUri.js.map