import { ISignal } from '@lumino/signaling';
import { CellRenderer } from './cellrenderer';
import { DataModel } from './datamodel';
/**
 * A class which manages the mapping of cell renderers.
 */
export declare class RendererMap {
    /**
     * Construct a new renderer map.
     *
     * @param values - The initial values for the map.
     *
     * @param fallback - The renderer of last resort.
     */
    constructor(values?: RendererMap.Values, fallback?: CellRenderer);
    /**
     * A signal emitted when the renderer map has changed.
     */
    get changed(): ISignal<this, void>;
    /**
     * Get the cell renderer to use for the given cell config.
     *
     * @param config - The cell config of interest.
     *
     * @returns The renderer to use for the cell.
     */
    get(config: CellRenderer.CellConfig): CellRenderer;
    /**
     * Update the renderer map with new values
     *
     * @param values - The updated values for the map.
     *
     * @param fallback - The renderer of last resort.
     *
     * #### Notes
     * This method always emits the `changed` signal.
     */
    update(values?: RendererMap.Values, fallback?: CellRenderer): void;
    private _fallback;
    private _values;
    private _changed;
}
/**
 * The namespace for the `RendererMap` class statics.
 */
export declare namespace RendererMap {
    /**
     * A type alias for a cell renderer resolver function.
     */
    type Resolver = CellRenderer.ConfigFunc<CellRenderer | undefined>;
    /**
     * A type alias for a `RendererMap` values type.
     */
    type Values = {
        [R in DataModel.CellRegion]?: Resolver | CellRenderer | undefined;
    };
}
