import { CellRenderer } from './cellrenderer';
import { GraphicsContext } from './graphicscontext';
import { TextRenderer } from './textrenderer';
/**
 * A cell renderer which renders data values as text.
 */
export declare class HyperlinkRenderer extends TextRenderer {
    /**
     * Construct a new text renderer.
     *
     * @param options - The options for initializing the renderer.
     */
    constructor(options?: HyperlinkRenderer.IOptions);
    /**
     * The URL address.
     */
    readonly url: CellRenderer.ConfigOption<string> | undefined;
    /**
     * The friendly link name.
     */
    readonly urlName: CellRenderer.ConfigOption<string> | undefined;
    /**
     * Draw the text for the cell.
     *
     * @param gc - The graphics context to use for drawing.
     *
     * @param config - The configuration data for the cell.
     */
    drawText(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
}
export declare namespace HyperlinkRenderer {
    /**
     * A type alias for the supported vertical alignment modes.
     */
    type VerticalAlignment = 'top' | 'center' | 'bottom';
    /**
     * A type alias for the supported horizontal alignment modes.
     */
    type HorizontalAlignment = 'left' | 'center' | 'right';
    /**
     * A type alias for the supported ellipsis sides.
     */
    type ElideDirection = 'left' | 'right' | 'none';
    /**
     * An options object for initializing a text renderer.
     */
    interface IOptions extends TextRenderer.IOptions {
        /**
         * The URL address
         */
        url?: CellRenderer.ConfigOption<string> | undefined;
        /**
         * The friendly link name.
         *
         * The default is the URL itself.
         */
        urlName?: CellRenderer.ConfigOption<string> | undefined;
    }
}
