import { DataModel } from './datamodel';
import { SelectionModel } from './selectionmodel';
/**
 * A basic selection model implementation.
 *
 * #### Notes
 * This selection model is sufficient for most use cases where
 * structural knowledge of the data source is *not* required.
 */
export declare class BasicSelectionModel extends SelectionModel {
    /**
     * Whether the selection model is empty.
     */
    get isEmpty(): boolean;
    /**
     * The row index of the cursor.
     */
    get cursorRow(): number;
    /**
     * The column index of the cursor.
     */
    get cursorColumn(): number;
    /**
     * Move cursor down/up/left/right while making sure it remains
     * within the bounds of selected rectangles
     *
     * @param direction - The direction of the movement.
     */
    moveCursorWithinSelections(direction: SelectionModel.CursorMoveDirection): void;
    /**
     * Get the current selection in the selection model.
     *
     * @returns The current selection or `null`.
     *
     * #### Notes
     * This is the selection which holds the cursor.
     */
    currentSelection(): SelectionModel.Selection | null;
    /**
     * Get an iterator of the selections in the model.
     *
     * @returns A new iterator of the current selections.
     *
     * #### Notes
     * The data grid will render the selections in order.
     */
    selections(): IterableIterator<SelectionModel.Selection>;
    /**
     * Select the specified cells.
     *
     * @param args - The arguments for the selection.
     */
    select(args: SelectionModel.SelectArgs): void;
    /**
     * Clear all selections in the selection model.
     */
    clear(): void;
    /**
     * A signal handler for the data model `changed` signal.
     *
     * @param args - The arguments for the signal.
     */
    protected onDataModelChanged(sender: DataModel, args: DataModel.ChangedArgs): void;
    private _cursorRow;
    private _cursorColumn;
    private _cursorRectIndex;
    private _selections;
}
