import { DataGrid } from './datagrid';
/**
 * A basic implementation of a data grid key handler.
 *
 * #### Notes
 * This class may be subclassed and customized as needed.
 */
export declare class BasicKeyHandler implements DataGrid.IKeyHandler {
    /**
     * Whether the key handler is disposed.
     */
    get isDisposed(): boolean;
    /**
     * Dispose of the resources held by the key handler.
     */
    dispose(): void;
    /**
     * Handle the key down event for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keydown event of interest.
     *
     * #### Notes
     * This will not be called if the mouse button is pressed.
     */
    onKeyDown(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'ArrowLeft'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onArrowLeft(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'ArrowRight'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onArrowRight(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'ArrowUp'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onArrowUp(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'ArrowDown'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onArrowDown(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'PageUp'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onPageUp(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'PageDown'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onPageDown(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'Escape'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onEscape(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'Delete'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onDelete(grid: DataGrid, event: KeyboardEvent): void;
    /**
     * Handle the `'C'` key press for the data grid.
     *
     * @param grid - The data grid of interest.
     *
     * @param event - The keyboard event of interest.
     */
    protected onKeyC(grid: DataGrid, event: KeyboardEvent): void;
    private _disposed;
}
