(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactJsonTree = {}, global.React));
})(this, (function (exports, React) { 'use strict';

  function _mergeNamespaces(n, m) {
    m.forEach(function (e) {
      e && typeof e !== 'string' && !Array.isArray(e) && Object.keys(e).forEach(function (k) {
        if (k !== 'default' && !(k in n)) {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    });
    return Object.freeze(n);
  }

  function objType(obj) {
    const type = Object.prototype.toString.call(obj).slice(8, -1);
    if (type === 'Object' && typeof obj[Symbol.iterator] === 'function') {
      return 'Iterable';
    }
    if (type === 'Custom' && obj.constructor !== Object && obj instanceof Object) {
      // For projects implementing objects overriding `.prototype[Symbol.toStringTag]`
      return 'Object';
    }
    return type;
  }

  function JSONArrow(_ref) {
    let {
      styling,
      arrowStyle = 'single',
      expanded,
      nodeType,
      onClick
    } = _ref;
    return /*#__PURE__*/React.createElement("div", {
      ...styling('arrowContainer', arrowStyle),
      onClick: onClick
    }, /*#__PURE__*/React.createElement("div", {
      ...styling(['arrow', 'arrowSign'], nodeType, expanded, arrowStyle)
    }, '\u25B6', arrowStyle === 'double' && /*#__PURE__*/React.createElement("div", {
      ...styling(['arrowSign', 'arrowSignInner'])
    }, '\u25B6')));
  }

  function getLength(type, collection) {
    if (type === 'Object') {
      // eslint-disable-next-line @typescript-eslint/ban-types
      return Object.keys(collection).length;
    } else if (type === 'Array') {
      return collection.length;
    }
    return Infinity;
  }
  function isIterableMap(collection) {
    return typeof collection.set === 'function';
  }
  function getEntries(type, collection, sortObjectKeys) {
    let from = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    let to = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : Infinity;
    let res;
    if (type === 'Object') {
      let keys = Object.getOwnPropertyNames(collection);
      if (sortObjectKeys) {
        keys.sort(sortObjectKeys === true ? undefined : sortObjectKeys);
      }
      keys = keys.slice(from, to + 1);
      res = {
        entries: keys.map(key => ({
          key,
          value: collection[key]
        }))
      };
    } else if (type === 'Array') {
      res = {
        entries: collection.slice(from, to + 1).map((val, idx) => ({
          key: idx + from,
          value: val
        }))
      };
    } else {
      let idx = 0;
      const entries = [];
      let done = true;
      const isMap = isIterableMap(collection);
      for (const item of collection) {
        if (idx > to) {
          done = false;
          break;
        }
        if (from <= idx) {
          if (isMap && Array.isArray(item)) {
            if (typeof item[0] === 'string' || typeof item[0] === 'number') {
              entries.push({
                key: item[0],
                value: item[1]
              });
            } else {
              entries.push({
                key: `[entry ${idx}]`,
                value: {
                  '[key]': item[0],
                  '[value]': item[1]
                }
              });
            }
          } else {
            entries.push({
              key: idx,
              value: item
            });
          }
        }
        idx++;
      }
      res = {
        hasMore: !done,
        entries
      };
    }
    return res;
  }
  function getRanges(from, to, limit) {
    const ranges = [];
    while (to - from > limit * limit) {
      limit = limit * limit;
    }
    for (let i = from; i <= to; i += limit) {
      ranges.push({
        from: i,
        to: Math.min(to, i + limit - 1)
      });
    }
    return ranges;
  }
  function getCollectionEntries(type, collection, sortObjectKeys, limit) {
    let from = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
    let to = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : Infinity;
    const getEntriesBound = getEntries.bind(null, type, collection, sortObjectKeys);
    if (!limit) {
      return getEntriesBound().entries;
    }
    const isSubset = to < Infinity;
    const length = Math.min(to - from, getLength(type, collection));
    if (type !== 'Iterable') {
      if (length <= limit || limit < 7) {
        return getEntriesBound(from, to).entries;
      }
    } else {
      if (length <= limit && !isSubset) {
        return getEntriesBound(from, to).entries;
      }
    }
    let limitedEntries;
    if (type === 'Iterable') {
      const {
        hasMore,
        entries
      } = getEntriesBound(from, from + limit - 1);
      limitedEntries = hasMore ? [...entries, ...getRanges(from + limit, from + 2 * limit - 1, limit)] : entries;
    } else {
      limitedEntries = isSubset ? getRanges(from, to, limit) : [...getEntriesBound(0, limit - 5).entries, ...getRanges(limit - 4, length - 5, limit), ...getEntriesBound(length - 4, length - 1).entries];
    }
    return limitedEntries;
  }

  function ItemRange(props) {
    const {
      styling,
      from,
      to,
      renderChildNodes,
      nodeType
    } = props;
    const [expanded, setExpanded] = React.useState(false);
    const handleClick = React.useCallback(() => {
      setExpanded(!expanded);
    }, [expanded]);
    return expanded ? /*#__PURE__*/React.createElement("div", {
      ...styling('itemRange', expanded)
    }, renderChildNodes(props, from, to)) : /*#__PURE__*/React.createElement("div", {
      ...styling('itemRange', expanded),
      onClick: handleClick
    }, /*#__PURE__*/React.createElement(JSONArrow, {
      nodeType: nodeType,
      styling: styling,
      expanded: false,
      onClick: handleClick,
      arrowStyle: "double"
    }), `${from} ... ${to}`);
  }

  function isRange(rangeOrEntry) {
    return rangeOrEntry.to !== undefined;
  }
  function renderChildNodes(props, from, to) {
    const {
      nodeType,
      data,
      collectionLimit,
      circularCache,
      keyPath,
      postprocessValue,
      sortObjectKeys
    } = props;
    const childNodes = [];
    getCollectionEntries(nodeType, data, sortObjectKeys, collectionLimit, from, to).forEach(entry => {
      if (isRange(entry)) {
        childNodes.push( /*#__PURE__*/React.createElement(ItemRange, {
          ...props,
          key: `ItemRange--${entry.from}-${entry.to}`,
          from: entry.from,
          to: entry.to,
          renderChildNodes: renderChildNodes
        }));
      } else {
        const {
          key,
          value
        } = entry;
        const isCircular = circularCache.indexOf(value) !== -1;
        childNodes.push( /*#__PURE__*/React.createElement(JSONNode, {
          ...props,
          ...{
            postprocessValue,
            collectionLimit
          },
          key: `Node--${key}`,
          keyPath: [key, ...keyPath],
          value: postprocessValue(value),
          circularCache: [...circularCache, value],
          isCircular: isCircular,
          hideRoot: false
        }));
      }
    });
    return childNodes;
  }
  function JSONNestedNode(props) {
    const {
      circularCache = [],
      collectionLimit,
      createItemString,
      data,
      expandable,
      getItemString,
      hideRoot,
      isCircular,
      keyPath,
      labelRenderer,
      level = 0,
      nodeType,
      nodeTypeIndicator,
      shouldExpandNodeInitially,
      styling
    } = props;
    const [expanded, setExpanded] = React.useState(
    // calculate individual node expansion if necessary
    isCircular ? false : shouldExpandNodeInitially(keyPath, data, level));
    const handleClick = React.useCallback(() => {
      if (expandable) setExpanded(!expanded);
    }, [expandable, expanded]);
    const renderedChildren = expanded || hideRoot && level === 0 ? renderChildNodes({
      ...props,
      circularCache,
      level: level + 1
    }) : null;
    const itemType = /*#__PURE__*/React.createElement("span", {
      ...styling('nestedNodeItemType', expanded)
    }, nodeTypeIndicator);
    const renderedItemString = getItemString(nodeType, data, itemType, createItemString(data, collectionLimit), keyPath);
    const stylingArgs = [keyPath, nodeType, expanded, expandable];
    return hideRoot ? /*#__PURE__*/React.createElement("li", {
      ...styling('rootNode', ...stylingArgs)
    }, /*#__PURE__*/React.createElement("ul", {
      ...styling('rootNodeChildren', ...stylingArgs)
    }, renderedChildren)) : /*#__PURE__*/React.createElement("li", {
      ...styling('nestedNode', ...stylingArgs)
    }, expandable && /*#__PURE__*/React.createElement(JSONArrow, {
      styling: styling,
      nodeType: nodeType,
      expanded: expanded,
      onClick: handleClick
    }), /*#__PURE__*/React.createElement("label", {
      ...styling(['label', 'nestedNodeLabel'], ...stylingArgs),
      onClick: handleClick
    }, labelRenderer(...stylingArgs)), /*#__PURE__*/React.createElement("span", {
      ...styling('nestedNodeItemString', ...stylingArgs),
      onClick: handleClick
    }, renderedItemString), /*#__PURE__*/React.createElement("ul", {
      ...styling('nestedNodeChildren', ...stylingArgs)
    }, renderedChildren));
  }

  // Returns the "n Items" string for this node,
  // generating and caching it if it hasn't been created yet.
  function createItemString$2(data) {
    const len = Object.getOwnPropertyNames(data).length;
    return `${len} ${len !== 1 ? 'keys' : 'key'}`;
  }
  // Configures <JSONNestedNode> to render an Object
  function JSONObjectNode(_ref) {
    let {
      data,
      ...props
    } = _ref;
    return /*#__PURE__*/React.createElement(JSONNestedNode, {
      ...props,
      data: data,
      nodeType: "Object",
      nodeTypeIndicator: props.nodeType === 'Error' ? 'Error()' : '{}',
      createItemString: createItemString$2,
      expandable: Object.getOwnPropertyNames(data).length > 0
    });
  }

  // Returns the "n Items" string for this node,
  // generating and caching it if it hasn't been created yet.
  function createItemString$1(data) {
    return `${data.length} ${data.length !== 1 ? 'items' : 'item'}`;
  }
  // Configures <JSONNestedNode> to render an Array
  function JSONArrayNode(_ref) {
    let {
      data,
      ...props
    } = _ref;
    return /*#__PURE__*/React.createElement(JSONNestedNode, {
      ...props,
      data: data,
      nodeType: "Array",
      nodeTypeIndicator: "[]",
      createItemString: createItemString$1,
      expandable: data.length > 0
    });
  }

  // Returns the "n Items" string for this node,
  // generating and caching it if it hasn't been created yet.
  function createItemString(data, limit) {
    let count = 0;
    let hasMore = false;
    if (Number.isSafeInteger(data.size)) {
      count = data.size;
    } else {
      // eslint-disable-next-line no-unused-vars
      for (const entry of data) {
        if (limit && count + 1 > limit) {
          hasMore = true;
          break;
        }
        count += 1;
      }
    }
    return `${hasMore ? '>' : ''}${count} ${count !== 1 ? 'entries' : 'entry'}`;
  }
  // Configures <JSONNestedNode> to render an iterable
  function JSONIterableNode(props) {
    return /*#__PURE__*/React.createElement(JSONNestedNode, {
      ...props,
      nodeType: "Iterable",
      nodeTypeIndicator: "()",
      createItemString: createItemString,
      expandable: true
    });
  }

  function JSONValueNode(_ref) {
    let {
      nodeType,
      styling,
      labelRenderer,
      keyPath,
      valueRenderer,
      value,
      valueGetter = value => value
    } = _ref;
    return /*#__PURE__*/React.createElement("li", {
      ...styling('value', nodeType, keyPath)
    }, /*#__PURE__*/React.createElement("label", {
      ...styling(['label', 'valueLabel'], nodeType, keyPath)
    }, labelRenderer(keyPath, nodeType, false, false)), /*#__PURE__*/React.createElement("span", {
      ...styling('valueText', nodeType, keyPath)
    }, valueRenderer(valueGetter(value), value, ...keyPath)));
  }

  function JSONNode(_ref) {
    let {
      getItemString,
      keyPath,
      labelRenderer,
      styling,
      value,
      valueRenderer,
      isCustomNode,
      ...rest
    } = _ref;
    const nodeType = isCustomNode(value) ? 'Custom' : objType(value);
    const simpleNodeProps = {
      getItemString,
      key: keyPath[0],
      keyPath,
      labelRenderer,
      nodeType,
      styling,
      value,
      valueRenderer
    };
    const nestedNodeProps = {
      ...rest,
      ...simpleNodeProps,
      data: value,
      isCustomNode
    };
    switch (nodeType) {
      case 'Object':
      case 'Error':
      case 'WeakMap':
      case 'WeakSet':
        return /*#__PURE__*/React.createElement(JSONObjectNode, {
          ...nestedNodeProps
        });
      case 'Array':
        return /*#__PURE__*/React.createElement(JSONArrayNode, {
          ...nestedNodeProps
        });
      case 'Iterable':
      case 'Map':
      case 'Set':
        return /*#__PURE__*/React.createElement(JSONIterableNode, {
          ...nestedNodeProps
        });
      case 'String':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: raw => `"${raw}"`
        });
      case 'Number':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps
        });
      case 'Boolean':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: raw => raw ? 'true' : 'false'
        });
      case 'Date':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: raw => raw.toISOString()
        });
      case 'Null':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: () => 'null'
        });
      case 'Undefined':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: () => 'undefined'
        });
      case 'Function':
      case 'Symbol':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: raw => raw.toString()
        });
      case 'Custom':
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps
        });
      default:
        return /*#__PURE__*/React.createElement(JSONValueNode, {
          ...simpleNodeProps,
          valueGetter: () => `<${nodeType}>`
        });
    }
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  var lib = {};

  var threezerotwofourExports = {};
  var threezerotwofour = {
    get exports(){ return threezerotwofourExports; },
    set exports(v){ threezerotwofourExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'threezerotwofour',
  	  author: 'jan t. sott (http://github.com/idleberg)',
  	  base00: '#090300',
  	  base01: '#3a3432',
  	  base02: '#4a4543',
  	  base03: '#5c5855',
  	  base04: '#807d7c',
  	  base05: '#a5a2a2',
  	  base06: '#d6d5d4',
  	  base07: '#f7f7f7',
  	  base08: '#db2d20',
  	  base09: '#e8bbd0',
  	  base0A: '#fded02',
  	  base0B: '#01a252',
  	  base0C: '#b5e4f4',
  	  base0D: '#01a0e4',
  	  base0E: '#a16a94',
  	  base0F: '#cdab53'
  	};
  	module.exports = exports['default'];
  } (threezerotwofour, threezerotwofourExports));

  var apathyExports = {};
  var apathy = {
    get exports(){ return apathyExports; },
    set exports(v){ apathyExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'apathy',
  	  author: 'jannik siebert (https://github.com/janniks)',
  	  base00: '#031A16',
  	  base01: '#0B342D',
  	  base02: '#184E45',
  	  base03: '#2B685E',
  	  base04: '#5F9C92',
  	  base05: '#81B5AC',
  	  base06: '#A7CEC8',
  	  base07: '#D2E7E4',
  	  base08: '#3E9688',
  	  base09: '#3E7996',
  	  base0A: '#3E4C96',
  	  base0B: '#883E96',
  	  base0C: '#963E4C',
  	  base0D: '#96883E',
  	  base0E: '#4C963E',
  	  base0F: '#3E965B'
  	};
  	module.exports = exports['default'];
  } (apathy, apathyExports));

  var ashesExports = {};
  var ashes = {
    get exports(){ return ashesExports; },
    set exports(v){ ashesExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'ashes',
  	  author: 'jannik siebert (https://github.com/janniks)',
  	  base00: '#1C2023',
  	  base01: '#393F45',
  	  base02: '#565E65',
  	  base03: '#747C84',
  	  base04: '#ADB3BA',
  	  base05: '#C7CCD1',
  	  base06: '#DFE2E5',
  	  base07: '#F3F4F5',
  	  base08: '#C7AE95',
  	  base09: '#C7C795',
  	  base0A: '#AEC795',
  	  base0B: '#95C7AE',
  	  base0C: '#95AEC7',
  	  base0D: '#AE95C7',
  	  base0E: '#C795AE',
  	  base0F: '#C79595'
  	};
  	module.exports = exports['default'];
  } (ashes, ashesExports));

  var atelierDuneExports = {};
  var atelierDune = {
    get exports(){ return atelierDuneExports; },
    set exports(v){ atelierDuneExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'atelier dune',
  	  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/dune)',
  	  base00: '#20201d',
  	  base01: '#292824',
  	  base02: '#6e6b5e',
  	  base03: '#7d7a68',
  	  base04: '#999580',
  	  base05: '#a6a28c',
  	  base06: '#e8e4cf',
  	  base07: '#fefbec',
  	  base08: '#d73737',
  	  base09: '#b65611',
  	  base0A: '#cfb017',
  	  base0B: '#60ac39',
  	  base0C: '#1fad83',
  	  base0D: '#6684e1',
  	  base0E: '#b854d4',
  	  base0F: '#d43552'
  	};
  	module.exports = exports['default'];
  } (atelierDune, atelierDuneExports));

  var atelierForestExports = {};
  var atelierForest = {
    get exports(){ return atelierForestExports; },
    set exports(v){ atelierForestExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'atelier forest',
  	  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/forest)',
  	  base00: '#1b1918',
  	  base01: '#2c2421',
  	  base02: '#68615e',
  	  base03: '#766e6b',
  	  base04: '#9c9491',
  	  base05: '#a8a19f',
  	  base06: '#e6e2e0',
  	  base07: '#f1efee',
  	  base08: '#f22c40',
  	  base09: '#df5320',
  	  base0A: '#d5911a',
  	  base0B: '#5ab738',
  	  base0C: '#00ad9c',
  	  base0D: '#407ee7',
  	  base0E: '#6666ea',
  	  base0F: '#c33ff3'
  	};
  	module.exports = exports['default'];
  } (atelierForest, atelierForestExports));

  var atelierHeathExports = {};
  var atelierHeath = {
    get exports(){ return atelierHeathExports; },
    set exports(v){ atelierHeathExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'atelier heath',
  	  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/heath)',
  	  base00: '#1b181b',
  	  base01: '#292329',
  	  base02: '#695d69',
  	  base03: '#776977',
  	  base04: '#9e8f9e',
  	  base05: '#ab9bab',
  	  base06: '#d8cad8',
  	  base07: '#f7f3f7',
  	  base08: '#ca402b',
  	  base09: '#a65926',
  	  base0A: '#bb8a35',
  	  base0B: '#379a37',
  	  base0C: '#159393',
  	  base0D: '#516aec',
  	  base0E: '#7b59c0',
  	  base0F: '#cc33cc'
  	};
  	module.exports = exports['default'];
  } (atelierHeath, atelierHeathExports));

  var atelierLakesideExports = {};
  var atelierLakeside = {
    get exports(){ return atelierLakesideExports; },
    set exports(v){ atelierLakesideExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'atelier lakeside',
  	  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/lakeside/)',
  	  base00: '#161b1d',
  	  base01: '#1f292e',
  	  base02: '#516d7b',
  	  base03: '#5a7b8c',
  	  base04: '#7195a8',
  	  base05: '#7ea2b4',
  	  base06: '#c1e4f6',
  	  base07: '#ebf8ff',
  	  base08: '#d22d72',
  	  base09: '#935c25',
  	  base0A: '#8a8a0f',
  	  base0B: '#568c3b',
  	  base0C: '#2d8f6f',
  	  base0D: '#257fad',
  	  base0E: '#5d5db1',
  	  base0F: '#b72dd2'
  	};
  	module.exports = exports['default'];
  } (atelierLakeside, atelierLakesideExports));

  var atelierSeasideExports = {};
  var atelierSeaside = {
    get exports(){ return atelierSeasideExports; },
    set exports(v){ atelierSeasideExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'atelier seaside',
  	  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/seaside/)',
  	  base00: '#131513',
  	  base01: '#242924',
  	  base02: '#5e6e5e',
  	  base03: '#687d68',
  	  base04: '#809980',
  	  base05: '#8ca68c',
  	  base06: '#cfe8cf',
  	  base07: '#f0fff0',
  	  base08: '#e6193c',
  	  base09: '#87711d',
  	  base0A: '#c3c322',
  	  base0B: '#29a329',
  	  base0C: '#1999b3',
  	  base0D: '#3d62f5',
  	  base0E: '#ad2bee',
  	  base0F: '#e619c3'
  	};
  	module.exports = exports['default'];
  } (atelierSeaside, atelierSeasideExports));

  var bespinExports = {};
  var bespin = {
    get exports(){ return bespinExports; },
    set exports(v){ bespinExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'bespin',
  	  author: 'jan t. sott',
  	  base00: '#28211c',
  	  base01: '#36312e',
  	  base02: '#5e5d5c',
  	  base03: '#666666',
  	  base04: '#797977',
  	  base05: '#8a8986',
  	  base06: '#9d9b97',
  	  base07: '#baae9e',
  	  base08: '#cf6a4c',
  	  base09: '#cf7d34',
  	  base0A: '#f9ee98',
  	  base0B: '#54be0d',
  	  base0C: '#afc4db',
  	  base0D: '#5ea6ea',
  	  base0E: '#9b859d',
  	  base0F: '#937121'
  	};
  	module.exports = exports['default'];
  } (bespin, bespinExports));

  var brewerExports = {};
  var brewer = {
    get exports(){ return brewerExports; },
    set exports(v){ brewerExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'brewer',
  	  author: 'timothée poisot (http://github.com/tpoisot)',
  	  base00: '#0c0d0e',
  	  base01: '#2e2f30',
  	  base02: '#515253',
  	  base03: '#737475',
  	  base04: '#959697',
  	  base05: '#b7b8b9',
  	  base06: '#dadbdc',
  	  base07: '#fcfdfe',
  	  base08: '#e31a1c',
  	  base09: '#e6550d',
  	  base0A: '#dca060',
  	  base0B: '#31a354',
  	  base0C: '#80b1d3',
  	  base0D: '#3182bd',
  	  base0E: '#756bb1',
  	  base0F: '#b15928'
  	};
  	module.exports = exports['default'];
  } (brewer, brewerExports));

  var brightExports = {};
  var bright = {
    get exports(){ return brightExports; },
    set exports(v){ brightExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'bright',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#000000',
  	  base01: '#303030',
  	  base02: '#505050',
  	  base03: '#b0b0b0',
  	  base04: '#d0d0d0',
  	  base05: '#e0e0e0',
  	  base06: '#f5f5f5',
  	  base07: '#ffffff',
  	  base08: '#fb0120',
  	  base09: '#fc6d24',
  	  base0A: '#fda331',
  	  base0B: '#a1c659',
  	  base0C: '#76c7b7',
  	  base0D: '#6fb3d2',
  	  base0E: '#d381c3',
  	  base0F: '#be643c'
  	};
  	module.exports = exports['default'];
  } (bright, brightExports));

  var chalkExports = {};
  var chalk = {
    get exports(){ return chalkExports; },
    set exports(v){ chalkExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'chalk',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#151515',
  	  base01: '#202020',
  	  base02: '#303030',
  	  base03: '#505050',
  	  base04: '#b0b0b0',
  	  base05: '#d0d0d0',
  	  base06: '#e0e0e0',
  	  base07: '#f5f5f5',
  	  base08: '#fb9fb1',
  	  base09: '#eda987',
  	  base0A: '#ddb26f',
  	  base0B: '#acc267',
  	  base0C: '#12cfc0',
  	  base0D: '#6fc2ef',
  	  base0E: '#e1a3ee',
  	  base0F: '#deaf8f'
  	};
  	module.exports = exports['default'];
  } (chalk, chalkExports));

  var codeschoolExports = {};
  var codeschool = {
    get exports(){ return codeschoolExports; },
    set exports(v){ codeschoolExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'codeschool',
  	  author: 'brettof86',
  	  base00: '#232c31',
  	  base01: '#1c3657',
  	  base02: '#2a343a',
  	  base03: '#3f4944',
  	  base04: '#84898c',
  	  base05: '#9ea7a6',
  	  base06: '#a7cfa3',
  	  base07: '#b5d8f6',
  	  base08: '#2a5491',
  	  base09: '#43820d',
  	  base0A: '#a03b1e',
  	  base0B: '#237986',
  	  base0C: '#b02f30',
  	  base0D: '#484d79',
  	  base0E: '#c59820',
  	  base0F: '#c98344'
  	};
  	module.exports = exports['default'];
  } (codeschool, codeschoolExports));

  var colorsExports = {};
  var colors = {
    get exports(){ return colorsExports; },
    set exports(v){ colorsExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'colors',
  	  author: 'mrmrs (http://clrs.cc)',
  	  base00: '#111111',
  	  base01: '#333333',
  	  base02: '#555555',
  	  base03: '#777777',
  	  base04: '#999999',
  	  base05: '#bbbbbb',
  	  base06: '#dddddd',
  	  base07: '#ffffff',
  	  base08: '#ff4136',
  	  base09: '#ff851b',
  	  base0A: '#ffdc00',
  	  base0B: '#2ecc40',
  	  base0C: '#7fdbff',
  	  base0D: '#0074d9',
  	  base0E: '#b10dc9',
  	  base0F: '#85144b'
  	};
  	module.exports = exports['default'];
  } (colors, colorsExports));

  var _defaultExports = {};
  var _default = {
    get exports(){ return _defaultExports; },
    set exports(v){ _defaultExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'default',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#181818',
  	  base01: '#282828',
  	  base02: '#383838',
  	  base03: '#585858',
  	  base04: '#b8b8b8',
  	  base05: '#d8d8d8',
  	  base06: '#e8e8e8',
  	  base07: '#f8f8f8',
  	  base08: '#ab4642',
  	  base09: '#dc9656',
  	  base0A: '#f7ca88',
  	  base0B: '#a1b56c',
  	  base0C: '#86c1b9',
  	  base0D: '#7cafc2',
  	  base0E: '#ba8baf',
  	  base0F: '#a16946'
  	};
  	module.exports = exports['default'];
  } (_default, _defaultExports));

  var eightiesExports = {};
  var eighties = {
    get exports(){ return eightiesExports; },
    set exports(v){ eightiesExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'eighties',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#2d2d2d',
  	  base01: '#393939',
  	  base02: '#515151',
  	  base03: '#747369',
  	  base04: '#a09f93',
  	  base05: '#d3d0c8',
  	  base06: '#e8e6df',
  	  base07: '#f2f0ec',
  	  base08: '#f2777a',
  	  base09: '#f99157',
  	  base0A: '#ffcc66',
  	  base0B: '#99cc99',
  	  base0C: '#66cccc',
  	  base0D: '#6699cc',
  	  base0E: '#cc99cc',
  	  base0F: '#d27b53'
  	};
  	module.exports = exports['default'];
  } (eighties, eightiesExports));

  var embersExports = {};
  var embers = {
    get exports(){ return embersExports; },
    set exports(v){ embersExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'embers',
  	  author: 'jannik siebert (https://github.com/janniks)',
  	  base00: '#16130F',
  	  base01: '#2C2620',
  	  base02: '#433B32',
  	  base03: '#5A5047',
  	  base04: '#8A8075',
  	  base05: '#A39A90',
  	  base06: '#BEB6AE',
  	  base07: '#DBD6D1',
  	  base08: '#826D57',
  	  base09: '#828257',
  	  base0A: '#6D8257',
  	  base0B: '#57826D',
  	  base0C: '#576D82',
  	  base0D: '#6D5782',
  	  base0E: '#82576D',
  	  base0F: '#825757'
  	};
  	module.exports = exports['default'];
  } (embers, embersExports));

  var flatExports = {};
  var flat = {
    get exports(){ return flatExports; },
    set exports(v){ flatExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'flat',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#2C3E50',
  	  base01: '#34495E',
  	  base02: '#7F8C8D',
  	  base03: '#95A5A6',
  	  base04: '#BDC3C7',
  	  base05: '#e0e0e0',
  	  base06: '#f5f5f5',
  	  base07: '#ECF0F1',
  	  base08: '#E74C3C',
  	  base09: '#E67E22',
  	  base0A: '#F1C40F',
  	  base0B: '#2ECC71',
  	  base0C: '#1ABC9C',
  	  base0D: '#3498DB',
  	  base0E: '#9B59B6',
  	  base0F: '#be643c'
  	};
  	module.exports = exports['default'];
  } (flat, flatExports));

  var googleExports = {};
  var google = {
    get exports(){ return googleExports; },
    set exports(v){ googleExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'google',
  	  author: 'seth wright (http://sethawright.com)',
  	  base00: '#1d1f21',
  	  base01: '#282a2e',
  	  base02: '#373b41',
  	  base03: '#969896',
  	  base04: '#b4b7b4',
  	  base05: '#c5c8c6',
  	  base06: '#e0e0e0',
  	  base07: '#ffffff',
  	  base08: '#CC342B',
  	  base09: '#F96A38',
  	  base0A: '#FBA922',
  	  base0B: '#198844',
  	  base0C: '#3971ED',
  	  base0D: '#3971ED',
  	  base0E: '#A36AC7',
  	  base0F: '#3971ED'
  	};
  	module.exports = exports['default'];
  } (google, googleExports));

  var grayscaleExports = {};
  var grayscale = {
    get exports(){ return grayscaleExports; },
    set exports(v){ grayscaleExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'grayscale',
  	  author: 'alexandre gavioli (https://github.com/alexx2/)',
  	  base00: '#101010',
  	  base01: '#252525',
  	  base02: '#464646',
  	  base03: '#525252',
  	  base04: '#ababab',
  	  base05: '#b9b9b9',
  	  base06: '#e3e3e3',
  	  base07: '#f7f7f7',
  	  base08: '#7c7c7c',
  	  base09: '#999999',
  	  base0A: '#a0a0a0',
  	  base0B: '#8e8e8e',
  	  base0C: '#868686',
  	  base0D: '#686868',
  	  base0E: '#747474',
  	  base0F: '#5e5e5e'
  	};
  	module.exports = exports['default'];
  } (grayscale, grayscaleExports));

  var greenscreenExports = {};
  var greenscreen = {
    get exports(){ return greenscreenExports; },
    set exports(v){ greenscreenExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'green screen',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#001100',
  	  base01: '#003300',
  	  base02: '#005500',
  	  base03: '#007700',
  	  base04: '#009900',
  	  base05: '#00bb00',
  	  base06: '#00dd00',
  	  base07: '#00ff00',
  	  base08: '#007700',
  	  base09: '#009900',
  	  base0A: '#007700',
  	  base0B: '#00bb00',
  	  base0C: '#005500',
  	  base0D: '#009900',
  	  base0E: '#00bb00',
  	  base0F: '#005500'
  	};
  	module.exports = exports['default'];
  } (greenscreen, greenscreenExports));

  var harmonicExports = {};
  var harmonic = {
    get exports(){ return harmonicExports; },
    set exports(v){ harmonicExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'harmonic16',
  	  author: 'jannik siebert (https://github.com/janniks)',
  	  base00: '#0b1c2c',
  	  base01: '#223b54',
  	  base02: '#405c79',
  	  base03: '#627e99',
  	  base04: '#aabcce',
  	  base05: '#cbd6e2',
  	  base06: '#e5ebf1',
  	  base07: '#f7f9fb',
  	  base08: '#bf8b56',
  	  base09: '#bfbf56',
  	  base0A: '#8bbf56',
  	  base0B: '#56bf8b',
  	  base0C: '#568bbf',
  	  base0D: '#8b56bf',
  	  base0E: '#bf568b',
  	  base0F: '#bf5656'
  	};
  	module.exports = exports['default'];
  } (harmonic, harmonicExports));

  var hopscotchExports = {};
  var hopscotch = {
    get exports(){ return hopscotchExports; },
    set exports(v){ hopscotchExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'hopscotch',
  	  author: 'jan t. sott',
  	  base00: '#322931',
  	  base01: '#433b42',
  	  base02: '#5c545b',
  	  base03: '#797379',
  	  base04: '#989498',
  	  base05: '#b9b5b8',
  	  base06: '#d5d3d5',
  	  base07: '#ffffff',
  	  base08: '#dd464c',
  	  base09: '#fd8b19',
  	  base0A: '#fdcc59',
  	  base0B: '#8fc13e',
  	  base0C: '#149b93',
  	  base0D: '#1290bf',
  	  base0E: '#c85e7c',
  	  base0F: '#b33508'
  	};
  	module.exports = exports['default'];
  } (hopscotch, hopscotchExports));

  var isotopeExports = {};
  var isotope = {
    get exports(){ return isotopeExports; },
    set exports(v){ isotopeExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'isotope',
  	  author: 'jan t. sott',
  	  base00: '#000000',
  	  base01: '#404040',
  	  base02: '#606060',
  	  base03: '#808080',
  	  base04: '#c0c0c0',
  	  base05: '#d0d0d0',
  	  base06: '#e0e0e0',
  	  base07: '#ffffff',
  	  base08: '#ff0000',
  	  base09: '#ff9900',
  	  base0A: '#ff0099',
  	  base0B: '#33ff00',
  	  base0C: '#00ffff',
  	  base0D: '#0066ff',
  	  base0E: '#cc00ff',
  	  base0F: '#3300ff'
  	};
  	module.exports = exports['default'];
  } (isotope, isotopeExports));

  var marrakeshExports = {};
  var marrakesh = {
    get exports(){ return marrakeshExports; },
    set exports(v){ marrakeshExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'marrakesh',
  	  author: 'alexandre gavioli (http://github.com/alexx2/)',
  	  base00: '#201602',
  	  base01: '#302e00',
  	  base02: '#5f5b17',
  	  base03: '#6c6823',
  	  base04: '#86813b',
  	  base05: '#948e48',
  	  base06: '#ccc37a',
  	  base07: '#faf0a5',
  	  base08: '#c35359',
  	  base09: '#b36144',
  	  base0A: '#a88339',
  	  base0B: '#18974e',
  	  base0C: '#75a738',
  	  base0D: '#477ca1',
  	  base0E: '#8868b3',
  	  base0F: '#b3588e'
  	};
  	module.exports = exports['default'];
  } (marrakesh, marrakeshExports));

  var mochaExports = {};
  var mocha = {
    get exports(){ return mochaExports; },
    set exports(v){ mochaExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'mocha',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#3B3228',
  	  base01: '#534636',
  	  base02: '#645240',
  	  base03: '#7e705a',
  	  base04: '#b8afad',
  	  base05: '#d0c8c6',
  	  base06: '#e9e1dd',
  	  base07: '#f5eeeb',
  	  base08: '#cb6077',
  	  base09: '#d28b71',
  	  base0A: '#f4bc87',
  	  base0B: '#beb55b',
  	  base0C: '#7bbda4',
  	  base0D: '#8ab3b5',
  	  base0E: '#a89bb9',
  	  base0F: '#bb9584'
  	};
  	module.exports = exports['default'];
  } (mocha, mochaExports));

  var monokaiExports = {};
  var monokai = {
    get exports(){ return monokaiExports; },
    set exports(v){ monokaiExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'monokai',
  	  author: 'wimer hazenberg (http://www.monokai.nl)',
  	  base00: '#272822',
  	  base01: '#383830',
  	  base02: '#49483e',
  	  base03: '#75715e',
  	  base04: '#a59f85',
  	  base05: '#f8f8f2',
  	  base06: '#f5f4f1',
  	  base07: '#f9f8f5',
  	  base08: '#f92672',
  	  base09: '#fd971f',
  	  base0A: '#f4bf75',
  	  base0B: '#a6e22e',
  	  base0C: '#a1efe4',
  	  base0D: '#66d9ef',
  	  base0E: '#ae81ff',
  	  base0F: '#cc6633'
  	};
  	module.exports = exports['default'];
  } (monokai, monokaiExports));

  var oceanExports = {};
  var ocean = {
    get exports(){ return oceanExports; },
    set exports(v){ oceanExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'ocean',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#2b303b',
  	  base01: '#343d46',
  	  base02: '#4f5b66',
  	  base03: '#65737e',
  	  base04: '#a7adba',
  	  base05: '#c0c5ce',
  	  base06: '#dfe1e8',
  	  base07: '#eff1f5',
  	  base08: '#bf616a',
  	  base09: '#d08770',
  	  base0A: '#ebcb8b',
  	  base0B: '#a3be8c',
  	  base0C: '#96b5b4',
  	  base0D: '#8fa1b3',
  	  base0E: '#b48ead',
  	  base0F: '#ab7967'
  	};
  	module.exports = exports['default'];
  } (ocean, oceanExports));

  var paraisoExports = {};
  var paraiso = {
    get exports(){ return paraisoExports; },
    set exports(v){ paraisoExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'paraiso',
  	  author: 'jan t. sott',
  	  base00: '#2f1e2e',
  	  base01: '#41323f',
  	  base02: '#4f424c',
  	  base03: '#776e71',
  	  base04: '#8d8687',
  	  base05: '#a39e9b',
  	  base06: '#b9b6b0',
  	  base07: '#e7e9db',
  	  base08: '#ef6155',
  	  base09: '#f99b15',
  	  base0A: '#fec418',
  	  base0B: '#48b685',
  	  base0C: '#5bc4bf',
  	  base0D: '#06b6ef',
  	  base0E: '#815ba4',
  	  base0F: '#e96ba8'
  	};
  	module.exports = exports['default'];
  } (paraiso, paraisoExports));

  var popExports = {};
  var pop = {
    get exports(){ return popExports; },
    set exports(v){ popExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'pop',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#000000',
  	  base01: '#202020',
  	  base02: '#303030',
  	  base03: '#505050',
  	  base04: '#b0b0b0',
  	  base05: '#d0d0d0',
  	  base06: '#e0e0e0',
  	  base07: '#ffffff',
  	  base08: '#eb008a',
  	  base09: '#f29333',
  	  base0A: '#f8ca12',
  	  base0B: '#37b349',
  	  base0C: '#00aabb',
  	  base0D: '#0e5a94',
  	  base0E: '#b31e8d',
  	  base0F: '#7a2d00'
  	};
  	module.exports = exports['default'];
  } (pop, popExports));

  var railscastsExports = {};
  var railscasts = {
    get exports(){ return railscastsExports; },
    set exports(v){ railscastsExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'railscasts',
  	  author: 'ryan bates (http://railscasts.com)',
  	  base00: '#2b2b2b',
  	  base01: '#272935',
  	  base02: '#3a4055',
  	  base03: '#5a647e',
  	  base04: '#d4cfc9',
  	  base05: '#e6e1dc',
  	  base06: '#f4f1ed',
  	  base07: '#f9f7f3',
  	  base08: '#da4939',
  	  base09: '#cc7833',
  	  base0A: '#ffc66d',
  	  base0B: '#a5c261',
  	  base0C: '#519f50',
  	  base0D: '#6d9cbe',
  	  base0E: '#b6b3eb',
  	  base0F: '#bc9458'
  	};
  	module.exports = exports['default'];
  } (railscasts, railscastsExports));

  var shapeshifterExports = {};
  var shapeshifter = {
    get exports(){ return shapeshifterExports; },
    set exports(v){ shapeshifterExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'shapeshifter',
  	  author: 'tyler benziger (http://tybenz.com)',
  	  base00: '#000000',
  	  base01: '#040404',
  	  base02: '#102015',
  	  base03: '#343434',
  	  base04: '#555555',
  	  base05: '#ababab',
  	  base06: '#e0e0e0',
  	  base07: '#f9f9f9',
  	  base08: '#e92f2f',
  	  base09: '#e09448',
  	  base0A: '#dddd13',
  	  base0B: '#0ed839',
  	  base0C: '#23edda',
  	  base0D: '#3b48e3',
  	  base0E: '#f996e2',
  	  base0F: '#69542d'
  	};
  	module.exports = exports['default'];
  } (shapeshifter, shapeshifterExports));

  var solarizedExports = {};
  var solarized$1 = {
    get exports(){ return solarizedExports; },
    set exports(v){ solarizedExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'solarized',
  	  author: 'ethan schoonover (http://ethanschoonover.com/solarized)',
  	  base00: '#002b36',
  	  base01: '#073642',
  	  base02: '#586e75',
  	  base03: '#657b83',
  	  base04: '#839496',
  	  base05: '#93a1a1',
  	  base06: '#eee8d5',
  	  base07: '#fdf6e3',
  	  base08: '#dc322f',
  	  base09: '#cb4b16',
  	  base0A: '#b58900',
  	  base0B: '#859900',
  	  base0C: '#2aa198',
  	  base0D: '#268bd2',
  	  base0E: '#6c71c4',
  	  base0F: '#d33682'
  	};
  	module.exports = exports['default'];
  } (solarized$1, solarizedExports));

  var summerfruitExports = {};
  var summerfruit = {
    get exports(){ return summerfruitExports; },
    set exports(v){ summerfruitExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'summerfruit',
  	  author: 'christopher corley (http://cscorley.github.io/)',
  	  base00: '#151515',
  	  base01: '#202020',
  	  base02: '#303030',
  	  base03: '#505050',
  	  base04: '#B0B0B0',
  	  base05: '#D0D0D0',
  	  base06: '#E0E0E0',
  	  base07: '#FFFFFF',
  	  base08: '#FF0086',
  	  base09: '#FD8900',
  	  base0A: '#ABA800',
  	  base0B: '#00C918',
  	  base0C: '#1faaaa',
  	  base0D: '#3777E6',
  	  base0E: '#AD00A1',
  	  base0F: '#cc6633'
  	};
  	module.exports = exports['default'];
  } (summerfruit, summerfruitExports));

  var tomorrowExports = {};
  var tomorrow = {
    get exports(){ return tomorrowExports; },
    set exports(v){ tomorrowExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'tomorrow',
  	  author: 'chris kempson (http://chriskempson.com)',
  	  base00: '#1d1f21',
  	  base01: '#282a2e',
  	  base02: '#373b41',
  	  base03: '#969896',
  	  base04: '#b4b7b4',
  	  base05: '#c5c8c6',
  	  base06: '#e0e0e0',
  	  base07: '#ffffff',
  	  base08: '#cc6666',
  	  base09: '#de935f',
  	  base0A: '#f0c674',
  	  base0B: '#b5bd68',
  	  base0C: '#8abeb7',
  	  base0D: '#81a2be',
  	  base0E: '#b294bb',
  	  base0F: '#a3685a'
  	};
  	module.exports = exports['default'];
  } (tomorrow, tomorrowExports));

  var tubeExports = {};
  var tube = {
    get exports(){ return tubeExports; },
    set exports(v){ tubeExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'london tube',
  	  author: 'jan t. sott',
  	  base00: '#231f20',
  	  base01: '#1c3f95',
  	  base02: '#5a5758',
  	  base03: '#737171',
  	  base04: '#959ca1',
  	  base05: '#d9d8d8',
  	  base06: '#e7e7e8',
  	  base07: '#ffffff',
  	  base08: '#ee2e24',
  	  base09: '#f386a1',
  	  base0A: '#ffd204',
  	  base0B: '#00853e',
  	  base0C: '#85cebc',
  	  base0D: '#009ddc',
  	  base0E: '#98005d',
  	  base0F: '#b06110'
  	};
  	module.exports = exports['default'];
  } (tube, tubeExports));

  var twilightExports = {};
  var twilight = {
    get exports(){ return twilightExports; },
    set exports(v){ twilightExports = v; },
  };

  (function (module, exports) {

  	exports.__esModule = true;
  	exports['default'] = {
  	  scheme: 'twilight',
  	  author: 'david hart (http://hart-dev.com)',
  	  base00: '#1e1e1e',
  	  base01: '#323537',
  	  base02: '#464b50',
  	  base03: '#5f5a60',
  	  base04: '#838184',
  	  base05: '#a7a7a7',
  	  base06: '#c3c3c3',
  	  base07: '#ffffff',
  	  base08: '#cf6a4c',
  	  base09: '#cda869',
  	  base0A: '#f9ee98',
  	  base0B: '#8f9d6a',
  	  base0C: '#afc4db',
  	  base0D: '#7587a6',
  	  base0E: '#9b859d',
  	  base0F: '#9b703f'
  	};
  	module.exports = exports['default'];
  } (twilight, twilightExports));

  (function (exports) {

  	exports.__esModule = true;

  	function _interopRequire(obj) { return obj && obj.__esModule ? obj['default'] : obj; }

  	var _threezerotwofour = threezerotwofourExports;

  	exports.threezerotwofour = _interopRequire(_threezerotwofour);

  	var _apathy = apathyExports;

  	exports.apathy = _interopRequire(_apathy);

  	var _ashes = ashesExports;

  	exports.ashes = _interopRequire(_ashes);

  	var _atelierDune = atelierDuneExports;

  	exports.atelierDune = _interopRequire(_atelierDune);

  	var _atelierForest = atelierForestExports;

  	exports.atelierForest = _interopRequire(_atelierForest);

  	var _atelierHeath = atelierHeathExports;

  	exports.atelierHeath = _interopRequire(_atelierHeath);

  	var _atelierLakeside = atelierLakesideExports;

  	exports.atelierLakeside = _interopRequire(_atelierLakeside);

  	var _atelierSeaside = atelierSeasideExports;

  	exports.atelierSeaside = _interopRequire(_atelierSeaside);

  	var _bespin = bespinExports;

  	exports.bespin = _interopRequire(_bespin);

  	var _brewer = brewerExports;

  	exports.brewer = _interopRequire(_brewer);

  	var _bright = brightExports;

  	exports.bright = _interopRequire(_bright);

  	var _chalk = chalkExports;

  	exports.chalk = _interopRequire(_chalk);

  	var _codeschool = codeschoolExports;

  	exports.codeschool = _interopRequire(_codeschool);

  	var _colors = colorsExports;

  	exports.colors = _interopRequire(_colors);

  	var _default = _defaultExports;

  	exports['default'] = _interopRequire(_default);

  	var _eighties = eightiesExports;

  	exports.eighties = _interopRequire(_eighties);

  	var _embers = embersExports;

  	exports.embers = _interopRequire(_embers);

  	var _flat = flatExports;

  	exports.flat = _interopRequire(_flat);

  	var _google = googleExports;

  	exports.google = _interopRequire(_google);

  	var _grayscale = grayscaleExports;

  	exports.grayscale = _interopRequire(_grayscale);

  	var _greenscreen = greenscreenExports;

  	exports.greenscreen = _interopRequire(_greenscreen);

  	var _harmonic = harmonicExports;

  	exports.harmonic = _interopRequire(_harmonic);

  	var _hopscotch = hopscotchExports;

  	exports.hopscotch = _interopRequire(_hopscotch);

  	var _isotope = isotopeExports;

  	exports.isotope = _interopRequire(_isotope);

  	var _marrakesh = marrakeshExports;

  	exports.marrakesh = _interopRequire(_marrakesh);

  	var _mocha = mochaExports;

  	exports.mocha = _interopRequire(_mocha);

  	var _monokai = monokaiExports;

  	exports.monokai = _interopRequire(_monokai);

  	var _ocean = oceanExports;

  	exports.ocean = _interopRequire(_ocean);

  	var _paraiso = paraisoExports;

  	exports.paraiso = _interopRequire(_paraiso);

  	var _pop = popExports;

  	exports.pop = _interopRequire(_pop);

  	var _railscasts = railscastsExports;

  	exports.railscasts = _interopRequire(_railscasts);

  	var _shapeshifter = shapeshifterExports;

  	exports.shapeshifter = _interopRequire(_shapeshifter);

  	var _solarized = solarizedExports;

  	exports.solarized = _interopRequire(_solarized);

  	var _summerfruit = summerfruitExports;

  	exports.summerfruit = _interopRequire(_summerfruit);

  	var _tomorrow = tomorrowExports;

  	exports.tomorrow = _interopRequire(_tomorrow);

  	var _tube = tubeExports;

  	exports.tube = _interopRequire(_tube);

  	var _twilight = twilightExports;

  	exports.twilight = _interopRequire(_twilight);
  } (lib));

  var index = /*@__PURE__*/getDefaultExportFromCjs(lib);

  var base16 = /*#__PURE__*/_mergeNamespaces({
    __proto__: null,
    default: index
  }, [lib]);

  var colorStringExports = {};
  var colorString$1 = {
    get exports(){ return colorStringExports; },
    set exports(v){ colorStringExports = v; },
  };

  var colorName = {
  	"aliceblue": [240, 248, 255],
  	"antiquewhite": [250, 235, 215],
  	"aqua": [0, 255, 255],
  	"aquamarine": [127, 255, 212],
  	"azure": [240, 255, 255],
  	"beige": [245, 245, 220],
  	"bisque": [255, 228, 196],
  	"black": [0, 0, 0],
  	"blanchedalmond": [255, 235, 205],
  	"blue": [0, 0, 255],
  	"blueviolet": [138, 43, 226],
  	"brown": [165, 42, 42],
  	"burlywood": [222, 184, 135],
  	"cadetblue": [95, 158, 160],
  	"chartreuse": [127, 255, 0],
  	"chocolate": [210, 105, 30],
  	"coral": [255, 127, 80],
  	"cornflowerblue": [100, 149, 237],
  	"cornsilk": [255, 248, 220],
  	"crimson": [220, 20, 60],
  	"cyan": [0, 255, 255],
  	"darkblue": [0, 0, 139],
  	"darkcyan": [0, 139, 139],
  	"darkgoldenrod": [184, 134, 11],
  	"darkgray": [169, 169, 169],
  	"darkgreen": [0, 100, 0],
  	"darkgrey": [169, 169, 169],
  	"darkkhaki": [189, 183, 107],
  	"darkmagenta": [139, 0, 139],
  	"darkolivegreen": [85, 107, 47],
  	"darkorange": [255, 140, 0],
  	"darkorchid": [153, 50, 204],
  	"darkred": [139, 0, 0],
  	"darksalmon": [233, 150, 122],
  	"darkseagreen": [143, 188, 143],
  	"darkslateblue": [72, 61, 139],
  	"darkslategray": [47, 79, 79],
  	"darkslategrey": [47, 79, 79],
  	"darkturquoise": [0, 206, 209],
  	"darkviolet": [148, 0, 211],
  	"deeppink": [255, 20, 147],
  	"deepskyblue": [0, 191, 255],
  	"dimgray": [105, 105, 105],
  	"dimgrey": [105, 105, 105],
  	"dodgerblue": [30, 144, 255],
  	"firebrick": [178, 34, 34],
  	"floralwhite": [255, 250, 240],
  	"forestgreen": [34, 139, 34],
  	"fuchsia": [255, 0, 255],
  	"gainsboro": [220, 220, 220],
  	"ghostwhite": [248, 248, 255],
  	"gold": [255, 215, 0],
  	"goldenrod": [218, 165, 32],
  	"gray": [128, 128, 128],
  	"green": [0, 128, 0],
  	"greenyellow": [173, 255, 47],
  	"grey": [128, 128, 128],
  	"honeydew": [240, 255, 240],
  	"hotpink": [255, 105, 180],
  	"indianred": [205, 92, 92],
  	"indigo": [75, 0, 130],
  	"ivory": [255, 255, 240],
  	"khaki": [240, 230, 140],
  	"lavender": [230, 230, 250],
  	"lavenderblush": [255, 240, 245],
  	"lawngreen": [124, 252, 0],
  	"lemonchiffon": [255, 250, 205],
  	"lightblue": [173, 216, 230],
  	"lightcoral": [240, 128, 128],
  	"lightcyan": [224, 255, 255],
  	"lightgoldenrodyellow": [250, 250, 210],
  	"lightgray": [211, 211, 211],
  	"lightgreen": [144, 238, 144],
  	"lightgrey": [211, 211, 211],
  	"lightpink": [255, 182, 193],
  	"lightsalmon": [255, 160, 122],
  	"lightseagreen": [32, 178, 170],
  	"lightskyblue": [135, 206, 250],
  	"lightslategray": [119, 136, 153],
  	"lightslategrey": [119, 136, 153],
  	"lightsteelblue": [176, 196, 222],
  	"lightyellow": [255, 255, 224],
  	"lime": [0, 255, 0],
  	"limegreen": [50, 205, 50],
  	"linen": [250, 240, 230],
  	"magenta": [255, 0, 255],
  	"maroon": [128, 0, 0],
  	"mediumaquamarine": [102, 205, 170],
  	"mediumblue": [0, 0, 205],
  	"mediumorchid": [186, 85, 211],
  	"mediumpurple": [147, 112, 219],
  	"mediumseagreen": [60, 179, 113],
  	"mediumslateblue": [123, 104, 238],
  	"mediumspringgreen": [0, 250, 154],
  	"mediumturquoise": [72, 209, 204],
  	"mediumvioletred": [199, 21, 133],
  	"midnightblue": [25, 25, 112],
  	"mintcream": [245, 255, 250],
  	"mistyrose": [255, 228, 225],
  	"moccasin": [255, 228, 181],
  	"navajowhite": [255, 222, 173],
  	"navy": [0, 0, 128],
  	"oldlace": [253, 245, 230],
  	"olive": [128, 128, 0],
  	"olivedrab": [107, 142, 35],
  	"orange": [255, 165, 0],
  	"orangered": [255, 69, 0],
  	"orchid": [218, 112, 214],
  	"palegoldenrod": [238, 232, 170],
  	"palegreen": [152, 251, 152],
  	"paleturquoise": [175, 238, 238],
  	"palevioletred": [219, 112, 147],
  	"papayawhip": [255, 239, 213],
  	"peachpuff": [255, 218, 185],
  	"peru": [205, 133, 63],
  	"pink": [255, 192, 203],
  	"plum": [221, 160, 221],
  	"powderblue": [176, 224, 230],
  	"purple": [128, 0, 128],
  	"rebeccapurple": [102, 51, 153],
  	"red": [255, 0, 0],
  	"rosybrown": [188, 143, 143],
  	"royalblue": [65, 105, 225],
  	"saddlebrown": [139, 69, 19],
  	"salmon": [250, 128, 114],
  	"sandybrown": [244, 164, 96],
  	"seagreen": [46, 139, 87],
  	"seashell": [255, 245, 238],
  	"sienna": [160, 82, 45],
  	"silver": [192, 192, 192],
  	"skyblue": [135, 206, 235],
  	"slateblue": [106, 90, 205],
  	"slategray": [112, 128, 144],
  	"slategrey": [112, 128, 144],
  	"snow": [255, 250, 250],
  	"springgreen": [0, 255, 127],
  	"steelblue": [70, 130, 180],
  	"tan": [210, 180, 140],
  	"teal": [0, 128, 128],
  	"thistle": [216, 191, 216],
  	"tomato": [255, 99, 71],
  	"turquoise": [64, 224, 208],
  	"violet": [238, 130, 238],
  	"wheat": [245, 222, 179],
  	"white": [255, 255, 255],
  	"whitesmoke": [245, 245, 245],
  	"yellow": [255, 255, 0],
  	"yellowgreen": [154, 205, 50]
  };

  var simpleSwizzleExports = {};
  var simpleSwizzle = {
    get exports(){ return simpleSwizzleExports; },
    set exports(v){ simpleSwizzleExports = v; },
  };

  var isArrayish$1 = function isArrayish(obj) {
  	if (!obj || typeof obj === 'string') {
  		return false;
  	}

  	return obj instanceof Array || Array.isArray(obj) ||
  		(obj.length >= 0 && (obj.splice instanceof Function ||
  			(Object.getOwnPropertyDescriptor(obj, (obj.length - 1)) && obj.constructor.name !== 'String')));
  };

  var isArrayish = isArrayish$1;

  var concat = Array.prototype.concat;
  var slice = Array.prototype.slice;

  var swizzle$1 = simpleSwizzle.exports = function swizzle(args) {
  	var results = [];

  	for (var i = 0, len = args.length; i < len; i++) {
  		var arg = args[i];

  		if (isArrayish(arg)) {
  			// http://jsperf.com/javascript-array-concat-vs-push/98
  			results = concat.call(results, slice.call(arg));
  		} else {
  			results.push(arg);
  		}
  	}

  	return results;
  };

  swizzle$1.wrap = function (fn) {
  	return function () {
  		return fn(swizzle$1(arguments));
  	};
  };

  /* MIT license */

  var colorNames = colorName;
  var swizzle = simpleSwizzleExports;
  var hasOwnProperty$1 = Object.hasOwnProperty;

  var reverseNames = Object.create(null);

  // create a list of reverse color names
  for (var name in colorNames) {
  	if (hasOwnProperty$1.call(colorNames, name)) {
  		reverseNames[colorNames[name]] = name;
  	}
  }

  var cs = colorString$1.exports = {
  	to: {},
  	get: {}
  };

  cs.get = function (string) {
  	var prefix = string.substring(0, 3).toLowerCase();
  	var val;
  	var model;
  	switch (prefix) {
  		case 'hsl':
  			val = cs.get.hsl(string);
  			model = 'hsl';
  			break;
  		case 'hwb':
  			val = cs.get.hwb(string);
  			model = 'hwb';
  			break;
  		default:
  			val = cs.get.rgb(string);
  			model = 'rgb';
  			break;
  	}

  	if (!val) {
  		return null;
  	}

  	return {model: model, value: val};
  };

  cs.get.rgb = function (string) {
  	if (!string) {
  		return null;
  	}

  	var abbr = /^#([a-f0-9]{3,4})$/i;
  	var hex = /^#([a-f0-9]{6})([a-f0-9]{2})?$/i;
  	var rgba = /^rgba?\(\s*([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/;
  	var per = /^rgba?\(\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/;
  	var keyword = /^(\w+)$/;

  	var rgb = [0, 0, 0, 1];
  	var match;
  	var i;
  	var hexAlpha;

  	if (match = string.match(hex)) {
  		hexAlpha = match[2];
  		match = match[1];

  		for (i = 0; i < 3; i++) {
  			// https://jsperf.com/slice-vs-substr-vs-substring-methods-long-string/19
  			var i2 = i * 2;
  			rgb[i] = parseInt(match.slice(i2, i2 + 2), 16);
  		}

  		if (hexAlpha) {
  			rgb[3] = parseInt(hexAlpha, 16) / 255;
  		}
  	} else if (match = string.match(abbr)) {
  		match = match[1];
  		hexAlpha = match[3];

  		for (i = 0; i < 3; i++) {
  			rgb[i] = parseInt(match[i] + match[i], 16);
  		}

  		if (hexAlpha) {
  			rgb[3] = parseInt(hexAlpha + hexAlpha, 16) / 255;
  		}
  	} else if (match = string.match(rgba)) {
  		for (i = 0; i < 3; i++) {
  			rgb[i] = parseInt(match[i + 1], 0);
  		}

  		if (match[4]) {
  			if (match[5]) {
  				rgb[3] = parseFloat(match[4]) * 0.01;
  			} else {
  				rgb[3] = parseFloat(match[4]);
  			}
  		}
  	} else if (match = string.match(per)) {
  		for (i = 0; i < 3; i++) {
  			rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);
  		}

  		if (match[4]) {
  			if (match[5]) {
  				rgb[3] = parseFloat(match[4]) * 0.01;
  			} else {
  				rgb[3] = parseFloat(match[4]);
  			}
  		}
  	} else if (match = string.match(keyword)) {
  		if (match[1] === 'transparent') {
  			return [0, 0, 0, 0];
  		}

  		if (!hasOwnProperty$1.call(colorNames, match[1])) {
  			return null;
  		}

  		rgb = colorNames[match[1]];
  		rgb[3] = 1;

  		return rgb;
  	} else {
  		return null;
  	}

  	for (i = 0; i < 3; i++) {
  		rgb[i] = clamp(rgb[i], 0, 255);
  	}
  	rgb[3] = clamp(rgb[3], 0, 1);

  	return rgb;
  };

  cs.get.hsl = function (string) {
  	if (!string) {
  		return null;
  	}

  	var hsl = /^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,?\s*([+-]?[\d\.]+)%\s*,?\s*([+-]?[\d\.]+)%\s*(?:[,|\/]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;
  	var match = string.match(hsl);

  	if (match) {
  		var alpha = parseFloat(match[4]);
  		var h = ((parseFloat(match[1]) % 360) + 360) % 360;
  		var s = clamp(parseFloat(match[2]), 0, 100);
  		var l = clamp(parseFloat(match[3]), 0, 100);
  		var a = clamp(isNaN(alpha) ? 1 : alpha, 0, 1);

  		return [h, s, l, a];
  	}

  	return null;
  };

  cs.get.hwb = function (string) {
  	if (!string) {
  		return null;
  	}

  	var hwb = /^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;
  	var match = string.match(hwb);

  	if (match) {
  		var alpha = parseFloat(match[4]);
  		var h = ((parseFloat(match[1]) % 360) + 360) % 360;
  		var w = clamp(parseFloat(match[2]), 0, 100);
  		var b = clamp(parseFloat(match[3]), 0, 100);
  		var a = clamp(isNaN(alpha) ? 1 : alpha, 0, 1);
  		return [h, w, b, a];
  	}

  	return null;
  };

  cs.to.hex = function () {
  	var rgba = swizzle(arguments);

  	return (
  		'#' +
  		hexDouble(rgba[0]) +
  		hexDouble(rgba[1]) +
  		hexDouble(rgba[2]) +
  		(rgba[3] < 1
  			? (hexDouble(Math.round(rgba[3] * 255)))
  			: '')
  	);
  };

  cs.to.rgb = function () {
  	var rgba = swizzle(arguments);

  	return rgba.length < 4 || rgba[3] === 1
  		? 'rgb(' + Math.round(rgba[0]) + ', ' + Math.round(rgba[1]) + ', ' + Math.round(rgba[2]) + ')'
  		: 'rgba(' + Math.round(rgba[0]) + ', ' + Math.round(rgba[1]) + ', ' + Math.round(rgba[2]) + ', ' + rgba[3] + ')';
  };

  cs.to.rgb.percent = function () {
  	var rgba = swizzle(arguments);

  	var r = Math.round(rgba[0] / 255 * 100);
  	var g = Math.round(rgba[1] / 255 * 100);
  	var b = Math.round(rgba[2] / 255 * 100);

  	return rgba.length < 4 || rgba[3] === 1
  		? 'rgb(' + r + '%, ' + g + '%, ' + b + '%)'
  		: 'rgba(' + r + '%, ' + g + '%, ' + b + '%, ' + rgba[3] + ')';
  };

  cs.to.hsl = function () {
  	var hsla = swizzle(arguments);
  	return hsla.length < 4 || hsla[3] === 1
  		? 'hsl(' + hsla[0] + ', ' + hsla[1] + '%, ' + hsla[2] + '%)'
  		: 'hsla(' + hsla[0] + ', ' + hsla[1] + '%, ' + hsla[2] + '%, ' + hsla[3] + ')';
  };

  // hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax
  // (hwb have alpha optional & 1 is default value)
  cs.to.hwb = function () {
  	var hwba = swizzle(arguments);

  	var a = '';
  	if (hwba.length >= 4 && hwba[3] !== 1) {
  		a = ', ' + hwba[3];
  	}

  	return 'hwb(' + hwba[0] + ', ' + hwba[1] + '%, ' + hwba[2] + '%' + a + ')';
  };

  cs.to.keyword = function (rgb) {
  	return reverseNames[rgb.slice(0, 3)];
  };

  // helpers
  function clamp(num, min, max) {
  	return Math.min(Math.max(min, num), max);
  }

  function hexDouble(num) {
  	var str = Math.round(num).toString(16).toUpperCase();
  	return (str.length < 2) ? '0' + str : str;
  }

  /* MIT license */

  /* eslint-disable no-mixed-operators */
  const cssKeywords = colorName;

  // NOTE: conversions should only return primitive values (i.e. arrays, or
  //       values that give correct `typeof` results).
  //       do not use box values types (i.e. Number(), String(), etc.)

  const reverseKeywords = {};
  for (const key of Object.keys(cssKeywords)) {
  	reverseKeywords[cssKeywords[key]] = key;
  }

  const convert$2 = {
  	rgb: {channels: 3, labels: 'rgb'},
  	hsl: {channels: 3, labels: 'hsl'},
  	hsv: {channels: 3, labels: 'hsv'},
  	hwb: {channels: 3, labels: 'hwb'},
  	cmyk: {channels: 4, labels: 'cmyk'},
  	xyz: {channels: 3, labels: 'xyz'},
  	lab: {channels: 3, labels: 'lab'},
  	lch: {channels: 3, labels: 'lch'},
  	hex: {channels: 1, labels: ['hex']},
  	keyword: {channels: 1, labels: ['keyword']},
  	ansi16: {channels: 1, labels: ['ansi16']},
  	ansi256: {channels: 1, labels: ['ansi256']},
  	hcg: {channels: 3, labels: ['h', 'c', 'g']},
  	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
  	gray: {channels: 1, labels: ['gray']}
  };

  var conversions$2 = convert$2;

  // Hide .channels and .labels properties
  for (const model of Object.keys(convert$2)) {
  	if (!('channels' in convert$2[model])) {
  		throw new Error('missing channels property: ' + model);
  	}

  	if (!('labels' in convert$2[model])) {
  		throw new Error('missing channel labels property: ' + model);
  	}

  	if (convert$2[model].labels.length !== convert$2[model].channels) {
  		throw new Error('channel and label counts mismatch: ' + model);
  	}

  	const {channels, labels} = convert$2[model];
  	delete convert$2[model].channels;
  	delete convert$2[model].labels;
  	Object.defineProperty(convert$2[model], 'channels', {value: channels});
  	Object.defineProperty(convert$2[model], 'labels', {value: labels});
  }

  convert$2.rgb.hsl = function (rgb) {
  	const r = rgb[0] / 255;
  	const g = rgb[1] / 255;
  	const b = rgb[2] / 255;
  	const min = Math.min(r, g, b);
  	const max = Math.max(r, g, b);
  	const delta = max - min;
  	let h;
  	let s;

  	if (max === min) {
  		h = 0;
  	} else if (r === max) {
  		h = (g - b) / delta;
  	} else if (g === max) {
  		h = 2 + (b - r) / delta;
  	} else if (b === max) {
  		h = 4 + (r - g) / delta;
  	}

  	h = Math.min(h * 60, 360);

  	if (h < 0) {
  		h += 360;
  	}

  	const l = (min + max) / 2;

  	if (max === min) {
  		s = 0;
  	} else if (l <= 0.5) {
  		s = delta / (max + min);
  	} else {
  		s = delta / (2 - max - min);
  	}

  	return [h, s * 100, l * 100];
  };

  convert$2.rgb.hsv = function (rgb) {
  	let rdif;
  	let gdif;
  	let bdif;
  	let h;
  	let s;

  	const r = rgb[0] / 255;
  	const g = rgb[1] / 255;
  	const b = rgb[2] / 255;
  	const v = Math.max(r, g, b);
  	const diff = v - Math.min(r, g, b);
  	const diffc = function (c) {
  		return (v - c) / 6 / diff + 1 / 2;
  	};

  	if (diff === 0) {
  		h = 0;
  		s = 0;
  	} else {
  		s = diff / v;
  		rdif = diffc(r);
  		gdif = diffc(g);
  		bdif = diffc(b);

  		if (r === v) {
  			h = bdif - gdif;
  		} else if (g === v) {
  			h = (1 / 3) + rdif - bdif;
  		} else if (b === v) {
  			h = (2 / 3) + gdif - rdif;
  		}

  		if (h < 0) {
  			h += 1;
  		} else if (h > 1) {
  			h -= 1;
  		}
  	}

  	return [
  		h * 360,
  		s * 100,
  		v * 100
  	];
  };

  convert$2.rgb.hwb = function (rgb) {
  	const r = rgb[0];
  	const g = rgb[1];
  	let b = rgb[2];
  	const h = convert$2.rgb.hsl(rgb)[0];
  	const w = 1 / 255 * Math.min(r, Math.min(g, b));

  	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

  	return [h, w * 100, b * 100];
  };

  convert$2.rgb.cmyk = function (rgb) {
  	const r = rgb[0] / 255;
  	const g = rgb[1] / 255;
  	const b = rgb[2] / 255;

  	const k = Math.min(1 - r, 1 - g, 1 - b);
  	const c = (1 - r - k) / (1 - k) || 0;
  	const m = (1 - g - k) / (1 - k) || 0;
  	const y = (1 - b - k) / (1 - k) || 0;

  	return [c * 100, m * 100, y * 100, k * 100];
  };

  function comparativeDistance(x, y) {
  	/*
  		See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
  	*/
  	return (
  		((x[0] - y[0]) ** 2) +
  		((x[1] - y[1]) ** 2) +
  		((x[2] - y[2]) ** 2)
  	);
  }

  convert$2.rgb.keyword = function (rgb) {
  	const reversed = reverseKeywords[rgb];
  	if (reversed) {
  		return reversed;
  	}

  	let currentClosestDistance = Infinity;
  	let currentClosestKeyword;

  	for (const keyword of Object.keys(cssKeywords)) {
  		const value = cssKeywords[keyword];

  		// Compute comparative distance
  		const distance = comparativeDistance(rgb, value);

  		// Check if its less, if so set as closest
  		if (distance < currentClosestDistance) {
  			currentClosestDistance = distance;
  			currentClosestKeyword = keyword;
  		}
  	}

  	return currentClosestKeyword;
  };

  convert$2.keyword.rgb = function (keyword) {
  	return cssKeywords[keyword];
  };

  convert$2.rgb.xyz = function (rgb) {
  	let r = rgb[0] / 255;
  	let g = rgb[1] / 255;
  	let b = rgb[2] / 255;

  	// Assume sRGB
  	r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
  	g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
  	b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

  	const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
  	const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
  	const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

  	return [x * 100, y * 100, z * 100];
  };

  convert$2.rgb.lab = function (rgb) {
  	const xyz = convert$2.rgb.xyz(rgb);
  	let x = xyz[0];
  	let y = xyz[1];
  	let z = xyz[2];

  	x /= 95.047;
  	y /= 100;
  	z /= 108.883;

  	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
  	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
  	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

  	const l = (116 * y) - 16;
  	const a = 500 * (x - y);
  	const b = 200 * (y - z);

  	return [l, a, b];
  };

  convert$2.hsl.rgb = function (hsl) {
  	const h = hsl[0] / 360;
  	const s = hsl[1] / 100;
  	const l = hsl[2] / 100;
  	let t2;
  	let t3;
  	let val;

  	if (s === 0) {
  		val = l * 255;
  		return [val, val, val];
  	}

  	if (l < 0.5) {
  		t2 = l * (1 + s);
  	} else {
  		t2 = l + s - l * s;
  	}

  	const t1 = 2 * l - t2;

  	const rgb = [0, 0, 0];
  	for (let i = 0; i < 3; i++) {
  		t3 = h + 1 / 3 * -(i - 1);
  		if (t3 < 0) {
  			t3++;
  		}

  		if (t3 > 1) {
  			t3--;
  		}

  		if (6 * t3 < 1) {
  			val = t1 + (t2 - t1) * 6 * t3;
  		} else if (2 * t3 < 1) {
  			val = t2;
  		} else if (3 * t3 < 2) {
  			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
  		} else {
  			val = t1;
  		}

  		rgb[i] = val * 255;
  	}

  	return rgb;
  };

  convert$2.hsl.hsv = function (hsl) {
  	const h = hsl[0];
  	let s = hsl[1] / 100;
  	let l = hsl[2] / 100;
  	let smin = s;
  	const lmin = Math.max(l, 0.01);

  	l *= 2;
  	s *= (l <= 1) ? l : 2 - l;
  	smin *= lmin <= 1 ? lmin : 2 - lmin;
  	const v = (l + s) / 2;
  	const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

  	return [h, sv * 100, v * 100];
  };

  convert$2.hsv.rgb = function (hsv) {
  	const h = hsv[0] / 60;
  	const s = hsv[1] / 100;
  	let v = hsv[2] / 100;
  	const hi = Math.floor(h) % 6;

  	const f = h - Math.floor(h);
  	const p = 255 * v * (1 - s);
  	const q = 255 * v * (1 - (s * f));
  	const t = 255 * v * (1 - (s * (1 - f)));
  	v *= 255;

  	switch (hi) {
  		case 0:
  			return [v, t, p];
  		case 1:
  			return [q, v, p];
  		case 2:
  			return [p, v, t];
  		case 3:
  			return [p, q, v];
  		case 4:
  			return [t, p, v];
  		case 5:
  			return [v, p, q];
  	}
  };

  convert$2.hsv.hsl = function (hsv) {
  	const h = hsv[0];
  	const s = hsv[1] / 100;
  	const v = hsv[2] / 100;
  	const vmin = Math.max(v, 0.01);
  	let sl;
  	let l;

  	l = (2 - s) * v;
  	const lmin = (2 - s) * vmin;
  	sl = s * vmin;
  	sl /= (lmin <= 1) ? lmin : 2 - lmin;
  	sl = sl || 0;
  	l /= 2;

  	return [h, sl * 100, l * 100];
  };

  // http://dev.w3.org/csswg/css-color/#hwb-to-rgb
  convert$2.hwb.rgb = function (hwb) {
  	const h = hwb[0] / 360;
  	let wh = hwb[1] / 100;
  	let bl = hwb[2] / 100;
  	const ratio = wh + bl;
  	let f;

  	// Wh + bl cant be > 1
  	if (ratio > 1) {
  		wh /= ratio;
  		bl /= ratio;
  	}

  	const i = Math.floor(6 * h);
  	const v = 1 - bl;
  	f = 6 * h - i;

  	if ((i & 0x01) !== 0) {
  		f = 1 - f;
  	}

  	const n = wh + f * (v - wh); // Linear interpolation

  	let r;
  	let g;
  	let b;
  	/* eslint-disable max-statements-per-line,no-multi-spaces */
  	switch (i) {
  		default:
  		case 6:
  		case 0: r = v;  g = n;  b = wh; break;
  		case 1: r = n;  g = v;  b = wh; break;
  		case 2: r = wh; g = v;  b = n; break;
  		case 3: r = wh; g = n;  b = v; break;
  		case 4: r = n;  g = wh; b = v; break;
  		case 5: r = v;  g = wh; b = n; break;
  	}
  	/* eslint-enable max-statements-per-line,no-multi-spaces */

  	return [r * 255, g * 255, b * 255];
  };

  convert$2.cmyk.rgb = function (cmyk) {
  	const c = cmyk[0] / 100;
  	const m = cmyk[1] / 100;
  	const y = cmyk[2] / 100;
  	const k = cmyk[3] / 100;

  	const r = 1 - Math.min(1, c * (1 - k) + k);
  	const g = 1 - Math.min(1, m * (1 - k) + k);
  	const b = 1 - Math.min(1, y * (1 - k) + k);

  	return [r * 255, g * 255, b * 255];
  };

  convert$2.xyz.rgb = function (xyz) {
  	const x = xyz[0] / 100;
  	const y = xyz[1] / 100;
  	const z = xyz[2] / 100;
  	let r;
  	let g;
  	let b;

  	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
  	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
  	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

  	// Assume sRGB
  	r = r > 0.0031308
  		? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
  		: r * 12.92;

  	g = g > 0.0031308
  		? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
  		: g * 12.92;

  	b = b > 0.0031308
  		? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
  		: b * 12.92;

  	r = Math.min(Math.max(0, r), 1);
  	g = Math.min(Math.max(0, g), 1);
  	b = Math.min(Math.max(0, b), 1);

  	return [r * 255, g * 255, b * 255];
  };

  convert$2.xyz.lab = function (xyz) {
  	let x = xyz[0];
  	let y = xyz[1];
  	let z = xyz[2];

  	x /= 95.047;
  	y /= 100;
  	z /= 108.883;

  	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
  	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
  	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

  	const l = (116 * y) - 16;
  	const a = 500 * (x - y);
  	const b = 200 * (y - z);

  	return [l, a, b];
  };

  convert$2.lab.xyz = function (lab) {
  	const l = lab[0];
  	const a = lab[1];
  	const b = lab[2];
  	let x;
  	let y;
  	let z;

  	y = (l + 16) / 116;
  	x = a / 500 + y;
  	z = y - b / 200;

  	const y2 = y ** 3;
  	const x2 = x ** 3;
  	const z2 = z ** 3;
  	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
  	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
  	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

  	x *= 95.047;
  	y *= 100;
  	z *= 108.883;

  	return [x, y, z];
  };

  convert$2.lab.lch = function (lab) {
  	const l = lab[0];
  	const a = lab[1];
  	const b = lab[2];
  	let h;

  	const hr = Math.atan2(b, a);
  	h = hr * 360 / 2 / Math.PI;

  	if (h < 0) {
  		h += 360;
  	}

  	const c = Math.sqrt(a * a + b * b);

  	return [l, c, h];
  };

  convert$2.lch.lab = function (lch) {
  	const l = lch[0];
  	const c = lch[1];
  	const h = lch[2];

  	const hr = h / 360 * 2 * Math.PI;
  	const a = c * Math.cos(hr);
  	const b = c * Math.sin(hr);

  	return [l, a, b];
  };

  convert$2.rgb.ansi16 = function (args, saturation = null) {
  	const [r, g, b] = args;
  	let value = saturation === null ? convert$2.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

  	value = Math.round(value / 50);

  	if (value === 0) {
  		return 30;
  	}

  	let ansi = 30
  		+ ((Math.round(b / 255) << 2)
  		| (Math.round(g / 255) << 1)
  		| Math.round(r / 255));

  	if (value === 2) {
  		ansi += 60;
  	}

  	return ansi;
  };

  convert$2.hsv.ansi16 = function (args) {
  	// Optimization here; we already know the value and don't need to get
  	// it converted for us.
  	return convert$2.rgb.ansi16(convert$2.hsv.rgb(args), args[2]);
  };

  convert$2.rgb.ansi256 = function (args) {
  	const r = args[0];
  	const g = args[1];
  	const b = args[2];

  	// We use the extended greyscale palette here, with the exception of
  	// black and white. normal palette only has 4 greyscale shades.
  	if (r === g && g === b) {
  		if (r < 8) {
  			return 16;
  		}

  		if (r > 248) {
  			return 231;
  		}

  		return Math.round(((r - 8) / 247) * 24) + 232;
  	}

  	const ansi = 16
  		+ (36 * Math.round(r / 255 * 5))
  		+ (6 * Math.round(g / 255 * 5))
  		+ Math.round(b / 255 * 5);

  	return ansi;
  };

  convert$2.ansi16.rgb = function (args) {
  	let color = args % 10;

  	// Handle greyscale
  	if (color === 0 || color === 7) {
  		if (args > 50) {
  			color += 3.5;
  		}

  		color = color / 10.5 * 255;

  		return [color, color, color];
  	}

  	const mult = (~~(args > 50) + 1) * 0.5;
  	const r = ((color & 1) * mult) * 255;
  	const g = (((color >> 1) & 1) * mult) * 255;
  	const b = (((color >> 2) & 1) * mult) * 255;

  	return [r, g, b];
  };

  convert$2.ansi256.rgb = function (args) {
  	// Handle greyscale
  	if (args >= 232) {
  		const c = (args - 232) * 10 + 8;
  		return [c, c, c];
  	}

  	args -= 16;

  	let rem;
  	const r = Math.floor(args / 36) / 5 * 255;
  	const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
  	const b = (rem % 6) / 5 * 255;

  	return [r, g, b];
  };

  convert$2.rgb.hex = function (args) {
  	const integer = ((Math.round(args[0]) & 0xFF) << 16)
  		+ ((Math.round(args[1]) & 0xFF) << 8)
  		+ (Math.round(args[2]) & 0xFF);

  	const string = integer.toString(16).toUpperCase();
  	return '000000'.substring(string.length) + string;
  };

  convert$2.hex.rgb = function (args) {
  	const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
  	if (!match) {
  		return [0, 0, 0];
  	}

  	let colorString = match[0];

  	if (match[0].length === 3) {
  		colorString = colorString.split('').map(char => {
  			return char + char;
  		}).join('');
  	}

  	const integer = parseInt(colorString, 16);
  	const r = (integer >> 16) & 0xFF;
  	const g = (integer >> 8) & 0xFF;
  	const b = integer & 0xFF;

  	return [r, g, b];
  };

  convert$2.rgb.hcg = function (rgb) {
  	const r = rgb[0] / 255;
  	const g = rgb[1] / 255;
  	const b = rgb[2] / 255;
  	const max = Math.max(Math.max(r, g), b);
  	const min = Math.min(Math.min(r, g), b);
  	const chroma = (max - min);
  	let grayscale;
  	let hue;

  	if (chroma < 1) {
  		grayscale = min / (1 - chroma);
  	} else {
  		grayscale = 0;
  	}

  	if (chroma <= 0) {
  		hue = 0;
  	} else
  	if (max === r) {
  		hue = ((g - b) / chroma) % 6;
  	} else
  	if (max === g) {
  		hue = 2 + (b - r) / chroma;
  	} else {
  		hue = 4 + (r - g) / chroma;
  	}

  	hue /= 6;
  	hue %= 1;

  	return [hue * 360, chroma * 100, grayscale * 100];
  };

  convert$2.hsl.hcg = function (hsl) {
  	const s = hsl[1] / 100;
  	const l = hsl[2] / 100;

  	const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

  	let f = 0;
  	if (c < 1.0) {
  		f = (l - 0.5 * c) / (1.0 - c);
  	}

  	return [hsl[0], c * 100, f * 100];
  };

  convert$2.hsv.hcg = function (hsv) {
  	const s = hsv[1] / 100;
  	const v = hsv[2] / 100;

  	const c = s * v;
  	let f = 0;

  	if (c < 1.0) {
  		f = (v - c) / (1 - c);
  	}

  	return [hsv[0], c * 100, f * 100];
  };

  convert$2.hcg.rgb = function (hcg) {
  	const h = hcg[0] / 360;
  	const c = hcg[1] / 100;
  	const g = hcg[2] / 100;

  	if (c === 0.0) {
  		return [g * 255, g * 255, g * 255];
  	}

  	const pure = [0, 0, 0];
  	const hi = (h % 1) * 6;
  	const v = hi % 1;
  	const w = 1 - v;
  	let mg = 0;

  	/* eslint-disable max-statements-per-line */
  	switch (Math.floor(hi)) {
  		case 0:
  			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
  		case 1:
  			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
  		case 2:
  			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
  		case 3:
  			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
  		case 4:
  			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
  		default:
  			pure[0] = 1; pure[1] = 0; pure[2] = w;
  	}
  	/* eslint-enable max-statements-per-line */

  	mg = (1.0 - c) * g;

  	return [
  		(c * pure[0] + mg) * 255,
  		(c * pure[1] + mg) * 255,
  		(c * pure[2] + mg) * 255
  	];
  };

  convert$2.hcg.hsv = function (hcg) {
  	const c = hcg[1] / 100;
  	const g = hcg[2] / 100;

  	const v = c + g * (1.0 - c);
  	let f = 0;

  	if (v > 0.0) {
  		f = c / v;
  	}

  	return [hcg[0], f * 100, v * 100];
  };

  convert$2.hcg.hsl = function (hcg) {
  	const c = hcg[1] / 100;
  	const g = hcg[2] / 100;

  	const l = g * (1.0 - c) + 0.5 * c;
  	let s = 0;

  	if (l > 0.0 && l < 0.5) {
  		s = c / (2 * l);
  	} else
  	if (l >= 0.5 && l < 1.0) {
  		s = c / (2 * (1 - l));
  	}

  	return [hcg[0], s * 100, l * 100];
  };

  convert$2.hcg.hwb = function (hcg) {
  	const c = hcg[1] / 100;
  	const g = hcg[2] / 100;
  	const v = c + g * (1.0 - c);
  	return [hcg[0], (v - c) * 100, (1 - v) * 100];
  };

  convert$2.hwb.hcg = function (hwb) {
  	const w = hwb[1] / 100;
  	const b = hwb[2] / 100;
  	const v = 1 - b;
  	const c = v - w;
  	let g = 0;

  	if (c < 1) {
  		g = (v - c) / (1 - c);
  	}

  	return [hwb[0], c * 100, g * 100];
  };

  convert$2.apple.rgb = function (apple) {
  	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
  };

  convert$2.rgb.apple = function (rgb) {
  	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
  };

  convert$2.gray.rgb = function (args) {
  	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
  };

  convert$2.gray.hsl = function (args) {
  	return [0, 0, args[0]];
  };

  convert$2.gray.hsv = convert$2.gray.hsl;

  convert$2.gray.hwb = function (gray) {
  	return [0, 100, gray[0]];
  };

  convert$2.gray.cmyk = function (gray) {
  	return [0, 0, 0, gray[0]];
  };

  convert$2.gray.lab = function (gray) {
  	return [gray[0], 0, 0];
  };

  convert$2.gray.hex = function (gray) {
  	const val = Math.round(gray[0] / 100 * 255) & 0xFF;
  	const integer = (val << 16) + (val << 8) + val;

  	const string = integer.toString(16).toUpperCase();
  	return '000000'.substring(string.length) + string;
  };

  convert$2.rgb.gray = function (rgb) {
  	const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
  	return [val / 255 * 100];
  };

  const conversions$1 = conversions$2;

  /*
  	This function routes a model to all other models.

  	all functions that are routed have a property `.conversion` attached
  	to the returned synthetic function. This property is an array
  	of strings, each with the steps in between the 'from' and 'to'
  	color models (inclusive).

  	conversions that are not possible simply are not included.
  */

  function buildGraph() {
  	const graph = {};
  	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
  	const models = Object.keys(conversions$1);

  	for (let len = models.length, i = 0; i < len; i++) {
  		graph[models[i]] = {
  			// http://jsperf.com/1-vs-infinity
  			// micro-opt, but this is simple.
  			distance: -1,
  			parent: null
  		};
  	}

  	return graph;
  }

  // https://en.wikipedia.org/wiki/Breadth-first_search
  function deriveBFS(fromModel) {
  	const graph = buildGraph();
  	const queue = [fromModel]; // Unshift -> queue -> pop

  	graph[fromModel].distance = 0;

  	while (queue.length) {
  		const current = queue.pop();
  		const adjacents = Object.keys(conversions$1[current]);

  		for (let len = adjacents.length, i = 0; i < len; i++) {
  			const adjacent = adjacents[i];
  			const node = graph[adjacent];

  			if (node.distance === -1) {
  				node.distance = graph[current].distance + 1;
  				node.parent = current;
  				queue.unshift(adjacent);
  			}
  		}
  	}

  	return graph;
  }

  function link(from, to) {
  	return function (args) {
  		return to(from(args));
  	};
  }

  function wrapConversion(toModel, graph) {
  	const path = [graph[toModel].parent, toModel];
  	let fn = conversions$1[graph[toModel].parent][toModel];

  	let cur = graph[toModel].parent;
  	while (graph[cur].parent) {
  		path.unshift(graph[cur].parent);
  		fn = link(conversions$1[graph[cur].parent][cur], fn);
  		cur = graph[cur].parent;
  	}

  	fn.conversion = path;
  	return fn;
  }

  var route$1 = function (fromModel) {
  	const graph = deriveBFS(fromModel);
  	const conversion = {};

  	const models = Object.keys(graph);
  	for (let len = models.length, i = 0; i < len; i++) {
  		const toModel = models[i];
  		const node = graph[toModel];

  		if (node.parent === null) {
  			// No possible conversion, or this node is the source model.
  			continue;
  		}

  		conversion[toModel] = wrapConversion(toModel, graph);
  	}

  	return conversion;
  };

  const conversions = conversions$2;
  const route = route$1;

  const convert$1 = {};

  const models = Object.keys(conversions);

  function wrapRaw(fn) {
  	const wrappedFn = function (...args) {
  		const arg0 = args[0];
  		if (arg0 === undefined || arg0 === null) {
  			return arg0;
  		}

  		if (arg0.length > 1) {
  			args = arg0;
  		}

  		return fn(args);
  	};

  	// Preserve .conversion property if there is one
  	if ('conversion' in fn) {
  		wrappedFn.conversion = fn.conversion;
  	}

  	return wrappedFn;
  }

  function wrapRounded(fn) {
  	const wrappedFn = function (...args) {
  		const arg0 = args[0];

  		if (arg0 === undefined || arg0 === null) {
  			return arg0;
  		}

  		if (arg0.length > 1) {
  			args = arg0;
  		}

  		const result = fn(args);

  		// We're assuming the result is an array here.
  		// see notice in conversions.js; don't use box types
  		// in conversion functions.
  		if (typeof result === 'object') {
  			for (let len = result.length, i = 0; i < len; i++) {
  				result[i] = Math.round(result[i]);
  			}
  		}

  		return result;
  	};

  	// Preserve .conversion property if there is one
  	if ('conversion' in fn) {
  		wrappedFn.conversion = fn.conversion;
  	}

  	return wrappedFn;
  }

  models.forEach(fromModel => {
  	convert$1[fromModel] = {};

  	Object.defineProperty(convert$1[fromModel], 'channels', {value: conversions[fromModel].channels});
  	Object.defineProperty(convert$1[fromModel], 'labels', {value: conversions[fromModel].labels});

  	const routes = route(fromModel);
  	const routeModels = Object.keys(routes);

  	routeModels.forEach(toModel => {
  		const fn = routes[toModel];

  		convert$1[fromModel][toModel] = wrapRounded(fn);
  		convert$1[fromModel][toModel].raw = wrapRaw(fn);
  	});
  });

  var colorConvert = convert$1;

  const colorString = colorStringExports;
  const convert = colorConvert;

  const skippedModels = [
  	// To be honest, I don't really feel like keyword belongs in color convert, but eh.
  	'keyword',

  	// Gray conflicts with some method names, and has its own method defined.
  	'gray',

  	// Shouldn't really be in color-convert either...
  	'hex',
  ];

  const hashedModelKeys = {};
  for (const model of Object.keys(convert)) {
  	hashedModelKeys[[...convert[model].labels].sort().join('')] = model;
  }

  const limiters = {};

  function Color(object, model) {
  	if (!(this instanceof Color)) {
  		return new Color(object, model);
  	}

  	if (model && model in skippedModels) {
  		model = null;
  	}

  	if (model && !(model in convert)) {
  		throw new Error('Unknown model: ' + model);
  	}

  	let i;
  	let channels;

  	if (object == null) { // eslint-disable-line no-eq-null,eqeqeq
  		this.model = 'rgb';
  		this.color = [0, 0, 0];
  		this.valpha = 1;
  	} else if (object instanceof Color) {
  		this.model = object.model;
  		this.color = [...object.color];
  		this.valpha = object.valpha;
  	} else if (typeof object === 'string') {
  		const result = colorString.get(object);
  		if (result === null) {
  			throw new Error('Unable to parse color from string: ' + object);
  		}

  		this.model = result.model;
  		channels = convert[this.model].channels;
  		this.color = result.value.slice(0, channels);
  		this.valpha = typeof result.value[channels] === 'number' ? result.value[channels] : 1;
  	} else if (object.length > 0) {
  		this.model = model || 'rgb';
  		channels = convert[this.model].channels;
  		const newArray = Array.prototype.slice.call(object, 0, channels);
  		this.color = zeroArray(newArray, channels);
  		this.valpha = typeof object[channels] === 'number' ? object[channels] : 1;
  	} else if (typeof object === 'number') {
  		// This is always RGB - can be converted later on.
  		this.model = 'rgb';
  		this.color = [
  			(object >> 16) & 0xFF,
  			(object >> 8) & 0xFF,
  			object & 0xFF,
  		];
  		this.valpha = 1;
  	} else {
  		this.valpha = 1;

  		const keys = Object.keys(object);
  		if ('alpha' in object) {
  			keys.splice(keys.indexOf('alpha'), 1);
  			this.valpha = typeof object.alpha === 'number' ? object.alpha : 0;
  		}

  		const hashedKeys = keys.sort().join('');
  		if (!(hashedKeys in hashedModelKeys)) {
  			throw new Error('Unable to parse color from object: ' + JSON.stringify(object));
  		}

  		this.model = hashedModelKeys[hashedKeys];

  		const {labels} = convert[this.model];
  		const color = [];
  		for (i = 0; i < labels.length; i++) {
  			color.push(object[labels[i]]);
  		}

  		this.color = zeroArray(color);
  	}

  	// Perform limitations (clamping, etc.)
  	if (limiters[this.model]) {
  		channels = convert[this.model].channels;
  		for (i = 0; i < channels; i++) {
  			const limit = limiters[this.model][i];
  			if (limit) {
  				this.color[i] = limit(this.color[i]);
  			}
  		}
  	}

  	this.valpha = Math.max(0, Math.min(1, this.valpha));

  	if (Object.freeze) {
  		Object.freeze(this);
  	}
  }

  Color.prototype = {
  	toString() {
  		return this.string();
  	},

  	toJSON() {
  		return this[this.model]();
  	},

  	string(places) {
  		let self = this.model in colorString.to ? this : this.rgb();
  		self = self.round(typeof places === 'number' ? places : 1);
  		const args = self.valpha === 1 ? self.color : [...self.color, this.valpha];
  		return colorString.to[self.model](args);
  	},

  	percentString(places) {
  		const self = this.rgb().round(typeof places === 'number' ? places : 1);
  		const args = self.valpha === 1 ? self.color : [...self.color, this.valpha];
  		return colorString.to.rgb.percent(args);
  	},

  	array() {
  		return this.valpha === 1 ? [...this.color] : [...this.color, this.valpha];
  	},

  	object() {
  		const result = {};
  		const {channels} = convert[this.model];
  		const {labels} = convert[this.model];

  		for (let i = 0; i < channels; i++) {
  			result[labels[i]] = this.color[i];
  		}

  		if (this.valpha !== 1) {
  			result.alpha = this.valpha;
  		}

  		return result;
  	},

  	unitArray() {
  		const rgb = this.rgb().color;
  		rgb[0] /= 255;
  		rgb[1] /= 255;
  		rgb[2] /= 255;

  		if (this.valpha !== 1) {
  			rgb.push(this.valpha);
  		}

  		return rgb;
  	},

  	unitObject() {
  		const rgb = this.rgb().object();
  		rgb.r /= 255;
  		rgb.g /= 255;
  		rgb.b /= 255;

  		if (this.valpha !== 1) {
  			rgb.alpha = this.valpha;
  		}

  		return rgb;
  	},

  	round(places) {
  		places = Math.max(places || 0, 0);
  		return new Color([...this.color.map(roundToPlace(places)), this.valpha], this.model);
  	},

  	alpha(value) {
  		if (value !== undefined) {
  			return new Color([...this.color, Math.max(0, Math.min(1, value))], this.model);
  		}

  		return this.valpha;
  	},

  	// Rgb
  	red: getset('rgb', 0, maxfn(255)),
  	green: getset('rgb', 1, maxfn(255)),
  	blue: getset('rgb', 2, maxfn(255)),

  	hue: getset(['hsl', 'hsv', 'hsl', 'hwb', 'hcg'], 0, value => ((value % 360) + 360) % 360),

  	saturationl: getset('hsl', 1, maxfn(100)),
  	lightness: getset('hsl', 2, maxfn(100)),

  	saturationv: getset('hsv', 1, maxfn(100)),
  	value: getset('hsv', 2, maxfn(100)),

  	chroma: getset('hcg', 1, maxfn(100)),
  	gray: getset('hcg', 2, maxfn(100)),

  	white: getset('hwb', 1, maxfn(100)),
  	wblack: getset('hwb', 2, maxfn(100)),

  	cyan: getset('cmyk', 0, maxfn(100)),
  	magenta: getset('cmyk', 1, maxfn(100)),
  	yellow: getset('cmyk', 2, maxfn(100)),
  	black: getset('cmyk', 3, maxfn(100)),

  	x: getset('xyz', 0, maxfn(95.047)),
  	y: getset('xyz', 1, maxfn(100)),
  	z: getset('xyz', 2, maxfn(108.833)),

  	l: getset('lab', 0, maxfn(100)),
  	a: getset('lab', 1),
  	b: getset('lab', 2),

  	keyword(value) {
  		if (value !== undefined) {
  			return new Color(value);
  		}

  		return convert[this.model].keyword(this.color);
  	},

  	hex(value) {
  		if (value !== undefined) {
  			return new Color(value);
  		}

  		return colorString.to.hex(this.rgb().round().color);
  	},

  	hexa(value) {
  		if (value !== undefined) {
  			return new Color(value);
  		}

  		const rgbArray = this.rgb().round().color;

  		let alphaHex = Math.round(this.valpha * 255).toString(16).toUpperCase();
  		if (alphaHex.length === 1) {
  			alphaHex = '0' + alphaHex;
  		}

  		return colorString.to.hex(rgbArray) + alphaHex;
  	},

  	rgbNumber() {
  		const rgb = this.rgb().color;
  		return ((rgb[0] & 0xFF) << 16) | ((rgb[1] & 0xFF) << 8) | (rgb[2] & 0xFF);
  	},

  	luminosity() {
  		// http://www.w3.org/TR/WCAG20/#relativeluminancedef
  		const rgb = this.rgb().color;

  		const lum = [];
  		for (const [i, element] of rgb.entries()) {
  			const chan = element / 255;
  			lum[i] = (chan <= 0.04045) ? chan / 12.92 : ((chan + 0.055) / 1.055) ** 2.4;
  		}

  		return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
  	},

  	contrast(color2) {
  		// http://www.w3.org/TR/WCAG20/#contrast-ratiodef
  		const lum1 = this.luminosity();
  		const lum2 = color2.luminosity();

  		if (lum1 > lum2) {
  			return (lum1 + 0.05) / (lum2 + 0.05);
  		}

  		return (lum2 + 0.05) / (lum1 + 0.05);
  	},

  	level(color2) {
  		// https://www.w3.org/TR/WCAG/#contrast-enhanced
  		const contrastRatio = this.contrast(color2);
  		if (contrastRatio >= 7) {
  			return 'AAA';
  		}

  		return (contrastRatio >= 4.5) ? 'AA' : '';
  	},

  	isDark() {
  		// YIQ equation from http://24ways.org/2010/calculating-color-contrast
  		const rgb = this.rgb().color;
  		const yiq = (rgb[0] * 2126 + rgb[1] * 7152 + rgb[2] * 722) / 10000;
  		return yiq < 128;
  	},

  	isLight() {
  		return !this.isDark();
  	},

  	negate() {
  		const rgb = this.rgb();
  		for (let i = 0; i < 3; i++) {
  			rgb.color[i] = 255 - rgb.color[i];
  		}

  		return rgb;
  	},

  	lighten(ratio) {
  		const hsl = this.hsl();
  		hsl.color[2] += hsl.color[2] * ratio;
  		return hsl;
  	},

  	darken(ratio) {
  		const hsl = this.hsl();
  		hsl.color[2] -= hsl.color[2] * ratio;
  		return hsl;
  	},

  	saturate(ratio) {
  		const hsl = this.hsl();
  		hsl.color[1] += hsl.color[1] * ratio;
  		return hsl;
  	},

  	desaturate(ratio) {
  		const hsl = this.hsl();
  		hsl.color[1] -= hsl.color[1] * ratio;
  		return hsl;
  	},

  	whiten(ratio) {
  		const hwb = this.hwb();
  		hwb.color[1] += hwb.color[1] * ratio;
  		return hwb;
  	},

  	blacken(ratio) {
  		const hwb = this.hwb();
  		hwb.color[2] += hwb.color[2] * ratio;
  		return hwb;
  	},

  	grayscale() {
  		// http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale
  		const rgb = this.rgb().color;
  		const value = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
  		return Color.rgb(value, value, value);
  	},

  	fade(ratio) {
  		return this.alpha(this.valpha - (this.valpha * ratio));
  	},

  	opaquer(ratio) {
  		return this.alpha(this.valpha + (this.valpha * ratio));
  	},

  	rotate(degrees) {
  		const hsl = this.hsl();
  		let hue = hsl.color[0];
  		hue = (hue + degrees) % 360;
  		hue = hue < 0 ? 360 + hue : hue;
  		hsl.color[0] = hue;
  		return hsl;
  	},

  	mix(mixinColor, weight) {
  		// Ported from sass implementation in C
  		// https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
  		if (!mixinColor || !mixinColor.rgb) {
  			throw new Error('Argument to "mix" was not a Color instance, but rather an instance of ' + typeof mixinColor);
  		}

  		const color1 = mixinColor.rgb();
  		const color2 = this.rgb();
  		const p = weight === undefined ? 0.5 : weight;

  		const w = 2 * p - 1;
  		const a = color1.alpha() - color2.alpha();

  		const w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2;
  		const w2 = 1 - w1;

  		return Color.rgb(
  			w1 * color1.red() + w2 * color2.red(),
  			w1 * color1.green() + w2 * color2.green(),
  			w1 * color1.blue() + w2 * color2.blue(),
  			color1.alpha() * p + color2.alpha() * (1 - p));
  	},
  };

  // Model conversion methods and static constructors
  for (const model of Object.keys(convert)) {
  	if (skippedModels.includes(model)) {
  		continue;
  	}

  	const {channels} = convert[model];

  	// Conversion methods
  	Color.prototype[model] = function (...args) {
  		if (this.model === model) {
  			return new Color(this);
  		}

  		if (args.length > 0) {
  			return new Color(args, model);
  		}

  		return new Color([...assertArray(convert[this.model][model].raw(this.color)), this.valpha], model);
  	};

  	// 'static' construction methods
  	Color[model] = function (...args) {
  		let color = args[0];
  		if (typeof color === 'number') {
  			color = zeroArray(args, channels);
  		}

  		return new Color(color, model);
  	};
  }

  function roundTo(number, places) {
  	return Number(number.toFixed(places));
  }

  function roundToPlace(places) {
  	return function (number) {
  		return roundTo(number, places);
  	};
  }

  function getset(model, channel, modifier) {
  	model = Array.isArray(model) ? model : [model];

  	for (const m of model) {
  		(limiters[m] || (limiters[m] = []))[channel] = modifier;
  	}

  	model = model[0];

  	return function (value) {
  		let result;

  		if (value !== undefined) {
  			if (modifier) {
  				value = modifier(value);
  			}

  			result = this[model]();
  			result.color[channel] = value;
  			return result;
  		}

  		result = this[model]().color[channel];
  		if (modifier) {
  			result = modifier(result);
  		}

  		return result;
  	};
  }

  function maxfn(max) {
  	return function (v) {
  		return Math.max(0, Math.min(max, v));
  	};
  }

  function assertArray(value) {
  	return Array.isArray(value) ? value : [value];
  }

  function zeroArray(array, length) {
  	for (let i = 0; i < length; i++) {
  		if (typeof array[i] !== 'number') {
  			array[i] = 0;
  		}
  	}

  	return array;
  }

  var color = Color;

  var Color$1 = color;

  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */

  /** Used as the `TypeError` message for "Functions" methods. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /** Used as the internal argument placeholder. */
  var PLACEHOLDER = '__lodash_placeholder__';

  /** Used to compose bitmasks for function metadata. */
  var BIND_FLAG = 1,
      BIND_KEY_FLAG = 2,
      CURRY_BOUND_FLAG = 4,
      CURRY_FLAG = 8,
      CURRY_RIGHT_FLAG = 16,
      PARTIAL_FLAG = 32,
      PARTIAL_RIGHT_FLAG = 64,
      ARY_FLAG = 128,
      REARG_FLAG = 256,
      FLIP_FLAG = 512;

  /** Used as references for various `Number` constants. */
  var INFINITY = 1 / 0,
      MAX_SAFE_INTEGER = 9007199254740991,
      MAX_INTEGER = 1.7976931348623157e+308,
      NAN = 0 / 0;

  /** Used to associate wrap methods with their bit flags. */
  var wrapFlags = [
    ['ary', ARY_FLAG],
    ['bind', BIND_FLAG],
    ['bindKey', BIND_KEY_FLAG],
    ['curry', CURRY_FLAG],
    ['curryRight', CURRY_RIGHT_FLAG],
    ['flip', FLIP_FLAG],
    ['partial', PARTIAL_FLAG],
    ['partialRight', PARTIAL_RIGHT_FLAG],
    ['rearg', REARG_FLAG]
  ];

  /** `Object#toString` result references. */
  var funcTag = '[object Function]',
      genTag = '[object GeneratorFunction]',
      symbolTag = '[object Symbol]';

  /**
   * Used to match `RegExp`
   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
   */
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

  /** Used to match leading and trailing whitespace. */
  var reTrim = /^\s+|\s+$/g;

  /** Used to match wrap detail comments. */
  var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
      reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
      reSplitDetails = /,? & /;

  /** Used to detect bad signed hexadecimal string values. */
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

  /** Used to detect binary string values. */
  var reIsBinary = /^0b[01]+$/i;

  /** Used to detect host constructors (Safari). */
  var reIsHostCtor = /^\[object .+?Constructor\]$/;

  /** Used to detect octal string values. */
  var reIsOctal = /^0o[0-7]+$/i;

  /** Used to detect unsigned integer values. */
  var reIsUint = /^(?:0|[1-9]\d*)$/;

  /** Built-in method references without a dependency on `root`. */
  var freeParseInt = parseInt;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

  /** Detect free variable `self`. */
  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  /** Used as a reference to the global object. */
  var root = freeGlobal || freeSelf || Function('return this')();

  /**
   * A faster alternative to `Function#apply`, this function invokes `func`
   * with the `this` binding of `thisArg` and the arguments of `args`.
   *
   * @private
   * @param {Function} func The function to invoke.
   * @param {*} thisArg The `this` binding of `func`.
   * @param {Array} args The arguments to invoke `func` with.
   * @returns {*} Returns the result of `func`.
   */
  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0: return func.call(thisArg);
      case 1: return func.call(thisArg, args[0]);
      case 2: return func.call(thisArg, args[0], args[1]);
      case 3: return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }

  /**
   * A specialized version of `_.forEach` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns `array`.
   */
  function arrayEach(array, iteratee) {
    var index = -1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }

  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */
  function arrayIncludes(array, value) {
    var length = array ? array.length : 0;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }

  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 1 : -1);

    while ((fromRight ? index-- : ++index < length)) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return baseFindIndex(array, baseIsNaN, fromIndex);
    }
    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.isNaN` without support for number objects.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
   */
  function baseIsNaN(value) {
    return value !== value;
  }

  /**
   * Gets the number of `placeholder` occurrences in `array`.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} placeholder The placeholder to search for.
   * @returns {number} Returns the placeholder count.
   */
  function countHolders(array, placeholder) {
    var length = array.length,
        result = 0;

    while (length--) {
      if (array[length] === placeholder) {
        result++;
      }
    }
    return result;
  }

  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */
  function getValue(object, key) {
    return object == null ? undefined : object[key];
  }

  /**
   * Checks if `value` is a host object in IE < 9.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
   */
  function isHostObject(value) {
    // Many host objects are `Object` objects that can coerce to strings
    // despite having improperly defined `toString` methods.
    var result = false;
    if (value != null && typeof value.toString != 'function') {
      try {
        result = !!(value + '');
      } catch (e) {}
    }
    return result;
  }

  /**
   * Replaces all `placeholder` elements in `array` with an internal placeholder
   * and returns an array of their indexes.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {*} placeholder The placeholder to replace.
   * @returns {Array} Returns the new array of placeholder indexes.
   */
  function replaceHolders(array, placeholder) {
    var index = -1,
        length = array.length,
        resIndex = 0,
        result = [];

    while (++index < length) {
      var value = array[index];
      if (value === placeholder || value === PLACEHOLDER) {
        array[index] = PLACEHOLDER;
        result[resIndex++] = index;
      }
    }
    return result;
  }

  /** Used for built-in method references. */
  var funcProto = Function.prototype,
      objectProto = Object.prototype;

  /** Used to detect overreaching core-js shims. */
  var coreJsData = root['__core-js_shared__'];

  /** Used to detect methods masquerading as native. */
  var maskSrcKey = (function() {
    var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
    return uid ? ('Symbol(src)_1.' + uid) : '';
  }());

  /** Used to resolve the decompiled source of functions. */
  var funcToString = funcProto.toString;

  /** Used to check objects for own properties. */
  var hasOwnProperty = objectProto.hasOwnProperty;

  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */
  var objectToString = objectProto.toString;

  /** Used to detect if a method is native. */
  var reIsNative = RegExp('^' +
    funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
    .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
  );

  /** Built-in value references. */
  var objectCreate = Object.create;

  /* Built-in method references for those with the same name as other `lodash` methods. */
  var nativeMax = Math.max,
      nativeMin = Math.min;

  /* Used to set `toString` methods. */
  var defineProperty = (function() {
    var func = getNative(Object, 'defineProperty'),
        name = getNative.name;

    return (name && name.length > 2) ? func : undefined;
  }());

  /**
   * The base implementation of `_.create` without support for assigning
   * properties to the created object.
   *
   * @private
   * @param {Object} prototype The object to inherit from.
   * @returns {Object} Returns the new object.
   */
  function baseCreate(proto) {
    return isObject(proto) ? objectCreate(proto) : {};
  }

  /**
   * The base implementation of `_.isNative` without bad shim checks.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a native function,
   *  else `false`.
   */
  function baseIsNative(value) {
    if (!isObject(value) || isMasked(value)) {
      return false;
    }
    var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }

  /**
   * Creates an array that is the composition of partially applied arguments,
   * placeholders, and provided arguments into a single array of arguments.
   *
   * @private
   * @param {Array} args The provided arguments.
   * @param {Array} partials The arguments to prepend to those provided.
   * @param {Array} holders The `partials` placeholder indexes.
   * @params {boolean} [isCurried] Specify composing for a curried function.
   * @returns {Array} Returns the new array of composed arguments.
   */
  function composeArgs(args, partials, holders, isCurried) {
    var argsIndex = -1,
        argsLength = args.length,
        holdersLength = holders.length,
        leftIndex = -1,
        leftLength = partials.length,
        rangeLength = nativeMax(argsLength - holdersLength, 0),
        result = Array(leftLength + rangeLength),
        isUncurried = !isCurried;

    while (++leftIndex < leftLength) {
      result[leftIndex] = partials[leftIndex];
    }
    while (++argsIndex < holdersLength) {
      if (isUncurried || argsIndex < argsLength) {
        result[holders[argsIndex]] = args[argsIndex];
      }
    }
    while (rangeLength--) {
      result[leftIndex++] = args[argsIndex++];
    }
    return result;
  }

  /**
   * This function is like `composeArgs` except that the arguments composition
   * is tailored for `_.partialRight`.
   *
   * @private
   * @param {Array} args The provided arguments.
   * @param {Array} partials The arguments to append to those provided.
   * @param {Array} holders The `partials` placeholder indexes.
   * @params {boolean} [isCurried] Specify composing for a curried function.
   * @returns {Array} Returns the new array of composed arguments.
   */
  function composeArgsRight(args, partials, holders, isCurried) {
    var argsIndex = -1,
        argsLength = args.length,
        holdersIndex = -1,
        holdersLength = holders.length,
        rightIndex = -1,
        rightLength = partials.length,
        rangeLength = nativeMax(argsLength - holdersLength, 0),
        result = Array(rangeLength + rightLength),
        isUncurried = !isCurried;

    while (++argsIndex < rangeLength) {
      result[argsIndex] = args[argsIndex];
    }
    var offset = argsIndex;
    while (++rightIndex < rightLength) {
      result[offset + rightIndex] = partials[rightIndex];
    }
    while (++holdersIndex < holdersLength) {
      if (isUncurried || argsIndex < argsLength) {
        result[offset + holders[holdersIndex]] = args[argsIndex++];
      }
    }
    return result;
  }

  /**
   * Copies the values of `source` to `array`.
   *
   * @private
   * @param {Array} source The array to copy values from.
   * @param {Array} [array=[]] The array to copy values to.
   * @returns {Array} Returns `array`.
   */
  function copyArray(source, array) {
    var index = -1,
        length = source.length;

    array || (array = Array(length));
    while (++index < length) {
      array[index] = source[index];
    }
    return array;
  }

  /**
   * Creates a function that wraps `func` to invoke it with the optional `this`
   * binding of `thisArg`.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {*} [thisArg] The `this` binding of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createBind(func, bitmask, thisArg) {
    var isBind = bitmask & BIND_FLAG,
        Ctor = createCtor(func);

    function wrapper() {
      var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
      return fn.apply(isBind ? thisArg : this, arguments);
    }
    return wrapper;
  }

  /**
   * Creates a function that produces an instance of `Ctor` regardless of
   * whether it was invoked as part of a `new` expression or by `call` or `apply`.
   *
   * @private
   * @param {Function} Ctor The constructor to wrap.
   * @returns {Function} Returns the new wrapped function.
   */
  function createCtor(Ctor) {
    return function() {
      // Use a `switch` statement to work with class constructors. See
      // http://ecma-international.org/ecma-262/7.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
      // for more details.
      var args = arguments;
      switch (args.length) {
        case 0: return new Ctor;
        case 1: return new Ctor(args[0]);
        case 2: return new Ctor(args[0], args[1]);
        case 3: return new Ctor(args[0], args[1], args[2]);
        case 4: return new Ctor(args[0], args[1], args[2], args[3]);
        case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
        case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
        case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
      }
      var thisBinding = baseCreate(Ctor.prototype),
          result = Ctor.apply(thisBinding, args);

      // Mimic the constructor's `return` behavior.
      // See https://es5.github.io/#x13.2.2 for more details.
      return isObject(result) ? result : thisBinding;
    };
  }

  /**
   * Creates a function that wraps `func` to enable currying.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {number} arity The arity of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createCurry(func, bitmask, arity) {
    var Ctor = createCtor(func);

    function wrapper() {
      var length = arguments.length,
          args = Array(length),
          index = length,
          placeholder = getHolder(wrapper);

      while (index--) {
        args[index] = arguments[index];
      }
      var holders = (length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder)
        ? []
        : replaceHolders(args, placeholder);

      length -= holders.length;
      if (length < arity) {
        return createRecurry(
          func, bitmask, createHybrid, wrapper.placeholder, undefined,
          args, holders, undefined, undefined, arity - length);
      }
      var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
      return apply(fn, this, args);
    }
    return wrapper;
  }

  /**
   * Creates a function that wraps `func` to invoke it with optional `this`
   * binding of `thisArg`, partial application, and currying.
   *
   * @private
   * @param {Function|string} func The function or method name to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {*} [thisArg] The `this` binding of `func`.
   * @param {Array} [partials] The arguments to prepend to those provided to
   *  the new function.
   * @param {Array} [holders] The `partials` placeholder indexes.
   * @param {Array} [partialsRight] The arguments to append to those provided
   *  to the new function.
   * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
   * @param {Array} [argPos] The argument positions of the new function.
   * @param {number} [ary] The arity cap of `func`.
   * @param {number} [arity] The arity of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
    var isAry = bitmask & ARY_FLAG,
        isBind = bitmask & BIND_FLAG,
        isBindKey = bitmask & BIND_KEY_FLAG,
        isCurried = bitmask & (CURRY_FLAG | CURRY_RIGHT_FLAG),
        isFlip = bitmask & FLIP_FLAG,
        Ctor = isBindKey ? undefined : createCtor(func);

    function wrapper() {
      var length = arguments.length,
          args = Array(length),
          index = length;

      while (index--) {
        args[index] = arguments[index];
      }
      if (isCurried) {
        var placeholder = getHolder(wrapper),
            holdersCount = countHolders(args, placeholder);
      }
      if (partials) {
        args = composeArgs(args, partials, holders, isCurried);
      }
      if (partialsRight) {
        args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
      }
      length -= holdersCount;
      if (isCurried && length < arity) {
        var newHolders = replaceHolders(args, placeholder);
        return createRecurry(
          func, bitmask, createHybrid, wrapper.placeholder, thisArg,
          args, newHolders, argPos, ary, arity - length
        );
      }
      var thisBinding = isBind ? thisArg : this,
          fn = isBindKey ? thisBinding[func] : func;

      length = args.length;
      if (argPos) {
        args = reorder(args, argPos);
      } else if (isFlip && length > 1) {
        args.reverse();
      }
      if (isAry && ary < length) {
        args.length = ary;
      }
      if (this && this !== root && this instanceof wrapper) {
        fn = Ctor || createCtor(fn);
      }
      return fn.apply(thisBinding, args);
    }
    return wrapper;
  }

  /**
   * Creates a function that wraps `func` to invoke it with the `this` binding
   * of `thisArg` and `partials` prepended to the arguments it receives.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {*} thisArg The `this` binding of `func`.
   * @param {Array} partials The arguments to prepend to those provided to
   *  the new function.
   * @returns {Function} Returns the new wrapped function.
   */
  function createPartial(func, bitmask, thisArg, partials) {
    var isBind = bitmask & BIND_FLAG,
        Ctor = createCtor(func);

    function wrapper() {
      var argsIndex = -1,
          argsLength = arguments.length,
          leftIndex = -1,
          leftLength = partials.length,
          args = Array(leftLength + argsLength),
          fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;

      while (++leftIndex < leftLength) {
        args[leftIndex] = partials[leftIndex];
      }
      while (argsLength--) {
        args[leftIndex++] = arguments[++argsIndex];
      }
      return apply(fn, isBind ? thisArg : this, args);
    }
    return wrapper;
  }

  /**
   * Creates a function that wraps `func` to continue currying.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {Function} wrapFunc The function to create the `func` wrapper.
   * @param {*} placeholder The placeholder value.
   * @param {*} [thisArg] The `this` binding of `func`.
   * @param {Array} [partials] The arguments to prepend to those provided to
   *  the new function.
   * @param {Array} [holders] The `partials` placeholder indexes.
   * @param {Array} [argPos] The argument positions of the new function.
   * @param {number} [ary] The arity cap of `func`.
   * @param {number} [arity] The arity of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary, arity) {
    var isCurry = bitmask & CURRY_FLAG,
        newHolders = isCurry ? holders : undefined,
        newHoldersRight = isCurry ? undefined : holders,
        newPartials = isCurry ? partials : undefined,
        newPartialsRight = isCurry ? undefined : partials;

    bitmask |= (isCurry ? PARTIAL_FLAG : PARTIAL_RIGHT_FLAG);
    bitmask &= ~(isCurry ? PARTIAL_RIGHT_FLAG : PARTIAL_FLAG);

    if (!(bitmask & CURRY_BOUND_FLAG)) {
      bitmask &= ~(BIND_FLAG | BIND_KEY_FLAG);
    }

    var result = wrapFunc(func, bitmask, thisArg, newPartials, newHolders, newPartialsRight, newHoldersRight, argPos, ary, arity);
    result.placeholder = placeholder;
    return setWrapToString(result, func, bitmask);
  }

  /**
   * Creates a function that either curries or invokes `func` with optional
   * `this` binding and partially applied arguments.
   *
   * @private
   * @param {Function|string} func The function or method name to wrap.
   * @param {number} bitmask The bitmask flags.
   *  The bitmask may be composed of the following flags:
   *     1 - `_.bind`
   *     2 - `_.bindKey`
   *     4 - `_.curry` or `_.curryRight` of a bound function
   *     8 - `_.curry`
   *    16 - `_.curryRight`
   *    32 - `_.partial`
   *    64 - `_.partialRight`
   *   128 - `_.rearg`
   *   256 - `_.ary`
   *   512 - `_.flip`
   * @param {*} [thisArg] The `this` binding of `func`.
   * @param {Array} [partials] The arguments to be partially applied.
   * @param {Array} [holders] The `partials` placeholder indexes.
   * @param {Array} [argPos] The argument positions of the new function.
   * @param {number} [ary] The arity cap of `func`.
   * @param {number} [arity] The arity of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
    var isBindKey = bitmask & BIND_KEY_FLAG;
    if (!isBindKey && typeof func != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    var length = partials ? partials.length : 0;
    if (!length) {
      bitmask &= ~(PARTIAL_FLAG | PARTIAL_RIGHT_FLAG);
      partials = holders = undefined;
    }
    ary = ary === undefined ? ary : nativeMax(toInteger(ary), 0);
    arity = arity === undefined ? arity : toInteger(arity);
    length -= holders ? holders.length : 0;

    if (bitmask & PARTIAL_RIGHT_FLAG) {
      var partialsRight = partials,
          holdersRight = holders;

      partials = holders = undefined;
    }

    var newData = [
      func, bitmask, thisArg, partials, holders, partialsRight, holdersRight,
      argPos, ary, arity
    ];

    func = newData[0];
    bitmask = newData[1];
    thisArg = newData[2];
    partials = newData[3];
    holders = newData[4];
    arity = newData[9] = newData[9] == null
      ? (isBindKey ? 0 : func.length)
      : nativeMax(newData[9] - length, 0);

    if (!arity && bitmask & (CURRY_FLAG | CURRY_RIGHT_FLAG)) {
      bitmask &= ~(CURRY_FLAG | CURRY_RIGHT_FLAG);
    }
    if (!bitmask || bitmask == BIND_FLAG) {
      var result = createBind(func, bitmask, thisArg);
    } else if (bitmask == CURRY_FLAG || bitmask == CURRY_RIGHT_FLAG) {
      result = createCurry(func, bitmask, arity);
    } else if ((bitmask == PARTIAL_FLAG || bitmask == (BIND_FLAG | PARTIAL_FLAG)) && !holders.length) {
      result = createPartial(func, bitmask, thisArg, partials);
    } else {
      result = createHybrid.apply(undefined, newData);
    }
    return setWrapToString(result, func, bitmask);
  }

  /**
   * Gets the argument placeholder value for `func`.
   *
   * @private
   * @param {Function} func The function to inspect.
   * @returns {*} Returns the placeholder value.
   */
  function getHolder(func) {
    var object = func;
    return object.placeholder;
  }

  /**
   * Gets the native function at `key` of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {string} key The key of the method to get.
   * @returns {*} Returns the function if it's native, else `undefined`.
   */
  function getNative(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : undefined;
  }

  /**
   * Extracts wrapper details from the `source` body comment.
   *
   * @private
   * @param {string} source The source to inspect.
   * @returns {Array} Returns the wrapper details.
   */
  function getWrapDetails(source) {
    var match = source.match(reWrapDetails);
    return match ? match[1].split(reSplitDetails) : [];
  }

  /**
   * Inserts wrapper `details` in a comment at the top of the `source` body.
   *
   * @private
   * @param {string} source The source to modify.
   * @returns {Array} details The details to insert.
   * @returns {string} Returns the modified source.
   */
  function insertWrapDetails(source, details) {
    var length = details.length,
        lastIndex = length - 1;

    details[lastIndex] = (length > 1 ? '& ' : '') + details[lastIndex];
    details = details.join(length > 2 ? ', ' : ' ');
    return source.replace(reWrapComment, '{\n/* [wrapped with ' + details + '] */\n');
  }

  /**
   * Checks if `value` is a valid array-like index.
   *
   * @private
   * @param {*} value The value to check.
   * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
   * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
   */
  function isIndex(value, length) {
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length &&
      (typeof value == 'number' || reIsUint.test(value)) &&
      (value > -1 && value % 1 == 0 && value < length);
  }

  /**
   * Checks if `func` has its source masked.
   *
   * @private
   * @param {Function} func The function to check.
   * @returns {boolean} Returns `true` if `func` is masked, else `false`.
   */
  function isMasked(func) {
    return !!maskSrcKey && (maskSrcKey in func);
  }

  /**
   * Reorder `array` according to the specified indexes where the element at
   * the first index is assigned as the first element, the element at
   * the second index is assigned as the second element, and so on.
   *
   * @private
   * @param {Array} array The array to reorder.
   * @param {Array} indexes The arranged array indexes.
   * @returns {Array} Returns `array`.
   */
  function reorder(array, indexes) {
    var arrLength = array.length,
        length = nativeMin(indexes.length, arrLength),
        oldArray = copyArray(array);

    while (length--) {
      var index = indexes[length];
      array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
    }
    return array;
  }

  /**
   * Sets the `toString` method of `wrapper` to mimic the source of `reference`
   * with wrapper details in a comment at the top of the source body.
   *
   * @private
   * @param {Function} wrapper The function to modify.
   * @param {Function} reference The reference function.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @returns {Function} Returns `wrapper`.
   */
  var setWrapToString = !defineProperty ? identity$1 : function(wrapper, reference, bitmask) {
    var source = (reference + '');
    return defineProperty(wrapper, 'toString', {
      'configurable': true,
      'enumerable': false,
      'value': constant(insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)))
    });
  };

  /**
   * Converts `func` to its source code.
   *
   * @private
   * @param {Function} func The function to process.
   * @returns {string} Returns the source code.
   */
  function toSource(func) {
    if (func != null) {
      try {
        return funcToString.call(func);
      } catch (e) {}
      try {
        return (func + '');
      } catch (e) {}
    }
    return '';
  }

  /**
   * Updates wrapper `details` based on `bitmask` flags.
   *
   * @private
   * @returns {Array} details The details to modify.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @returns {Array} Returns `details`.
   */
  function updateWrapDetails(details, bitmask) {
    arrayEach(wrapFlags, function(pair) {
      var value = '_.' + pair[0];
      if ((bitmask & pair[1]) && !arrayIncludes(details, value)) {
        details.push(value);
      }
    });
    return details.sort();
  }

  /**
   * Creates a function that accepts arguments of `func` and either invokes
   * `func` returning its result, if at least `arity` number of arguments have
   * been provided, or returns a function that accepts the remaining `func`
   * arguments, and so on. The arity of `func` may be specified if `func.length`
   * is not sufficient.
   *
   * The `_.curry.placeholder` value, which defaults to `_` in monolithic builds,
   * may be used as a placeholder for provided arguments.
   *
   * **Note:** This method doesn't set the "length" property of curried functions.
   *
   * @static
   * @memberOf _
   * @since 2.0.0
   * @category Function
   * @param {Function} func The function to curry.
   * @param {number} [arity=func.length] The arity of `func`.
   * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
   * @returns {Function} Returns the new curried function.
   * @example
   *
   * var abc = function(a, b, c) {
   *   return [a, b, c];
   * };
   *
   * var curried = _.curry(abc);
   *
   * curried(1)(2)(3);
   * // => [1, 2, 3]
   *
   * curried(1, 2)(3);
   * // => [1, 2, 3]
   *
   * curried(1, 2, 3);
   * // => [1, 2, 3]
   *
   * // Curried with placeholders.
   * curried(1)(_, 3)(2);
   * // => [1, 2, 3]
   */
  function curry(func, arity, guard) {
    arity = guard ? undefined : arity;
    var result = createWrap(func, CURRY_FLAG, undefined, undefined, undefined, undefined, undefined, arity);
    result.placeholder = curry.placeholder;
    return result;
  }

  /**
   * Checks if `value` is classified as a `Function` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a function, else `false`.
   * @example
   *
   * _.isFunction(_);
   * // => true
   *
   * _.isFunction(/abc/);
   * // => false
   */
  function isFunction(value) {
    // The use of `Object#toString` avoids issues with the `typeof` operator
    // in Safari 8-9 which returns 'object' for typed array and other constructors.
    var tag = isObject(value) ? objectToString.call(value) : '';
    return tag == funcTag || tag == genTag;
  }

  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */
  function isObject(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }

  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */
  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }

  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */
  function isSymbol(value) {
    return typeof value == 'symbol' ||
      (isObjectLike(value) && objectToString.call(value) == symbolTag);
  }

  /**
   * Converts `value` to a finite number.
   *
   * @static
   * @memberOf _
   * @since 4.12.0
   * @category Lang
   * @param {*} value The value to convert.
   * @returns {number} Returns the converted number.
   * @example
   *
   * _.toFinite(3.2);
   * // => 3.2
   *
   * _.toFinite(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toFinite(Infinity);
   * // => 1.7976931348623157e+308
   *
   * _.toFinite('3.2');
   * // => 3.2
   */
  function toFinite(value) {
    if (!value) {
      return value === 0 ? value : 0;
    }
    value = toNumber(value);
    if (value === INFINITY || value === -INFINITY) {
      var sign = (value < 0 ? -1 : 1);
      return sign * MAX_INTEGER;
    }
    return value === value ? value : 0;
  }

  /**
   * Converts `value` to an integer.
   *
   * **Note:** This method is loosely based on
   * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to convert.
   * @returns {number} Returns the converted integer.
   * @example
   *
   * _.toInteger(3.2);
   * // => 3
   *
   * _.toInteger(Number.MIN_VALUE);
   * // => 0
   *
   * _.toInteger(Infinity);
   * // => 1.7976931348623157e+308
   *
   * _.toInteger('3.2');
   * // => 3
   */
  function toInteger(value) {
    var result = toFinite(value),
        remainder = result % 1;

    return result === result ? (remainder ? result - remainder : result) : 0;
  }

  /**
   * Converts `value` to a number.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {number} Returns the number.
   * @example
   *
   * _.toNumber(3.2);
   * // => 3.2
   *
   * _.toNumber(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toNumber(Infinity);
   * // => Infinity
   *
   * _.toNumber('3.2');
   * // => 3.2
   */
  function toNumber(value) {
    if (typeof value == 'number') {
      return value;
    }
    if (isSymbol(value)) {
      return NAN;
    }
    if (isObject(value)) {
      var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
      value = isObject(other) ? (other + '') : other;
    }
    if (typeof value != 'string') {
      return value === 0 ? value : +value;
    }
    value = value.replace(reTrim, '');
    var isBinary = reIsBinary.test(value);
    return (isBinary || reIsOctal.test(value))
      ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
      : (reIsBadHex.test(value) ? NAN : +value);
  }

  /**
   * Creates a function that returns `value`.
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Util
   * @param {*} value The value to return from the new function.
   * @returns {Function} Returns the new constant function.
   * @example
   *
   * var objects = _.times(2, _.constant({ 'a': 1 }));
   *
   * console.log(objects);
   * // => [{ 'a': 1 }, { 'a': 1 }]
   *
   * console.log(objects[0] === objects[1]);
   * // => true
   */
  function constant(value) {
    return function() {
      return value;
    };
  }

  /**
   * This method returns the first argument it receives.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Util
   * @param {*} value Any value.
   * @returns {*} Returns `value`.
   * @example
   *
   * var object = { 'a': 1 };
   *
   * console.log(_.identity(object) === object);
   * // => true
   */
  function identity$1(value) {
    return value;
  }

  // Assign default placeholders.
  curry.placeholder = {};

  var lodash_curry = curry;

  function yuv2rgb(yuv) {
    const y = yuv[0],
      u = yuv[1],
      v = yuv[2];
    let r, g, b;
    r = y * 1 + u * 0 + v * 1.13983;
    g = y * 1 + u * -0.39465 + v * -0.5806;
    b = y * 1 + u * 2.02311 + v * 0;
    r = Math.min(Math.max(0, r), 1);
    g = Math.min(Math.max(0, g), 1);
    b = Math.min(Math.max(0, b), 1);
    return [r * 255, g * 255, b * 255];
  }
  function rgb2yuv(rgb) {
    const r = rgb[0] / 255,
      g = rgb[1] / 255,
      b = rgb[2] / 255;
    const y = r * 0.299 + g * 0.587 + b * 0.114;
    const u = r * -0.14713 + g * -0.28886 + b * 0.436;
    const v = r * 0.615 + g * -0.51499 + b * -0.10001;
    return [y, u, v];
  }

  const DEFAULT_BASE16 = index;
  const BASE16_KEYS = Object.keys(DEFAULT_BASE16);

  // we need a correcting factor, so that a dark, but not black background color
  // converts to bright enough inversed color
  const flip = x => x < 0.25 ? 1 : x < 0.5 ? 0.9 - x : 1.1 - x;
  const invertColor = hexString => {
    const color = Color$1(hexString);
    const [y, u, v] = rgb2yuv(color.array());
    const flippedYuv = [flip(y), u, v];
    const rgb = yuv2rgb(flippedYuv);
    return Color$1.rgb(rgb).hex();
  };
  const merger = styling => {
    return prevStyling => ({
      className: [prevStyling.className, styling.className].filter(Boolean).join(' '),
      style: {
        ...(prevStyling.style || {}),
        ...(styling.style || {})
      }
    });
  };
  const mergeStyling = (customStyling, defaultStyling) => {
    if (customStyling === undefined) {
      return defaultStyling;
    }
    if (defaultStyling === undefined) {
      return customStyling;
    }
    const customType = typeof customStyling;
    const defaultType = typeof defaultStyling;
    switch (customType) {
      case 'string':
        switch (defaultType) {
          case 'string':
            return [defaultStyling, customStyling].filter(Boolean).join(' ');
          case 'object':
            return merger({
              className: customStyling,
              style: defaultStyling
            });
          case 'function':
            return function (styling) {
              for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                args[_key - 1] = arguments[_key];
              }
              return merger({
                className: customStyling
              })(defaultStyling(styling, ...args));
            };
        }
        break;
      case 'object':
        switch (defaultType) {
          case 'string':
            return merger({
              className: defaultStyling,
              style: customStyling
            });
          case 'object':
            return {
              ...defaultStyling,
              ...customStyling
            };
          case 'function':
            return function (styling) {
              for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
              }
              return merger({
                style: customStyling
              })(defaultStyling(styling, ...args));
            };
        }
        break;
      case 'function':
        switch (defaultType) {
          case 'string':
            return function (styling) {
              for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
                args[_key3 - 1] = arguments[_key3];
              }
              return customStyling(merger(styling)({
                className: defaultStyling
              }), ...args);
            };
          case 'object':
            return function (styling) {
              for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
                args[_key4 - 1] = arguments[_key4];
              }
              return customStyling(merger(styling)({
                style: defaultStyling
              }), ...args);
            };
          case 'function':
            return function (styling) {
              for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
                args[_key5 - 1] = arguments[_key5];
              }
              return customStyling(defaultStyling(styling, ...args), ...args);
            };
        }
    }
  };
  const mergeStylings = (customStylings, defaultStylings) => {
    const keys = Object.keys(defaultStylings);
    for (const key in customStylings) {
      if (keys.indexOf(key) === -1) keys.push(key);
    }
    return keys.reduce((mergedStyling, key) => (mergedStyling[key] = mergeStyling(customStylings[key], defaultStylings[key]), mergedStyling), {});
  };
  const getStylingByKeys = function (mergedStyling, keys) {
    for (var _len6 = arguments.length, args = new Array(_len6 > 2 ? _len6 - 2 : 0), _key6 = 2; _key6 < _len6; _key6++) {
      args[_key6 - 2] = arguments[_key6];
    }
    if (keys === null) {
      return mergedStyling;
    }
    if (!Array.isArray(keys)) {
      keys = [keys];
    }
    const styles = keys.map(key => mergedStyling[key]).filter(Boolean);
    const props = styles.reduce((obj, s) => {
      if (typeof s === 'string') {
        obj.className = [obj.className, s].filter(Boolean).join(' ');
      } else if (typeof s === 'object') {
        obj.style = {
          ...obj.style,
          ...s
        };
      } else if (typeof s === 'function') {
        obj = {
          ...obj,
          ...s(obj, ...args)
        };
      }
      return obj;
    }, {
      className: '',
      style: {}
    });
    if (!props.className) {
      delete props.className;
    }
    if (Object.keys(props.style).length === 0) {
      delete props.style;
    }
    return props;
  };
  const invertBase16Theme = base16Theme => Object.keys(base16Theme).reduce((t, key) => (t[key] = /^base/.test(key) ? invertColor(base16Theme[key]) : key === 'scheme' ? base16Theme[key] + ':inverted' : base16Theme[key], t), {});
  const createStyling = lodash_curry(function (getStylingFromBase16) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    let themeOrStyling = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    const {
      defaultBase16 = DEFAULT_BASE16,
      base16Themes = null
    } = options;
    const base16Theme = getBase16Theme(themeOrStyling, base16Themes);
    if (base16Theme) {
      themeOrStyling = {
        ...base16Theme,
        ...themeOrStyling
      };
    }
    const theme = BASE16_KEYS.reduce((t, key) => (t[key] = themeOrStyling[key] || defaultBase16[key], t), {});
    const customStyling = Object.keys(themeOrStyling).reduce((s, key) => BASE16_KEYS.indexOf(key) === -1 ? (s[key] = themeOrStyling[key], s) : s, {});
    const defaultStyling = getStylingFromBase16(theme);
    const mergedStyling = mergeStylings(customStyling, defaultStyling);
    for (var _len7 = arguments.length, args = new Array(_len7 > 3 ? _len7 - 3 : 0), _key7 = 3; _key7 < _len7; _key7++) {
      args[_key7 - 3] = arguments[_key7];
    }
    return lodash_curry(getStylingByKeys, 2)(mergedStyling, ...args);
  }, 3);
  const isStylingConfig = theme => !!theme.extend;
  const getBase16Theme = (theme, base16Themes) => {
    if (theme && isStylingConfig(theme) && theme.extend) {
      theme = theme.extend;
    }
    if (typeof theme === 'string') {
      const [themeName, modifier] = theme.split(':');
      if (base16Themes) {
        theme = base16Themes[themeName];
      } else {
        theme = base16[themeName];
      }
      if (modifier === 'inverted') {
        theme = invertBase16Theme(theme);
      }
    }
    return theme && Object.prototype.hasOwnProperty.call(theme, 'base00') ? theme : undefined;
  };
  const invertTheme = theme => {
    if (typeof theme === 'string') {
      return `${theme}:inverted`;
    }
    if (theme && isStylingConfig(theme) && theme.extend) {
      if (typeof theme.extend === 'string') {
        return {
          ...theme,
          extend: `${theme.extend}:inverted`
        };
      }
      return {
        ...theme,
        extend: invertBase16Theme(theme.extend)
      };
    }
    if (theme) {
      return invertBase16Theme(theme);
    }
    return theme;
  };

  var solarized = {
    scheme: 'solarized',
    author: 'ethan schoonover (http://ethanschoonover.com/solarized)',
    base00: '#002b36',
    base01: '#073642',
    base02: '#586e75',
    base03: '#657b83',
    base04: '#839496',
    base05: '#93a1a1',
    base06: '#eee8d5',
    base07: '#fdf6e3',
    base08: '#dc322f',
    base09: '#cb4b16',
    base0A: '#b58900',
    base0B: '#859900',
    base0C: '#2aa198',
    base0D: '#268bd2',
    base0E: '#6c71c4',
    base0F: '#d33682'
  };

  const colorMap = theme => ({
    BACKGROUND_COLOR: theme.base00,
    TEXT_COLOR: theme.base07,
    STRING_COLOR: theme.base0B,
    DATE_COLOR: theme.base0B,
    NUMBER_COLOR: theme.base09,
    BOOLEAN_COLOR: theme.base09,
    NULL_COLOR: theme.base08,
    UNDEFINED_COLOR: theme.base08,
    FUNCTION_COLOR: theme.base08,
    SYMBOL_COLOR: theme.base08,
    LABEL_COLOR: theme.base0D,
    ARROW_COLOR: theme.base0D,
    ITEM_STRING_COLOR: theme.base0B,
    ITEM_STRING_EXPANDED_COLOR: theme.base03
  });
  const valueColorMap = colors => ({
    String: colors.STRING_COLOR,
    Date: colors.DATE_COLOR,
    Number: colors.NUMBER_COLOR,
    Boolean: colors.BOOLEAN_COLOR,
    Null: colors.NULL_COLOR,
    Undefined: colors.UNDEFINED_COLOR,
    Function: colors.FUNCTION_COLOR,
    Symbol: colors.SYMBOL_COLOR
  });
  const getDefaultThemeStyling = theme => {
    const colors = colorMap(theme);
    return {
      tree: {
        border: 0,
        padding: 0,
        marginTop: '0.5em',
        marginBottom: '0.5em',
        marginLeft: '0.125em',
        marginRight: 0,
        listStyle: 'none',
        MozUserSelect: 'none',
        WebkitUserSelect: 'none',
        backgroundColor: colors.BACKGROUND_COLOR
      },
      value: (_ref, nodeType, keyPath) => {
        let {
          style
        } = _ref;
        return {
          style: {
            ...style,
            paddingTop: '0.25em',
            paddingRight: 0,
            marginLeft: '0.875em',
            WebkitUserSelect: 'text',
            MozUserSelect: 'text',
            wordWrap: 'break-word',
            paddingLeft: keyPath.length > 1 ? '2.125em' : '1.25em',
            textIndent: '-0.5em',
            wordBreak: 'break-all'
          }
        };
      },
      label: {
        display: 'inline-block',
        color: colors.LABEL_COLOR
      },
      valueLabel: {
        margin: '0 0.5em 0 0'
      },
      valueText: (_ref2, nodeType) => {
        let {
          style
        } = _ref2;
        return {
          style: {
            ...style,
            color: valueColorMap(colors)[nodeType]
          }
        };
      },
      itemRange: (styling, expanded) => ({
        style: {
          paddingTop: expanded ? 0 : '0.25em',
          cursor: 'pointer',
          color: colors.LABEL_COLOR
        }
      }),
      arrow: (_ref3, nodeType, expanded) => {
        let {
          style
        } = _ref3;
        return {
          style: {
            ...style,
            marginLeft: 0,
            transition: '150ms',
            WebkitTransition: '150ms',
            MozTransition: '150ms',
            WebkitTransform: expanded ? 'rotateZ(90deg)' : 'rotateZ(0deg)',
            MozTransform: expanded ? 'rotateZ(90deg)' : 'rotateZ(0deg)',
            transform: expanded ? 'rotateZ(90deg)' : 'rotateZ(0deg)',
            transformOrigin: '45% 50%',
            WebkitTransformOrigin: '45% 50%',
            MozTransformOrigin: '45% 50%',
            position: 'relative',
            lineHeight: '1.1em',
            fontSize: '0.75em'
          }
        };
      },
      arrowContainer: (_ref4, arrowStyle) => {
        let {
          style
        } = _ref4;
        return {
          style: {
            ...style,
            display: 'inline-block',
            paddingRight: '0.5em',
            paddingLeft: arrowStyle === 'double' ? '1em' : 0,
            cursor: 'pointer'
          }
        };
      },
      arrowSign: {
        color: colors.ARROW_COLOR
      },
      arrowSignInner: {
        position: 'absolute',
        top: 0,
        left: '-0.4em'
      },
      nestedNode: (_ref5, keyPath, nodeType, expanded, expandable) => {
        let {
          style
        } = _ref5;
        return {
          style: {
            ...style,
            position: 'relative',
            paddingTop: '0.25em',
            marginLeft: keyPath.length > 1 ? '0.875em' : 0,
            paddingLeft: !expandable ? '1.125em' : 0
          }
        };
      },
      rootNode: {
        padding: 0,
        margin: 0
      },
      nestedNodeLabel: (_ref6, keyPath, nodeType, expanded, expandable) => {
        let {
          style
        } = _ref6;
        return {
          style: {
            ...style,
            margin: 0,
            padding: 0,
            WebkitUserSelect: expandable ? 'inherit' : 'text',
            MozUserSelect: expandable ? 'inherit' : 'text',
            cursor: expandable ? 'pointer' : 'default'
          }
        };
      },
      nestedNodeItemString: (_ref7, keyPath, nodeType, expanded) => {
        let {
          style
        } = _ref7;
        return {
          style: {
            ...style,
            paddingLeft: '0.5em',
            cursor: 'default',
            color: expanded ? colors.ITEM_STRING_EXPANDED_COLOR : colors.ITEM_STRING_COLOR
          }
        };
      },
      nestedNodeItemType: {
        marginLeft: '0.3em',
        marginRight: '0.3em'
      },
      nestedNodeChildren: (_ref8, nodeType, expanded) => {
        let {
          style
        } = _ref8;
        return {
          style: {
            ...style,
            padding: 0,
            margin: 0,
            listStyle: 'none',
            display: expanded ? 'block' : 'none'
          }
        };
      },
      rootNodeChildren: {
        padding: 0,
        margin: 0,
        listStyle: 'none'
      }
    };
  };
  const createStylingFromTheme = createStyling(getDefaultThemeStyling, {
    defaultBase16: solarized
  });

  // ES6 + inline style port of JSONViewer https://bitbucket.org/davevedder/react-json-viewer/
  const identity = value => value;
  const expandRootNode = (keyPath, data, level) => level === 0;
  const defaultItemString = (type, data, itemType, itemString) => /*#__PURE__*/React.createElement("span", null, itemType, " ", itemString);
  const defaultLabelRenderer = _ref => {
    let [label] = _ref;
    return /*#__PURE__*/React.createElement("span", null, label, ":");
  };
  const noCustomNode = () => false;
  function JSONTree(_ref2) {
    let {
      data: value,
      theme,
      invertTheme: shouldInvertTheme,
      keyPath = ['root'],
      labelRenderer = defaultLabelRenderer,
      valueRenderer = identity,
      shouldExpandNodeInitially = expandRootNode,
      hideRoot = false,
      getItemString = defaultItemString,
      postprocessValue = identity,
      isCustomNode = noCustomNode,
      collectionLimit = 50,
      sortObjectKeys = false
    } = _ref2;
    const styling = React.useMemo(() => createStylingFromTheme(shouldInvertTheme ? invertTheme(theme) : theme), [theme, shouldInvertTheme]);
    return /*#__PURE__*/React.createElement("ul", {
      ...styling('tree')
    }, /*#__PURE__*/React.createElement(JSONNode, {
      keyPath: hideRoot ? [] : keyPath,
      value: postprocessValue(value),
      isCustomNode: isCustomNode,
      styling: styling,
      labelRenderer: labelRenderer,
      valueRenderer: valueRenderer,
      shouldExpandNodeInitially: shouldExpandNodeInitially,
      hideRoot: hideRoot,
      getItemString: getItemString,
      postprocessValue: postprocessValue,
      collectionLimit: collectionLimit,
      sortObjectKeys: sortObjectKeys
    }));
  }

  exports.JSONTree = JSONTree;

}));
