import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import objType from './objType';
import JSONObjectNode from './JSONObjectNode';
import JSONArrayNode from './JSONArrayNode';
import JSONIterableNode from './JSONIterableNode';
import JSONValueNode from './JSONValueNode';
export default function JSONNode(_ref) {
  let {
    getItemString,
    keyPath,
    labelRenderer,
    styling,
    value,
    valueRenderer,
    isCustomNode,
    ...rest
  } = _ref;
  const nodeType = isCustomNode(value) ? 'Custom' : objType(value);
  const simpleNodeProps = {
    getItemString,
    key: keyPath[0],
    keyPath,
    labelRenderer,
    nodeType,
    styling,
    value,
    valueRenderer
  };
  const nestedNodeProps = {
    ...rest,
    ...simpleNodeProps,
    data: value,
    isCustomNode
  };
  switch (nodeType) {
    case 'Object':
    case 'Error':
    case 'WeakMap':
    case 'WeakSet':
      return /*#__PURE__*/React.createElement(JSONObjectNode, nestedNodeProps);
    case 'Array':
      return /*#__PURE__*/React.createElement(JSONArrayNode, nestedNodeProps);
    case 'Iterable':
    case 'Map':
    case 'Set':
      return /*#__PURE__*/React.createElement(JSONIterableNode, nestedNodeProps);
    case 'String':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: raw => `"${raw}"`
      }));
    case 'Number':
      return /*#__PURE__*/React.createElement(JSONValueNode, simpleNodeProps);
    case 'Boolean':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: raw => raw ? 'true' : 'false'
      }));
    case 'Date':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: raw => raw.toISOString()
      }));
    case 'Null':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: () => 'null'
      }));
    case 'Undefined':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: () => 'undefined'
      }));
    case 'Function':
    case 'Symbol':
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: raw => raw.toString()
      }));
    case 'Custom':
      return /*#__PURE__*/React.createElement(JSONValueNode, simpleNodeProps);
    default:
      return /*#__PURE__*/React.createElement(JSONValueNode, _extends({}, simpleNodeProps, {
        valueGetter: () => `<${nodeType}>`
      }));
  }
}