import _extends from "@babel/runtime/helpers/extends";
import React, { useCallback, useState } from 'react';
import JSONArrow from './JSONArrow';
export default function ItemRange(props) {
  const {
    styling,
    from,
    to,
    renderChildNodes,
    nodeType
  } = props;
  const [expanded, setExpanded] = useState(false);
  const handleClick = useCallback(() => {
    setExpanded(!expanded);
  }, [expanded]);
  return expanded ? /*#__PURE__*/React.createElement("div", styling('itemRange', expanded), renderChildNodes(props, from, to)) : /*#__PURE__*/React.createElement("div", _extends({}, styling('itemRange', expanded), {
    onClick: handleClick
  }), /*#__PURE__*/React.createElement(JSONArrow, {
    nodeType: nodeType,
    styling: styling,
    expanded: false,
    onClick: handleClick,
    arrowStyle: "double"
  }), `${from} ... ${to}`);
}