"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONTree = JSONTree;
var _react = _interopRequireWildcard(require("react"));
var _JSONNode = _interopRequireDefault(require("./JSONNode"));
var _createStylingFromTheme = _interopRequireDefault(require("./createStylingFromTheme"));
var _reactBase16Styling = require("react-base16-styling");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// ES6 + inline style port of JSONViewer https://bitbucket.org/davevedder/react-json-viewer/
// all credits and original code to the author
// Dave Vedder <veddermatic@gmail.com> http://www.eskimospy.com/
// port by Daniele Zannotti http://www.github.com/dzannotti <dzannotti@me.com>

const identity = value => value;
const expandRootNode = (keyPath, data, level) => level === 0;
const defaultItemString = (type, data, itemType, itemString) => /*#__PURE__*/_react.default.createElement("span", null, itemType, " ", itemString);
const defaultLabelRenderer = _ref => {
  let [label] = _ref;
  return /*#__PURE__*/_react.default.createElement("span", null, label, ":");
};
const noCustomNode = () => false;
function JSONTree(_ref2) {
  let {
    data: value,
    theme,
    invertTheme: shouldInvertTheme,
    keyPath = ['root'],
    labelRenderer = defaultLabelRenderer,
    valueRenderer = identity,
    shouldExpandNodeInitially = expandRootNode,
    hideRoot = false,
    getItemString = defaultItemString,
    postprocessValue = identity,
    isCustomNode = noCustomNode,
    collectionLimit = 50,
    sortObjectKeys = false
  } = _ref2;
  const styling = (0, _react.useMemo)(() => (0, _createStylingFromTheme.default)(shouldInvertTheme ? (0, _reactBase16Styling.invertTheme)(theme) : theme), [theme, shouldInvertTheme]);
  return /*#__PURE__*/_react.default.createElement("ul", styling('tree'), /*#__PURE__*/_react.default.createElement(_JSONNode.default, {
    keyPath: hideRoot ? [] : keyPath,
    value: postprocessValue(value),
    isCustomNode: isCustomNode,
    styling: styling,
    labelRenderer: labelRenderer,
    valueRenderer: valueRenderer,
    shouldExpandNodeInitially: shouldExpandNodeInitially,
    hideRoot: hideRoot,
    getItemString: getItemString,
    postprocessValue: postprocessValue,
    collectionLimit: collectionLimit,
    sortObjectKeys: sortObjectKeys
  }));
}