"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = JSONNode;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _objType = _interopRequireDefault(require("./objType"));
var _JSONObjectNode = _interopRequireDefault(require("./JSONObjectNode"));
var _JSONArrayNode = _interopRequireDefault(require("./JSONArrayNode"));
var _JSONIterableNode = _interopRequireDefault(require("./JSONIterableNode"));
var _JSONValueNode = _interopRequireDefault(require("./JSONValueNode"));
function JSONNode(_ref) {
  let {
    getItemString,
    keyPath,
    labelRenderer,
    styling,
    value,
    valueRenderer,
    isCustomNode,
    ...rest
  } = _ref;
  const nodeType = isCustomNode(value) ? 'Custom' : (0, _objType.default)(value);
  const simpleNodeProps = {
    getItemString,
    key: keyPath[0],
    keyPath,
    labelRenderer,
    nodeType,
    styling,
    value,
    valueRenderer
  };
  const nestedNodeProps = {
    ...rest,
    ...simpleNodeProps,
    data: value,
    isCustomNode
  };
  switch (nodeType) {
    case 'Object':
    case 'Error':
    case 'WeakMap':
    case 'WeakSet':
      return /*#__PURE__*/_react.default.createElement(_JSONObjectNode.default, nestedNodeProps);
    case 'Array':
      return /*#__PURE__*/_react.default.createElement(_JSONArrayNode.default, nestedNodeProps);
    case 'Iterable':
    case 'Map':
    case 'Set':
      return /*#__PURE__*/_react.default.createElement(_JSONIterableNode.default, nestedNodeProps);
    case 'String':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: raw => `"${raw}"`
      }));
    case 'Number':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, simpleNodeProps);
    case 'Boolean':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: raw => raw ? 'true' : 'false'
      }));
    case 'Date':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: raw => raw.toISOString()
      }));
    case 'Null':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: () => 'null'
      }));
    case 'Undefined':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: () => 'undefined'
      }));
    case 'Function':
    case 'Symbol':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: raw => raw.toString()
      }));
    case 'Custom':
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, simpleNodeProps);
    default:
      return /*#__PURE__*/_react.default.createElement(_JSONValueNode.default, (0, _extends2.default)({}, simpleNodeProps, {
        valueGetter: () => `<${nodeType}>`
      }));
  }
}