"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = JSONNestedNode;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _JSONArrow = _interopRequireDefault(require("./JSONArrow"));
var _getCollectionEntries = _interopRequireDefault(require("./getCollectionEntries"));
var _JSONNode = _interopRequireDefault(require("./JSONNode"));
var _ItemRange = _interopRequireDefault(require("./ItemRange"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function isRange(rangeOrEntry) {
  return rangeOrEntry.to !== undefined;
}
function renderChildNodes(props, from, to) {
  const {
    nodeType,
    data,
    collectionLimit,
    circularCache,
    keyPath,
    postprocessValue,
    sortObjectKeys
  } = props;
  const childNodes = [];
  (0, _getCollectionEntries.default)(nodeType, data, sortObjectKeys, collectionLimit, from, to).forEach(entry => {
    if (isRange(entry)) {
      childNodes.push( /*#__PURE__*/_react.default.createElement(_ItemRange.default, (0, _extends2.default)({}, props, {
        key: `ItemRange--${entry.from}-${entry.to}`,
        from: entry.from,
        to: entry.to,
        renderChildNodes: renderChildNodes
      })));
    } else {
      const {
        key,
        value
      } = entry;
      const isCircular = circularCache.indexOf(value) !== -1;
      childNodes.push( /*#__PURE__*/_react.default.createElement(_JSONNode.default, (0, _extends2.default)({}, props, {
        postprocessValue,
        collectionLimit,
        key: `Node--${key}`,
        keyPath: [key, ...keyPath],
        value: postprocessValue(value),
        circularCache: [...circularCache, value],
        isCircular: isCircular,
        hideRoot: false
      })));
    }
  });
  return childNodes;
}
function JSONNestedNode(props) {
  const {
    circularCache = [],
    collectionLimit,
    createItemString,
    data,
    expandable,
    getItemString,
    hideRoot,
    isCircular,
    keyPath,
    labelRenderer,
    level = 0,
    nodeType,
    nodeTypeIndicator,
    shouldExpandNodeInitially,
    styling
  } = props;
  const [expanded, setExpanded] = (0, _react.useState)(
  // calculate individual node expansion if necessary
  isCircular ? false : shouldExpandNodeInitially(keyPath, data, level));
  const handleClick = (0, _react.useCallback)(() => {
    if (expandable) setExpanded(!expanded);
  }, [expandable, expanded]);
  const renderedChildren = expanded || hideRoot && level === 0 ? renderChildNodes({
    ...props,
    circularCache,
    level: level + 1
  }) : null;
  const itemType = /*#__PURE__*/_react.default.createElement("span", styling('nestedNodeItemType', expanded), nodeTypeIndicator);
  const renderedItemString = getItemString(nodeType, data, itemType, createItemString(data, collectionLimit), keyPath);
  const stylingArgs = [keyPath, nodeType, expanded, expandable];
  return hideRoot ? /*#__PURE__*/_react.default.createElement("li", styling('rootNode', ...stylingArgs), /*#__PURE__*/_react.default.createElement("ul", styling('rootNodeChildren', ...stylingArgs), renderedChildren)) : /*#__PURE__*/_react.default.createElement("li", styling('nestedNode', ...stylingArgs), expandable && /*#__PURE__*/_react.default.createElement(_JSONArrow.default, {
    styling: styling,
    nodeType: nodeType,
    expanded: expanded,
    onClick: handleClick
  }), /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({}, styling(['label', 'nestedNodeLabel'], ...stylingArgs), {
    onClick: handleClick
  }), labelRenderer(...stylingArgs)), /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({}, styling('nestedNodeItemString', ...stylingArgs), {
    onClick: handleClick
  }), renderedItemString), /*#__PURE__*/_react.default.createElement("ul", styling('nestedNodeChildren', ...stylingArgs), renderedChildren));
}