"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = JSONArrayNode;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _JSONNestedNode = _interopRequireDefault(require("./JSONNestedNode"));
// Returns the "n Items" string for this node,
// generating and caching it if it hasn't been created yet.
function createItemString(data) {
  return `${data.length} ${data.length !== 1 ? 'items' : 'item'}`;
}
// Configures <JSONNestedNode> to render an Array
function JSONArrayNode(_ref) {
  let {
    data,
    ...props
  } = _ref;
  return /*#__PURE__*/_react.default.createElement(_JSONNestedNode.default, (0, _extends2.default)({}, props, {
    data: data,
    nodeType: "Array",
    nodeTypeIndicator: "[]",
    createItemString: createItemString,
    expandable: data.length > 0
  }));
}