// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { RankedMenu } from '@jupyterlab/ui-components';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An extensible View menu for the application.
 */
export class ViewMenu extends RankedMenu {
    /**
     * Construct the view menu.
     */
    constructor(options) {
        super(options);
        this.editorViewers = {
            toggleLineNumbers: new SemanticCommand(),
            toggleMatchBrackets: new SemanticCommand(),
            toggleWordWrap: new SemanticCommand()
        };
    }
}
//# sourceMappingURL=view.js.map