import { IRankedMenu, RankedMenu } from '@jupyterlab/ui-components';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An interface for a View menu.
 */
export interface IViewMenu extends IRankedMenu {
    /**
     * Semantic commands IEditorViewer for the View menu.
     */
    readonly editorViewers: IViewMenu.IEditorViewer;
}
/**
 * An extensible View menu for the application.
 */
export declare class ViewMenu extends RankedMenu implements IViewMenu {
    /**
     * Construct the view menu.
     */
    constructor(options: IRankedMenu.IOptions);
    /**
     * Semantic commands IEditorViewer for the View menu.
     */
    readonly editorViewers: IViewMenu.IEditorViewer;
}
/**
 * Namespace for IViewMenu.
 */
export declare namespace IViewMenu {
    /**
     * Interface for a text editor viewer to register
     * itself with the text editor semantic commands.
     */
    interface IEditorViewer {
        /**
         * A semantic command to show line numbers in the editor.
         */
        toggleLineNumbers: SemanticCommand;
        /**
         * A semantic command to word-wrap the editor.
         */
        toggleWordWrap: SemanticCommand;
        /**
         * A semantic command to match brackets in the editor.
         */
        toggleMatchBrackets: SemanticCommand;
    }
}
