import { TranslationBundle } from '@jupyterlab/translation';
import { RankedMenu } from '@jupyterlab/ui-components';
import { CommandRegistry } from '@lumino/commands';
import { Menu, MenuBar } from '@lumino/widgets';
import { EditMenu } from './edit';
import { FileMenu } from './file';
import { HelpMenu } from './help';
import { KernelMenu } from './kernel';
import { RunMenu } from './run';
import { SettingsMenu } from './settings';
import { TabsMenu } from './tabs';
import { IMainMenu } from './tokens';
import { ViewMenu } from './view';
/**
 * The main menu class.  It is intended to be used as a singleton.
 */
export declare class MainMenu extends MenuBar implements IMainMenu {
    /**
     * Construct the main menu bar.
     */
    constructor(commands: CommandRegistry);
    /**
     * The application "Edit" menu.
     */
    get editMenu(): EditMenu;
    /**
     * The application "File" menu.
     */
    get fileMenu(): FileMenu;
    /**
     * The application "Help" menu.
     */
    get helpMenu(): HelpMenu;
    /**
     * The application "Kernel" menu.
     */
    get kernelMenu(): KernelMenu;
    /**
     * The application "Run" menu.
     */
    get runMenu(): RunMenu;
    /**
     * The application "Settings" menu.
     */
    get settingsMenu(): SettingsMenu;
    /**
     * The application "View" menu.
     */
    get viewMenu(): ViewMenu;
    /**
     * The application "Tabs" menu.
     */
    get tabsMenu(): TabsMenu;
    /**
     * Add a new menu to the main menu bar.
     */
    addMenu(menu: Menu, update?: boolean, options?: IMainMenu.IAddOptions): void;
    /**
     * Dispose of the resources held by the menu bar.
     */
    dispose(): void;
    /**
     * Generate the menu.
     *
     * @param commands The command registry
     * @param options The main menu options.
     * @param trans - The application language translator.
     */
    static generateMenu(commands: CommandRegistry, options: IMainMenu.IMenuOptions, trans: TranslationBundle): RankedMenu;
    /**
     * Handle the disposal of a menu.
     */
    private _onMenuDisposed;
    private _commands;
    private _items;
    private _editMenu;
    private _fileMenu;
    private _helpMenu;
    private _kernelMenu;
    private _runMenu;
    private _settingsMenu;
    private _viewMenu;
    private _tabsMenu;
}
