// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { RankedMenu } from '@jupyterlab/ui-components';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An extensible Kernel menu for the application.
 */
export class KernelMenu extends RankedMenu {
    /**
     * Construct the kernel menu.
     */
    constructor(options) {
        super(options);
        this.kernelUsers = {
            changeKernel: new SemanticCommand(),
            clearWidget: new SemanticCommand(),
            interruptKernel: new SemanticCommand(),
            reconnectToKernel: new SemanticCommand(),
            restartKernel: new SemanticCommand(),
            shutdownKernel: new SemanticCommand()
        };
    }
}
//# sourceMappingURL=kernel.js.map