// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { RankedMenu } from '@jupyterlab/ui-components';
import { find } from '@lumino/algorithm';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An extensible FileMenu for the application.
 */
export class FileMenu extends RankedMenu {
    constructor(options) {
        super(options);
        this.quitEntry = false;
        this.closeAndCleaners = new SemanticCommand();
        this.consoleCreators = new SemanticCommand();
    }
    /**
     * The New submenu.
     */
    get newMenu() {
        var _a, _b;
        if (!this._newMenu) {
            this._newMenu =
                (_b = (_a = find(this.items, menu => { var _a; return ((_a = menu.submenu) === null || _a === void 0 ? void 0 : _a.id) === 'jp-mainmenu-file-new'; })) === null || _a === void 0 ? void 0 : _a.submenu) !== null && _b !== void 0 ? _b : new RankedMenu({
                    commands: this.commands
                });
        }
        return this._newMenu;
    }
    /**
     * Dispose of the resources held by the file menu.
     */
    dispose() {
        var _a;
        (_a = this._newMenu) === null || _a === void 0 ? void 0 : _a.dispose();
        super.dispose();
    }
}
//# sourceMappingURL=file.js.map