import { IRankedMenu, RankedMenu } from '@jupyterlab/ui-components';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An interface for a File menu.
 */
export interface IFileMenu extends IRankedMenu {
    /**
     * Option to add a `Quit` entry in the File menu
     */
    quitEntry: boolean;
    /**
     * A submenu for creating new files/launching new activities.
     */
    readonly newMenu: IRankedMenu;
    /**
     * The close and cleanup semantic command.
     */
    readonly closeAndCleaners: SemanticCommand;
    /**
     * The console creator semantic command.
     */
    readonly consoleCreators: SemanticCommand;
}
/**
 * An extensible FileMenu for the application.
 */
export declare class FileMenu extends RankedMenu implements IFileMenu {
    constructor(options: IRankedMenu.IOptions);
    /**
     * The New submenu.
     */
    get newMenu(): RankedMenu;
    /**
     * The close and cleanup semantic command.
     */
    readonly closeAndCleaners: SemanticCommand;
    /**
     * The console creator semantic command.
     */
    readonly consoleCreators: SemanticCommand;
    /**
     * Dispose of the resources held by the file menu.
     */
    dispose(): void;
    /**
     * Option to add a `Quit` entry in File menu
     */
    quitEntry: boolean;
    private _newMenu;
}
