// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { RankedMenu } from '@jupyterlab/ui-components';
import { SemanticCommand } from '@jupyterlab/apputils';
/**
 * An extensible Edit menu for the application.
 */
export class EditMenu extends RankedMenu {
    /**
     * Construct the edit menu.
     */
    constructor(options) {
        super(options);
        this.undoers = {
            redo: new SemanticCommand(),
            undo: new SemanticCommand()
        };
        this.clearers = {
            clearAll: new SemanticCommand(),
            clearCurrent: new SemanticCommand()
        };
        this.goToLiners = new SemanticCommand();
    }
}
//# sourceMappingURL=edit.js.map