import { JupyterFrontEnd } from '@jupyterlab/application';
import { ICommandPalette, ISessionContextDialogs, MainAreaWidget, WidgetTracker } from '@jupyterlab/apputils';
import { CodeViewerWidget, IEditorServices } from '@jupyterlab/codeeditor';
import { IEditorExtensionRegistry, IEditorLanguageRegistry } from '@jupyterlab/codemirror';
import { ICompletionProviderManager } from '@jupyterlab/completer';
import { IConsoleTracker } from '@jupyterlab/console';
import { IDocumentWidget } from '@jupyterlab/docregistry';
import { IDefaultFileBrowser } from '@jupyterlab/filebrowser';
import { FileEditor, IEditorTracker } from '@jupyterlab/fileeditor';
import { ILauncher } from '@jupyterlab/launcher';
import { IMainMenu } from '@jupyterlab/mainmenu';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { ITranslator, TranslationBundle } from '@jupyterlab/translation';
import { CommandRegistry } from '@lumino/commands';
import { ReadonlyJSONObject } from '@lumino/coreutils';
/**
 * The command IDs used by the fileeditor plugin.
 */
export declare namespace CommandIDs {
    const createNew = "fileeditor:create-new";
    const createNewMarkdown = "fileeditor:create-new-markdown-file";
    const changeFontSize = "fileeditor:change-font-size";
    const lineNumbers = "fileeditor:toggle-line-numbers";
    const currentLineNumbers = "fileeditor:toggle-current-line-numbers";
    const lineWrap = "fileeditor:toggle-line-wrap";
    const currentLineWrap = "fileeditor:toggle-current-line-wrap";
    const changeTabs = "fileeditor:change-tabs";
    const matchBrackets = "fileeditor:toggle-match-brackets";
    const currentMatchBrackets = "fileeditor:toggle-current-match-brackets";
    const autoClosingBrackets = "fileeditor:toggle-autoclosing-brackets";
    const autoClosingBracketsUniversal = "fileeditor:toggle-autoclosing-brackets-universal";
    const createConsole = "fileeditor:create-console";
    const replaceSelection = "fileeditor:replace-selection";
    const restartConsole = "fileeditor:restart-console";
    const runCode = "fileeditor:run-code";
    const runAllCode = "fileeditor:run-all";
    const markdownPreview = "fileeditor:markdown-preview";
    const undo = "fileeditor:undo";
    const redo = "fileeditor:redo";
    const cut = "fileeditor:cut";
    const copy = "fileeditor:copy";
    const paste = "fileeditor:paste";
    const selectAll = "fileeditor:select-all";
    const invokeCompleter = "completer:invoke-file";
    const selectCompleter = "completer:select-file";
    const openCodeViewer = "code-viewer:open";
    const changeTheme = "fileeditor:change-theme";
    const changeLanguage = "fileeditor:change-language";
    const find = "fileeditor:find";
    const goToLine = "fileeditor:go-to-line";
}
export interface IFileTypeData extends ReadonlyJSONObject {
    fileExt: string;
    iconName: string;
    launcherLabel: string;
    paletteLabel: string;
    caption: string;
}
/**
 * The name of the factory that creates editor widgets.
 */
export declare const FACTORY = "Editor";
/**
 * A utility class for adding commands and menu items,
 * for use by the File Editor extension or other Editor extensions.
 */
export declare namespace Commands {
    /**
     * Update the setting values.
     */
    function updateSettings(settings: ISettingRegistry.ISettings, commands: CommandRegistry): void;
    /**
     * Update the settings of the current tracker instances.
     */
    function updateTracker(tracker: WidgetTracker<IDocumentWidget<FileEditor>>): void;
    /**
     * Update the settings of a widget.
     * Skip global settings for transient editor specific configs.
     */
    function updateWidget(widget: FileEditor): void;
    /**
     * Wrapper function for adding the default File Editor commands
     */
    function addCommands(commands: CommandRegistry, settingRegistry: ISettingRegistry, trans: TranslationBundle, id: string, isEnabled: () => boolean, tracker: WidgetTracker<IDocumentWidget<FileEditor>>, defaultBrowser: IDefaultFileBrowser, extensions: IEditorExtensionRegistry, languages: IEditorLanguageRegistry, consoleTracker: IConsoleTracker | null, sessionDialogs: ISessionContextDialogs): void;
    function addCompleterCommands(commands: CommandRegistry, editorTracker: IEditorTracker, manager: ICompletionProviderManager, translator: ITranslator | null): void;
    /**
     * Wrapper function for adding the default launcher items for File Editor
     */
    function addLauncherItems(launcher: ILauncher, trans: TranslationBundle): void;
    /**
     * Add Create New Text File to the Launcher
     */
    function addCreateNewToLauncher(launcher: ILauncher, trans: TranslationBundle): void;
    /**
     * Add Create New Markdown to the Launcher
     */
    function addCreateNewMarkdownToLauncher(launcher: ILauncher, trans: TranslationBundle): void;
    /**
     * Add ___ File items to the Launcher for common file types associated with available kernels
     */
    function addKernelLanguageLauncherItems(launcher: ILauncher, trans: TranslationBundle, availableKernelFileTypes: Iterable<IFileTypeData>): void;
    /**
     * Wrapper function for adding the default items to the File Editor palette
     */
    function addPaletteItems(palette: ICommandPalette, trans: TranslationBundle): void;
    /**
     * Add commands to change the tab indentation to the File Editor palette
     */
    function addChangeTabsCommandsToPalette(palette: ICommandPalette, trans: TranslationBundle): void;
    /**
     * Add a Create New File command to the File Editor palette
     */
    function addCreateNewCommandToPalette(palette: ICommandPalette, trans: TranslationBundle): void;
    /**
     * Add a Create New Markdown command to the File Editor palette
     */
    function addCreateNewMarkdownCommandToPalette(palette: ICommandPalette, trans: TranslationBundle): void;
    /**
     * Add commands to change the font size to the File Editor palette
     */
    function addChangeFontSizeCommandsToPalette(palette: ICommandPalette, trans: TranslationBundle): void;
    /**
     * Add New ___ File commands to the File Editor palette for common file types associated with available kernels
     */
    function addKernelLanguagePaletteItems(palette: ICommandPalette, trans: TranslationBundle, availableKernelFileTypes: Iterable<IFileTypeData>): void;
    /**
     * Wrapper function for adding the default menu items for File Editor
     */
    function addMenuItems(menu: IMainMenu, tracker: WidgetTracker<IDocumentWidget<FileEditor>>, consoleTracker: IConsoleTracker | null, isEnabled: () => boolean): void;
    /**
     * Add Create New ___ File commands to the File menu for common file types associated with available kernels
     */
    function addKernelLanguageMenuItems(menu: IMainMenu, availableKernelFileTypes: Iterable<IFileTypeData>): void;
    /**
     * Add a File Editor code runner to the Run menu
     */
    function addCodeRunnersToRunMenu(menu: IMainMenu, consoleTracker: IConsoleTracker): void;
    function addOpenCodeViewerCommand(app: JupyterFrontEnd, editorServices: IEditorServices, tracker: WidgetTracker<MainAreaWidget<CodeViewerWidget>>, trans: TranslationBundle): void;
}
