"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FORMAT_DATE = exports.CUSTOM_PAD_LENGTH = void 0;
exports.formatLoggingDate = formatLoggingDate;
exports.isObject = isObject;
exports.padLeft = padLeft;
exports.padRight = padRight;
var _dayjs = _interopRequireDefault(require("dayjs"));
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const FORMAT_DATE = 'YYYY-MM-DD HH:mm:ss';
exports.FORMAT_DATE = FORMAT_DATE;
const CUSTOM_PAD_LENGTH = 1;
exports.CUSTOM_PAD_LENGTH = CUSTOM_PAD_LENGTH;
function isObject(obj) {
  return _lodash.default.isObject(obj) && _lodash.default.isNull(obj) === false && _lodash.default.isArray(obj) === false;
}
function padLeft(message) {
  return message.padStart(message.length + CUSTOM_PAD_LENGTH, ' ');
}
function padRight(message, max = message.length + CUSTOM_PAD_LENGTH) {
  return message.padEnd(max, ' ');
}
function formatLoggingDate(time, message) {
  const timeFormatted = (0, _dayjs.default)(time).format(FORMAT_DATE);
  return `[${timeFormatted}]${message}`;
}
//# sourceMappingURL=utils.js.map