/**
 * @packageDocumentation
 * @module lsp-extension
 */
import { JupyterFrontEndPlugin } from '@jupyterlab/application';
import { ILSPCodeExtractorsManager, ILSPConnection, ILSPDocumentConnectionManager, ILSPFeatureManager } from '@jupyterlab/lsp';
import { IRunningSessions } from '@jupyterlab/running';
import { LabIcon } from '@jupyterlab/ui-components';
export declare class RunningLanguageServer implements IRunningSessions.IRunningItem {
    constructor(connection: ILSPConnection, manager: ILSPDocumentConnectionManager);
    /**
     * This is no-op because we do not do anything on server click event
     */
    open(): void;
    icon(): LabIcon;
    label(): string;
    shutdown(): void;
    private _connection;
    private _manager;
    private _serverIdentifier;
    private _serverLanguage;
}
/**
 * Export the plugin as default.
 */
declare const _default: (JupyterFrontEndPlugin<ILSPDocumentConnectionManager> | JupyterFrontEndPlugin<ILSPFeatureManager> | JupyterFrontEndPlugin<ILSPCodeExtractorsManager>)[];
export default _default;
