// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module celltags-extension
 */
import { INotebookTracker } from '@jupyterlab/notebook';
import { CellTagField } from './celltag';
import { IFormRendererRegistry } from '@jupyterlab/ui-components';
/**
 * Registering cell tag field.
 */
const customCellTag = {
    id: '@jupyterlab/celltags-extension:plugin',
    autoStart: true,
    requires: [INotebookTracker],
    optional: [IFormRendererRegistry],
    activate: (app, tracker, formRegistry) => {
        // Register the custom field
        if (formRegistry) {
            const component = {
                fieldRenderer: (props) => {
                    return new CellTagField(tracker).render(props);
                }
            };
            formRegistry.addRenderer('celltags-extension:plugin.renderer', component);
        }
    }
};
export default [customCellTag];
//# sourceMappingURL=index.js.map