import { SemanticNode } from '../semantic_tree/semantic_node';
export declare function nodeCounter(nodes: Node[], context: string | null): () => string;
export declare function isSimpleExpression(node: SemanticNode): boolean;
export declare function isSimpleFunction_(node: SemanticNode): boolean;
export declare function isSimpleNegative_(node: SemanticNode): boolean;
export declare function isSimpleDegree_(node: SemanticNode): boolean;
export declare function isSimpleLetters_(node: SemanticNode): boolean;
export declare function isSimple_(node: SemanticNode): boolean;
export declare function isLetter_(node: SemanticNode): boolean;
export declare function isNumber_(node: SemanticNode): boolean;
export declare function isSimpleNumber_(node: SemanticNode): boolean;
export declare function isSimpleFraction_(node: SemanticNode): boolean;
export declare function hasPreference(pref: string): boolean;
export declare function simpleNode(node: Element): boolean;
export declare function simpleCell_(node: Element): boolean;
export declare function isInteger_(node: Element): boolean;
export declare function allIndices_(node: Element): boolean;
export declare function allCellsSimple(node: Element): Element[];
export declare function isSmallVulgarFraction(node: Element): Element[];
export declare function isUnitExpression(node: SemanticNode): boolean;
export declare function allTextLastContent_(nodes: SemanticNode[]): boolean;
export declare function ordinalExponent(node: Element): string;
export declare let NESTING_DEPTH: string | null;
export declare function nestingDepth(node: Element): string | null;
export declare function matchingFences(node: Element): Element[];
export declare function insertNesting(text: string, correction: string): string;
export declare function fencedArguments(node: Element): Element[];
export declare function simpleArguments(node: Element): Element[];
export declare function simpleFactor_(node: Element): boolean;
export declare function fencedFactor_(node: Element): boolean;
export declare function layoutFactor_(node: Element): boolean;
export declare function wordOrdinal(node: Element): string;
