export interface SemanticMeaning {
    type: SemanticType;
    role: SemanticRole;
    font: SemanticFont;
}
export declare const enum SemanticType {
    PUNCTUATION = "punctuation",
    FENCE = "fence",
    NUMBER = "number",
    IDENTIFIER = "identifier",
    TEXT = "text",
    OPERATOR = "operator",
    RELATION = "relation",
    LARGEOP = "largeop",
    FUNCTION = "function",
    ACCENT = "accent",
    FENCED = "fenced",
    FRACTION = "fraction",
    PUNCTUATED = "punctuated",
    RELSEQ = "relseq",
    MULTIREL = "multirel",
    INFIXOP = "infixop",
    PREFIXOP = "prefixop",
    POSTFIXOP = "postfixop",
    APPL = "appl",
    INTEGRAL = "integral",
    BIGOP = "bigop",
    SQRT = "sqrt",
    ROOT = "root",
    LIMUPPER = "limupper",
    LIMLOWER = "limlower",
    LIMBOTH = "limboth",
    SUBSCRIPT = "subscript",
    SUPERSCRIPT = "superscript",
    UNDERSCORE = "underscore",
    OVERSCORE = "overscore",
    TENSOR = "tensor",
    TABLE = "table",
    MULTILINE = "multiline",
    MATRIX = "matrix",
    VECTOR = "vector",
    CASES = "cases",
    ROW = "row",
    LINE = "line",
    CELL = "cell",
    ENCLOSE = "enclose",
    INFERENCE = "inference",
    RULELABEL = "rulelabel",
    CONCLUSION = "conclusion",
    PREMISES = "premises",
    UNKNOWN = "unknown",
    EMPTY = "empty"
}
export declare const enum SemanticRole {
    COMMA = "comma",
    ELLIPSIS = "ellipsis",
    FULLSTOP = "fullstop",
    DASH = "dash",
    TILDE = "tilde",
    PRIME = "prime",
    DEGREE = "degree",
    VBAR = "vbar",
    COLON = "colon",
    OPENFENCE = "openfence",
    CLOSEFENCE = "closefence",
    APPLICATION = "application",
    DUMMY = "dummy",
    UNIT = "unit",
    LABEL = "label",
    OPEN = "open",
    CLOSE = "close",
    TOP = "top",
    BOTTOM = "bottom",
    NEUTRAL = "neutral",
    METRIC = "metric",
    LATINLETTER = "latinletter",
    GREEKLETTER = "greekletter",
    OTHERLETTER = "otherletter",
    NUMBERSET = "numbersetletter",
    INTEGER = "integer",
    FLOAT = "float",
    OTHERNUMBER = "othernumber",
    MIXED = "mixed",
    MULTIACCENT = "multiaccent",
    OVERACCENT = "overaccent",
    UNDERACCENT = "underaccent",
    UNDEROVER = "underover",
    SUBSUP = "subsup",
    LEFTSUB = "leftsub",
    LEFTSUPER = "leftsuper",
    RIGHTSUB = "rightsub",
    RIGHTSUPER = "rightsuper",
    LEFTRIGHT = "leftright",
    ABOVEBELOW = "abovebelow",
    SETEMPTY = "set empty",
    SETEXT = "set extended",
    SETSINGLE = "set singleton",
    SETCOLLECT = "set collection",
    STRING = "string",
    SPACE = "space",
    SEQUENCE = "sequence",
    ENDPUNCT = "endpunct",
    STARTPUNCT = "startpunct",
    TEXT = "text",
    NEGATIVE = "negative",
    POSITIVE = "positive",
    NEGATION = "negation",
    MULTIOP = "multiop",
    PREFIXOP = "prefix operator",
    POSTFIXOP = "postfix operator",
    LIMFUNC = "limit function",
    INFIXFUNC = "infix function",
    PREFIXFUNC = "prefix function",
    POSTFIXFUNC = "postfix function",
    SIMPLEFUNC = "simple function",
    COMPFUNC = "composed function",
    SUM = "sum",
    INTEGRAL = "integral",
    GEOMETRY = "geometry",
    ADDITION = "addition",
    MULTIPLICATION = "multiplication",
    SUBTRACTION = "subtraction",
    IMPLICIT = "implicit",
    DIVISION = "division",
    VULGAR = "vulgar",
    EQUALITY = "equality",
    INEQUALITY = "inequality",
    ARROW = "arrow",
    ELEMENT = "element",
    NONELEMENT = "nonelement",
    REELEMENT = "reelement",
    RENONELEMENT = "renonelement",
    SET = "set",
    DETERMINANT = "determinant",
    ROWVECTOR = "rowvector",
    BINOMIAL = "binomial",
    SQUAREMATRIX = "squarematrix",
    CYCLE = "cycle",
    MULTILINE = "multiline",
    MATRIX = "matrix",
    VECTOR = "vector",
    CASES = "cases",
    TABLE = "table",
    CAYLEY = "cayley",
    PROOF = "proof",
    LEFT = "left",
    RIGHT = "right",
    UP = "up",
    DOWN = "down",
    FINAL = "final",
    SINGLE = "single",
    HYP = "hyp",
    AXIOM = "axiom",
    UNKNOWN = "unknown",
    MGLYPH = "mglyph"
}
export declare const enum SemanticFont {
    BOLD = "bold",
    BOLDFRAKTUR = "bold-fraktur",
    BOLDITALIC = "bold-italic",
    BOLDSCRIPT = "bold-script",
    CALIGRAPHIC = "caligraphic",
    CALIGRAPHICBOLD = "caligraphic-bold",
    DOUBLESTRUCK = "double-struck",
    DOUBLESTRUCKITALIC = "double-struck-italic",
    FRAKTUR = "fraktur",
    ITALIC = "italic",
    MONOSPACE = "monospace",
    NORMAL = "normal",
    OLDSTYLE = "oldstyle",
    OLDSTYLEBOLD = "oldstyle-bold",
    SCRIPT = "script",
    SANSSERIF = "sans-serif",
    SANSSERIFITALIC = "sans-serif-italic",
    SANSSERIFBOLD = "sans-serif-bold",
    SANSSERIFBOLDITALIC = "sans-serif-bold-italic",
    UNKNOWN = "unknown"
}
