"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lookupSecondary = exports.isEmbellishedType = exports.isMatchingFence = exports.functionApplication = exports.invisibleComma = exports.invisiblePlus = exports.invisibleTimes = exports.lookupMeaning = exports.lookupRole = exports.lookupType = exports.equal = exports.allLettersRegExp = void 0;
const generalPunctuations = [
    '!',
    '"',
    '#',
    '%',
    '&',
    ';',
    '?',
    '@',
    '\\',
    '¡',
    '§',
    '¶',
    '¿',
    '‗',
    '†',
    '‡',
    '•',
    '‣',
    '․',
    '‥',
    '‧',
    '‰',
    '‱',
    '‸',
    '※',
    '‼',
    '‽',
    '‾',
    '⁁',
    '⁂',
    '⁃',
    '⁇',
    '⁈',
    '⁉',
    '⁋',
    '⁌',
    '⁍',
    '⁎',
    '⁏',
    '⁐',
    '⁑',
    '⁓',
    '⁕',
    '⁖',
    '⁘',
    '⁙',
    '⁚',
    '⁛',
    '⁜',
    '⁝',
    '⁞',
    '︐',
    '︔',
    '︕',
    '︖',
    '︰',
    '﹅',
    '﹆',
    '﹉',
    '﹊',
    '﹋',
    '﹌',
    '﹔',
    '﹖',
    '﹗',
    '﹟',
    '﹠',
    '﹡',
    '﹨',
    '﹪',
    '﹫',
    '！',
    '＂',
    '＃',
    '％',
    '＆',
    '＇',
    '＊',
    '／',
    '；',
    '？',
    '＠',
    '＼'
];
const colons = ['︓', ':', '：', '﹕'];
const invisibleComma_ = String.fromCodePoint(0x2063);
const commas = ['，', '﹐', ',', invisibleComma_];
const ellipses = ['…', '⋮', '⋯', '⋰', '⋱', '︙'];
const fullStops = ['.', '﹒', '．'];
const dashes = [
    '¯',
    '‒',
    '–',
    '—',
    '―',
    '﹘',
    '-',
    '⁻',
    '₋',
    '−',
    '➖',
    '﹣',
    '－',
    '‐',
    '‑',
    '‾',
    '_'
];
const tildes = ['~', '̃', '∼', '˜', '∽', '˷', '̴', '̰'];
const primes = ["'", '′', '″', '‴', '‵', '‶', '‷', '⁗', 'ʹ', 'ʺ'];
const degrees = ['°'];
const openClosePairs = {
    '(': ')',
    '[': ']',
    '{': '}',
    '\u2045': '⁆',
    '\u2329': '〉',
    '\u2768': '❩',
    '\u276a': '❫',
    '\u276c': '❭',
    '\u276e': '❯',
    '\u2770': '❱',
    '\u2772': '❳',
    '\u2774': '❵',
    '\u27c5': '⟆',
    '\u27e6': '⟧',
    '\u27e8': '⟩',
    '\u27ea': '⟫',
    '\u27ec': '⟭',
    '\u27ee': '⟯',
    '\u2983': '⦄',
    '\u2985': '⦆',
    '\u2987': '⦈',
    '\u2989': '⦊',
    '\u298b': '⦌',
    '\u298d': '⦎',
    '\u298f': '⦐',
    '\u2991': '⦒',
    '\u2993': '⦔',
    '\u2995': '⦖',
    '\u2997': '⦘',
    '\u29d8': '⧙',
    '\u29da': '⧛',
    '\u29fc': '⧽',
    '\u2e22': '⸣',
    '\u2e24': '⸥',
    '\u2e26': '⸧',
    '\u2e28': '⸩',
    '\u3008': '〉',
    '\u300a': '》',
    '\u300c': '」',
    '\u300e': '』',
    '\u3010': '】',
    '\u3014': '〕',
    '\u3016': '〗',
    '\u3018': '〙',
    '\u301a': '〛',
    '\u301d': '〞',
    '\ufd3e': '﴿',
    '\ufe17': '︘',
    '\ufe59': '﹚',
    '\ufe5b': '﹜',
    '\ufe5d': '﹞',
    '\uff08': '）',
    '\uff3b': '］',
    '\uff5b': '｝',
    '\uff5f': '｠',
    '\uff62': '｣',
    '\u2308': '⌉',
    '\u230a': '⌋',
    '\u230c': '⌍',
    '\u230e': '⌏',
    '\u231c': '⌝',
    '\u231e': '⌟',
    '\u239b': '⎞',
    '\u239c': '⎟',
    '\u239d': '⎠',
    '\u23a1': '⎤',
    '\u23a2': '⎥',
    '\u23a3': '⎦',
    '\u23a7': '⎫',
    '\u23a8': '⎬',
    '\u23a9': '⎭',
    '\u23b0': '⎱',
    '\u23b8': '⎹'
};
const topBottomPairs = {
    '\u23b4': '⎵',
    '\u23dc': '⏝',
    '\u23de': '⏟',
    '\u23e0': '⏡',
    '\ufe35': '︶',
    '\ufe37': '︸',
    '\ufe39': '︺',
    '\ufe3b': '︼',
    '\ufe3d': '︾',
    '\ufe3f': '﹀',
    '\ufe41': '﹂',
    '\ufe43': '﹄',
    '\ufe47': '﹈'
};
const leftFences = Object.keys(openClosePairs);
const rightFences = Object.values(openClosePairs);
rightFences.push('〟');
const topFences = Object.keys(topBottomPairs);
const bottomFences = Object.values(topBottomPairs);
const neutralFences = [
    '|',
    '¦',
    '∣',
    '⏐',
    '⎸',
    '⎹',
    '❘',
    '｜',
    '￤',
    '︱',
    '︲'
];
const metricFences = ['‖', '∥', '⦀', '⫴'];
const capitalLatin = [
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z'
];
const smallLatin = [
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    'ı',
    'ȷ'
];
const capitalLatinFullWidth = [
    'Ａ',
    'Ｂ',
    'Ｃ',
    'Ｄ',
    'Ｅ',
    'Ｆ',
    'Ｇ',
    'Ｈ',
    'Ｉ',
    'Ｊ',
    'Ｋ',
    'Ｌ',
    'Ｍ',
    'Ｎ',
    'Ｏ',
    'Ｐ',
    'Ｑ',
    'Ｒ',
    'Ｓ',
    'Ｔ',
    'Ｕ',
    'Ｖ',
    'Ｗ',
    'Ｘ',
    'Ｙ',
    'Ｚ'
];
const smallLatinFullWidth = [
    'ａ',
    'ｂ',
    'ｃ',
    'ｄ',
    'ｅ',
    'ｆ',
    'ｇ',
    'ｈ',
    'ｉ',
    'ｊ',
    'ｋ',
    'ｌ',
    'ｍ',
    'ｎ',
    'ｏ',
    'ｐ',
    'ｑ',
    'ｒ',
    'ｓ',
    'ｔ',
    'ｕ',
    'ｖ',
    'ｗ',
    'ｘ',
    'ｙ',
    'ｚ'
];
const capitalLatinBold = [
    '𝐀',
    '𝐁',
    '𝐂',
    '𝐃',
    '𝐄',
    '𝐅',
    '𝐆',
    '𝐇',
    '𝐈',
    '𝐉',
    '𝐊',
    '𝐋',
    '𝐌',
    '𝐍',
    '𝐎',
    '𝐏',
    '𝐐',
    '𝐑',
    '𝐒',
    '𝐓',
    '𝐔',
    '𝐕',
    '𝐖',
    '𝐗',
    '𝐘',
    '𝐙'
];
const smallLatinBold = [
    '𝐚',
    '𝐛',
    '𝐜',
    '𝐝',
    '𝐞',
    '𝐟',
    '𝐠',
    '𝐡',
    '𝐢',
    '𝐣',
    '𝐤',
    '𝐥',
    '𝐦',
    '𝐧',
    '𝐨',
    '𝐩',
    '𝐪',
    '𝐫',
    '𝐬',
    '𝐭',
    '𝐮',
    '𝐯',
    '𝐰',
    '𝐱',
    '𝐲',
    '𝐳'
];
const capitalLatinItalic = [
    '𝐴',
    '𝐵',
    '𝐶',
    '𝐷',
    '𝐸',
    '𝐹',
    '𝐺',
    '𝐻',
    '𝐼',
    '𝐽',
    '𝐾',
    '𝐿',
    '𝑀',
    '𝑁',
    '𝑂',
    '𝑃',
    '𝑄',
    '𝑅',
    '𝑆',
    '𝑇',
    '𝑈',
    '𝑉',
    '𝑊',
    '𝑋',
    '𝑌',
    '𝑍'
];
const smallLatinItalic = [
    '𝑎',
    '𝑏',
    '𝑐',
    '𝑑',
    '𝑒',
    '𝑓',
    '𝑔',
    'ℎ',
    '𝑖',
    '𝑗',
    '𝑘',
    '𝑙',
    '𝑚',
    '𝑛',
    '𝑜',
    '𝑝',
    '𝑞',
    '𝑟',
    '𝑠',
    '𝑡',
    '𝑢',
    '𝑣',
    '𝑤',
    '𝑥',
    '𝑦',
    '𝑧',
    '𝚤',
    '𝚥'
];
const capitalLatinBoldItalic = [
    '𝑨',
    '𝑩',
    '𝑪',
    '𝑫',
    '𝑬',
    '𝑭',
    '𝑮',
    '𝑯',
    '𝑰',
    '𝑱',
    '𝑲',
    '𝑳',
    '𝑴',
    '𝑵',
    '𝑶',
    '𝑷',
    '𝑸',
    '𝑹',
    '𝑺',
    '𝑻',
    '𝑼',
    '𝑽',
    '𝑾',
    '𝑿',
    '𝒀',
    '𝒁'
];
const smallLatinBoldItalic = [
    '𝒂',
    '𝒃',
    '𝒄',
    '𝒅',
    '𝒆',
    '𝒇',
    '𝒈',
    '𝒉',
    '𝒊',
    '𝒋',
    '𝒌',
    '𝒍',
    '𝒎',
    '𝒏',
    '𝒐',
    '𝒑',
    '𝒒',
    '𝒓',
    '𝒔',
    '𝒕',
    '𝒖',
    '𝒗',
    '𝒘',
    '𝒙',
    '𝒚',
    '𝒛'
];
const capitalLatinScript = [
    '𝒜',
    'ℬ',
    '𝒞',
    '𝒟',
    'ℰ',
    'ℱ',
    '𝒢',
    'ℋ',
    'ℐ',
    '𝒥',
    '𝒦',
    'ℒ',
    'ℳ',
    '𝒩',
    '𝒪',
    '𝒫',
    '𝒬',
    'ℛ',
    '𝒮',
    '𝒯',
    '𝒰',
    '𝒱',
    '𝒲',
    '𝒳',
    '𝒴',
    '𝒵',
    '℘'
];
const smallLatinScript = [
    '𝒶',
    '𝒷',
    '𝒸',
    '𝒹',
    'ℯ',
    '𝒻',
    'ℊ',
    '𝒽',
    '𝒾',
    '𝒿',
    '𝓀',
    '𝓁',
    '𝓂',
    '𝓃',
    'ℴ',
    '𝓅',
    '𝓆',
    '𝓇',
    '𝓈',
    '𝓉',
    '𝓊',
    '𝓋',
    '𝓌',
    '𝓍',
    '𝓎',
    '𝓏',
    'ℓ'
];
const capitalLatinBoldScript = [
    '𝓐',
    '𝓑',
    '𝓒',
    '𝓓',
    '𝓔',
    '𝓕',
    '𝓖',
    '𝓗',
    '𝓘',
    '𝓙',
    '𝓚',
    '𝓛',
    '𝓜',
    '𝓝',
    '𝓞',
    '𝓟',
    '𝓠',
    '𝓡',
    '𝓢',
    '𝓣',
    '𝓤',
    '𝓥',
    '𝓦',
    '𝓧',
    '𝓨',
    '𝓩'
];
const smallLatinBoldScript = [
    '𝓪',
    '𝓫',
    '𝓬',
    '𝓭',
    '𝓮',
    '𝓯',
    '𝓰',
    '𝓱',
    '𝓲',
    '𝓳',
    '𝓴',
    '𝓵',
    '𝓶',
    '𝓷',
    '𝓸',
    '𝓹',
    '𝓺',
    '𝓻',
    '𝓼',
    '𝓽',
    '𝓾',
    '𝓿',
    '𝔀',
    '𝔁',
    '𝔂',
    '𝔃'
];
const capitalLatinFraktur = [
    '𝔄',
    '𝔅',
    'ℭ',
    '𝔇',
    '𝔈',
    '𝔉',
    '𝔊',
    'ℌ',
    'ℑ',
    '𝔍',
    '𝔎',
    '𝔏',
    '𝔐',
    '𝔑',
    '𝔒',
    '𝔓',
    '𝔔',
    'ℜ',
    '𝔖',
    '𝔗',
    '𝔘',
    '𝔙',
    '𝔚',
    '𝔛',
    '𝔜',
    'ℨ'
];
const smallLatinFraktur = [
    '𝔞',
    '𝔟',
    '𝔠',
    '𝔡',
    '𝔢',
    '𝔣',
    '𝔤',
    '𝔥',
    '𝔦',
    '𝔧',
    '𝔨',
    '𝔩',
    '𝔪',
    '𝔫',
    '𝔬',
    '𝔭',
    '𝔮',
    '𝔯',
    '𝔰',
    '𝔱',
    '𝔲',
    '𝔳',
    '𝔴',
    '𝔵',
    '𝔶',
    '𝔷'
];
const capitalLatinDoubleStruck = [
    '𝔸',
    '𝔹',
    'ℂ',
    '𝔻',
    '𝔼',
    '𝔽',
    '𝔾',
    'ℍ',
    '𝕀',
    '𝕁',
    '𝕂',
    '𝕃',
    '𝕄',
    'ℕ',
    '𝕆',
    'ℙ',
    'ℚ',
    'ℝ',
    '𝕊',
    '𝕋',
    '𝕌',
    '𝕍',
    '𝕎',
    '𝕏',
    '𝕐',
    'ℤ'
];
const smallLatinDoubleStruck = [
    '𝕒',
    '𝕓',
    '𝕔',
    '𝕕',
    '𝕖',
    '𝕗',
    '𝕘',
    '𝕙',
    '𝕚',
    '𝕛',
    '𝕜',
    '𝕝',
    '𝕞',
    '𝕟',
    '𝕠',
    '𝕡',
    '𝕢',
    '𝕣',
    '𝕤',
    '𝕥',
    '𝕦',
    '𝕧',
    '𝕨',
    '𝕩',
    '𝕪',
    '𝕫'
];
const capitalLatinBoldFraktur = [
    '𝕬',
    '𝕭',
    '𝕮',
    '𝕯',
    '𝕰',
    '𝕱',
    '𝕲',
    '𝕳',
    '𝕴',
    '𝕵',
    '𝕶',
    '𝕷',
    '𝕸',
    '𝕹',
    '𝕺',
    '𝕻',
    '𝕼',
    '𝕽',
    '𝕾',
    '𝕿',
    '𝖀',
    '𝖁',
    '𝖂',
    '𝖃',
    '𝖄',
    '𝖅'
];
const smallLatinBoldFraktur = [
    '𝖆',
    '𝖇',
    '𝖈',
    '𝖉',
    '𝖊',
    '𝖋',
    '𝖌',
    '𝖍',
    '𝖎',
    '𝖏',
    '𝖐',
    '𝖑',
    '𝖒',
    '𝖓',
    '𝖔',
    '𝖕',
    '𝖖',
    '𝖗',
    '𝖘',
    '𝖙',
    '𝖚',
    '𝖛',
    '𝖜',
    '𝖝',
    '𝖞',
    '𝖟'
];
const capitalLatinSansSerif = [
    '𝖠',
    '𝖡',
    '𝖢',
    '𝖣',
    '𝖤',
    '𝖥',
    '𝖦',
    '𝖧',
    '𝖨',
    '𝖩',
    '𝖪',
    '𝖫',
    '𝖬',
    '𝖭',
    '𝖮',
    '𝖯',
    '𝖰',
    '𝖱',
    '𝖲',
    '𝖳',
    '𝖴',
    '𝖵',
    '𝖶',
    '𝖷',
    '𝖸',
    '𝖹'
];
const smallLatinSansSerif = [
    '𝖺',
    '𝖻',
    '𝖼',
    '𝖽',
    '𝖾',
    '𝖿',
    '𝗀',
    '𝗁',
    '𝗂',
    '𝗃',
    '𝗄',
    '𝗅',
    '𝗆',
    '𝗇',
    '𝗈',
    '𝗉',
    '𝗊',
    '𝗋',
    '𝗌',
    '𝗍',
    '𝗎',
    '𝗏',
    '𝗐',
    '𝗑',
    '𝗒',
    '𝗓'
];
const capitalLatinSansSerifBold = [
    '𝗔',
    '𝗕',
    '𝗖',
    '𝗗',
    '𝗘',
    '𝗙',
    '𝗚',
    '𝗛',
    '𝗜',
    '𝗝',
    '𝗞',
    '𝗟',
    '𝗠',
    '𝗡',
    '𝗢',
    '𝗣',
    '𝗤',
    '𝗥',
    '𝗦',
    '𝗧',
    '𝗨',
    '𝗩',
    '𝗪',
    '𝗫',
    '𝗬',
    '𝗭'
];
const smallLatinSansSerifBold = [
    '𝗮',
    '𝗯',
    '𝗰',
    '𝗱',
    '𝗲',
    '𝗳',
    '𝗴',
    '𝗵',
    '𝗶',
    '𝗷',
    '𝗸',
    '𝗹',
    '𝗺',
    '𝗻',
    '𝗼',
    '𝗽',
    '𝗾',
    '𝗿',
    '𝘀',
    '𝘁',
    '𝘂',
    '𝘃',
    '𝘄',
    '𝘅',
    '𝘆',
    '𝘇'
];
const capitalLatinSansSerifItalic = [
    '𝘈',
    '𝘉',
    '𝘊',
    '𝘋',
    '𝘌',
    '𝘍',
    '𝘎',
    '𝘏',
    '𝘐',
    '𝘑',
    '𝘒',
    '𝘓',
    '𝘔',
    '𝘕',
    '𝘖',
    '𝘗',
    '𝘘',
    '𝘙',
    '𝘚',
    '𝘛',
    '𝘜',
    '𝘝',
    '𝘞',
    '𝘟',
    '𝘠',
    '𝘡'
];
const smallLatinSansSerifItalic = [
    '𝘢',
    '𝘣',
    '𝘤',
    '𝘥',
    '𝘦',
    '𝘧',
    '𝘨',
    '𝘩',
    '𝘪',
    '𝘫',
    '𝘬',
    '𝘭',
    '𝘮',
    '𝘯',
    '𝘰',
    '𝘱',
    '𝘲',
    '𝘳',
    '𝘴',
    '𝘵',
    '𝘶',
    '𝘷',
    '𝘸',
    '𝘹',
    '𝘺',
    '𝘻'
];
const capitalLatinSansSerifBoldItalic = [
    '𝘼',
    '𝘽',
    '𝘾',
    '𝘿',
    '𝙀',
    '𝙁',
    '𝙂',
    '𝙃',
    '𝙄',
    '𝙅',
    '𝙆',
    '𝙇',
    '𝙈',
    '𝙉',
    '𝙊',
    '𝙋',
    '𝙌',
    '𝙍',
    '𝙎',
    '𝙏',
    '𝙐',
    '𝙑',
    '𝙒',
    '𝙓',
    '𝙔',
    '𝙕'
];
const smallLatinSansSerifBoldItalic = [
    '𝙖',
    '𝙗',
    '𝙘',
    '𝙙',
    '𝙚',
    '𝙛',
    '𝙜',
    '𝙝',
    '𝙞',
    '𝙟',
    '𝙠',
    '𝙡',
    '𝙢',
    '𝙣',
    '𝙤',
    '𝙥',
    '𝙦',
    '𝙧',
    '𝙨',
    '𝙩',
    '𝙪',
    '𝙫',
    '𝙬',
    '𝙭',
    '𝙮',
    '𝙯'
];
const capitalLatinMonospace = [
    '𝙰',
    '𝙱',
    '𝙲',
    '𝙳',
    '𝙴',
    '𝙵',
    '𝙶',
    '𝙷',
    '𝙸',
    '𝙹',
    '𝙺',
    '𝙻',
    '𝙼',
    '𝙽',
    '𝙾',
    '𝙿',
    '𝚀',
    '𝚁',
    '𝚂',
    '𝚃',
    '𝚄',
    '𝚅',
    '𝚆',
    '𝚇',
    '𝚈',
    '𝚉'
];
const smallLatinMonospace = [
    '𝚊',
    '𝚋',
    '𝚌',
    '𝚍',
    '𝚎',
    '𝚏',
    '𝚐',
    '𝚑',
    '𝚒',
    '𝚓',
    '𝚔',
    '𝚕',
    '𝚖',
    '𝚗',
    '𝚘',
    '𝚙',
    '𝚚',
    '𝚛',
    '𝚜',
    '𝚝',
    '𝚞',
    '𝚟',
    '𝚠',
    '𝚡',
    '𝚢',
    '𝚣'
];
const latinDoubleStruckItalic = ['ⅅ', 'ⅆ', 'ⅇ', 'ⅈ', 'ⅉ'];
const capitalGreek = [
    'Α',
    'Β',
    'Γ',
    'Δ',
    'Ε',
    'Ζ',
    'Η',
    'Θ',
    'Ι',
    'Κ',
    'Λ',
    'Μ',
    'Ν',
    'Ξ',
    'Ο',
    'Π',
    'Ρ',
    'Σ',
    'Τ',
    'Υ',
    'Φ',
    'Χ',
    'Ψ',
    'Ω'
];
const smallGreek = [
    'α',
    'β',
    'γ',
    'δ',
    'ε',
    'ζ',
    'η',
    'θ',
    'ι',
    'κ',
    'λ',
    'μ',
    'ν',
    'ξ',
    'ο',
    'π',
    'ρ',
    'ς',
    'σ',
    'τ',
    'υ',
    'φ',
    'χ',
    'ψ',
    'ω'
];
const capitalGreekBold = [
    '𝚨',
    '𝚩',
    '𝚪',
    '𝚫',
    '𝚬',
    '𝚭',
    '𝚮',
    '𝚯',
    '𝚰',
    '𝚱',
    '𝚲',
    '𝚳',
    '𝚴',
    '𝚵',
    '𝚶',
    '𝚷',
    '𝚸',
    '𝚺',
    '𝚻',
    '𝚼',
    '𝚽',
    '𝚾',
    '𝚿',
    '𝛀'
];
const smallGreekBold = [
    '𝛂',
    '𝛃',
    '𝛄',
    '𝛅',
    '𝛆',
    '𝛇',
    '𝛈',
    '𝛉',
    '𝛊',
    '𝛋',
    '𝛌',
    '𝛍',
    '𝛎',
    '𝛏',
    '𝛐',
    '𝛑',
    '𝛒',
    '𝛓',
    '𝛔',
    '𝛕',
    '𝛖',
    '𝛗',
    '𝛘',
    '𝛙',
    '𝛚'
];
const capitalGreekItalic = [
    '𝛢',
    '𝛣',
    '𝛤',
    '𝛥',
    '𝛦',
    '𝛧',
    '𝛨',
    '𝛩',
    '𝛪',
    '𝛫',
    '𝛬',
    '𝛭',
    '𝛮',
    '𝛯',
    '𝛰',
    '𝛱',
    '𝛲',
    '𝛴',
    '𝛵',
    '𝛶',
    '𝛷',
    '𝛸',
    '𝛹',
    '𝛺'
];
const smallGreekItalic = [
    '𝛼',
    '𝛽',
    '𝛾',
    '𝛿',
    '𝜀',
    '𝜁',
    '𝜂',
    '𝜃',
    '𝜄',
    '𝜅',
    '𝜆',
    '𝜇',
    '𝜈',
    '𝜉',
    '𝜊',
    '𝜋',
    '𝜌',
    '𝜍',
    '𝜎',
    '𝜏',
    '𝜐',
    '𝜑',
    '𝜒',
    '𝜓',
    '𝜔'
];
const capitalGreekBoldItalic = [
    '𝜜',
    '𝜝',
    '𝜞',
    '𝜟',
    '𝜠',
    '𝜡',
    '𝜢',
    '𝜣',
    '𝜤',
    '𝜥',
    '𝜦',
    '𝜧',
    '𝜨',
    '𝜩',
    '𝜪',
    '𝜫',
    '𝜬',
    '𝜮',
    '𝜯',
    '𝜰',
    '𝜱',
    '𝜲',
    '𝜳',
    '𝜴'
];
const smallGreekBoldItalic = [
    '𝜶',
    '𝜷',
    '𝜸',
    '𝜹',
    '𝜺',
    '𝜻',
    '𝜼',
    '𝜽',
    '𝜾',
    '𝜿',
    '𝝀',
    '𝝁',
    '𝝂',
    '𝝃',
    '𝝄',
    '𝝅',
    '𝝆',
    '𝝇',
    '𝝈',
    '𝝉',
    '𝝊',
    '𝝋',
    '𝝌',
    '𝝍',
    '𝝎'
];
const capitalGreekSansSerifBold = [
    '𝝖',
    '𝝗',
    '𝝘',
    '𝝙',
    '𝝚',
    '𝝛',
    '𝝜',
    '𝝝',
    '𝝞',
    '𝝟',
    '𝝠',
    '𝝡',
    '𝝢',
    '𝝣',
    '𝝤',
    '𝝥',
    '𝝦',
    '𝝨',
    '𝝩',
    '𝝪',
    '𝝫',
    '𝝬',
    '𝝭',
    '𝝮'
];
const smallGreekSansSerifBold = [
    '𝝰',
    '𝝱',
    '𝝲',
    '𝝳',
    '𝝴',
    '𝝵',
    '𝝶',
    '𝝷',
    '𝝸',
    '𝝹',
    '𝝺',
    '𝝻',
    '𝝼',
    '𝝽',
    '𝝾',
    '𝝿',
    '𝞀',
    '𝞁',
    '𝞂',
    '𝞃',
    '𝞄',
    '𝞅',
    '𝞆',
    '𝞇',
    '𝞈'
];
const capitalGreekSansSerifBoldItalic = [
    '𝞐',
    '𝞑',
    '𝞒',
    '𝞓',
    '𝞔',
    '𝞕',
    '𝞖',
    '𝞗',
    '𝞘',
    '𝞙',
    '𝞚',
    '𝞛',
    '𝞜',
    '𝞝',
    '𝞞',
    '𝞟',
    '𝞠',
    '𝞢',
    '𝞣',
    '𝞤',
    '𝞥',
    '𝞦',
    '𝞧',
    '𝞨'
];
const smallGreekSansSerifBoldItalic = [
    '𝞪',
    '𝞫',
    '𝞬',
    '𝞭',
    '𝞮',
    '𝞯',
    '𝞰',
    '𝞱',
    '𝞲',
    '𝞳',
    '𝞴',
    '𝞵',
    '𝞶',
    '𝞷',
    '𝞸',
    '𝞹',
    '𝞺',
    '𝞻',
    '𝞼',
    '𝞽',
    '𝞾',
    '𝞿',
    '𝟀',
    '𝟁',
    '𝟂'
];
const greekDoubleStruck = ['ℼ', 'ℽ', 'ℾ', 'ℿ'];
const greekSpecial = [
    'ϐ',
    'ϑ',
    'ϕ',
    'ϖ',
    'ϗ',
    'ϰ',
    'ϱ',
    'ϵ',
    '϶',
    'ϴ'
];
const greekSpecialBold = ['𝛜', '𝛝', '𝛞', '𝛟', '𝛠', '𝛡'];
const greekSpecialItalic = ['𝜖', '𝜗', '𝜘', '𝜙', '𝜚', '𝜛'];
const greekSpecialSansSerifBold = ['𝞊', '𝞋', '𝞌', '𝞍', '𝞎', '𝞏'];
const hebrewLetters = ['ℵ', 'ℶ', 'ℷ', 'ℸ'];
const allLetters = capitalLatin.concat(smallLatin, capitalLatinFullWidth, smallLatinFullWidth, capitalLatinBold, smallLatinBold, capitalLatinItalic, capitalLatinBoldItalic, smallLatinBoldItalic, smallLatinItalic, capitalLatinScript, smallLatinScript, capitalLatinBoldScript, smallLatinBoldScript, capitalLatinFraktur, smallLatinFraktur, capitalLatinDoubleStruck, smallLatinDoubleStruck, capitalLatinBoldFraktur, smallLatinBoldFraktur, capitalLatinSansSerif, smallLatinSansSerif, capitalLatinSansSerifBold, smallLatinSansSerifBold, capitalLatinSansSerifItalic, smallLatinSansSerifItalic, capitalLatinSansSerifBoldItalic, smallLatinSansSerifBoldItalic, capitalLatinMonospace, smallLatinMonospace, latinDoubleStruckItalic, capitalGreek, smallGreek, capitalGreekBold, smallGreekBold, capitalGreekItalic, smallGreekItalic, capitalGreekBoldItalic, smallGreekBoldItalic, capitalGreekSansSerifBold, smallGreekSansSerifBold, greekDoubleStruck, greekSpecial, capitalGreekSansSerifBoldItalic, smallGreekSansSerifBoldItalic, greekSpecialBold, greekSpecialItalic, greekSpecialSansSerifBold, hebrewLetters);
exports.allLettersRegExp = new RegExp(allLetters.join('|'));
const additions = [
    '+',
    '±',
    '∓',
    '∔',
    '∧',
    '∨',
    '∩',
    '∪',
    '⊌',
    '⊍',
    '⊎',
    '⊓',
    '⊔',
    '⊝',
    '⊞',
    '⊤',
    '⊥',
    '⊺',
    '⊻',
    '⊼',
    '⋄',
    '⋎',
    '⋏',
    '⋒',
    '⋓',
    '⩞',
    '⊕',
    '⋔'
];
const invisiblePlus_ = String.fromCodePoint(0x2064);
additions.push(invisiblePlus_);
const multiplications = [
    '†',
    '‡',
    '∐',
    '∗',
    '∘',
    '∙',
    '≀',
    '⊚',
    '⊛',
    '⊠',
    '⊡',
    '⋅',
    '⋆',
    '⋇',
    '⋈',
    '⋉',
    '⋊',
    '⋋',
    '⋌',
    '○',
    '·',
    '*',
    '⊗',
    '⊙'
];
const invisibleTimes_ = String.fromCodePoint(0x2062);
multiplications.push(invisibleTimes_);
const subtractions = [
    '¯',
    '-',
    '⁒',
    '⁻',
    '₋',
    '−',
    '∖',
    '∸',
    '≂',
    '⊖',
    '⊟',
    '➖',
    '⨩',
    '⨪',
    '⨫',
    '⨬',
    '⨺',
    '⩁',
    '﹣',
    '－',
    '‐',
    '‑'
];
const divisions = ['/', '÷', '⁄', '∕', '⊘', '⟌', '⦼', '⨸'];
const functionApplication_ = String.fromCodePoint(0x2061);
const equalities = [
    '=',
    '~',
    '⁼',
    '₌',
    '∼',
    '∽',
    '≃',
    '≅',
    '≈',
    '≊',
    '≋',
    '≌',
    '≍',
    '≎',
    '≑',
    '≒',
    '≓',
    '≔',
    '≕',
    '≖',
    '≗',
    '≘',
    '≙',
    '≚',
    '≛',
    '≜',
    '≝',
    '≞',
    '≟',
    '≡',
    '≣',
    '⧤',
    '⩦',
    '⩮',
    '⩯',
    '⩰',
    '⩱',
    '⩲',
    '⩳',
    '⩴',
    '⩵',
    '⩶',
    '⩷',
    '⩸',
    '⋕',
    '⩭',
    '⩪',
    '⩫',
    '⩬',
    '﹦',
    '＝',
    '⩬',
    '⊜',
    '∷'
];
const inequalities = [
    '<',
    '>',
    '≁',
    '≂',
    '≄',
    '≆',
    '≇',
    '≉',
    '≏',
    '≐',
    '≠',
    '≢',
    '≤',
    '≥',
    '≦',
    '≧',
    '≨',
    '≩',
    '≪',
    '≫',
    '≬',
    '≭',
    '≮',
    '≯',
    '≰',
    '≱',
    '≲',
    '≳',
    '≴',
    '≵',
    '≶',
    '≷',
    '≸',
    '≹',
    '≺',
    '≻',
    '≼',
    '≽',
    '≾',
    '≿',
    '⊀',
    '⊁',
    '⋖',
    '⋗',
    '⋘',
    '⋙',
    '⋚',
    '⋛',
    '⋜',
    '⋝',
    '⋞',
    '⋟',
    '⋠',
    '⋡',
    '⋦',
    '⋧',
    '⋨',
    '⋩',
    '⩹',
    '⩺',
    '⩻',
    '⩼',
    '⩽',
    '⩾',
    '⩿',
    '⪀',
    '⪁',
    '⪂',
    '⪃',
    '⪄',
    '⪅',
    '⪆',
    '⪇',
    '⪈',
    '⪉',
    '⪊',
    '⪋',
    '⪌',
    '⪍',
    '⪎',
    '⪏',
    '⪐',
    '⪑',
    '⪒',
    '⪓',
    '⪔',
    '⪕',
    '⪖',
    '⪗',
    '⪘',
    '⪙',
    '⪚',
    '⪛',
    '⪜',
    '⪝',
    '⪞',
    '⪟',
    '⪠',
    '⪡',
    '⪢',
    '⪣',
    '⪤',
    '⪥',
    '⪦',
    '⪧',
    '⪨',
    '⪩',
    '⪪',
    '⪫',
    '⪬',
    '⪭',
    '⪮',
    '⪯',
    '⪰',
    '⪱',
    '⪲',
    '⪳',
    '⪴',
    '⪵',
    '⪶',
    '⪷',
    '⪸',
    '⪹',
    '⪺',
    '⪻',
    '⪼',
    '⫷',
    '⫸',
    '⫹',
    '⫺',
    '⧀',
    '⧁',
    '﹤',
    '﹥',
    '＜',
    '＞'
];
const setRelations = [
    '⋢',
    '⋣',
    '⋤',
    '⋥',
    '⊂',
    '⊃',
    '⊄',
    '⊅',
    '⊆',
    '⊇',
    '⊈',
    '⊉',
    '⊊',
    '⊋',
    '⊏',
    '⊐',
    '⊑',
    '⊒',
    '⪽',
    '⪾',
    '⪿',
    '⫀',
    '⫁',
    '⫂',
    '⫃',
    '⫄',
    '⫅',
    '⫆',
    '⫇',
    '⫈',
    '⫉',
    '⫊',
    '⫋',
    '⫌',
    '⫍',
    '⫎',
    '⫏',
    '⫐',
    '⫑',
    '⫒',
    '⫓',
    '⫔',
    '⫕',
    '⫖',
    '⫗',
    '⫘',
    '⋐',
    '⋑',
    '⋪',
    '⋫',
    '⋬',
    '⋭',
    '⊲',
    '⊳',
    '⊴',
    '⊵'
];
const elementRelations = [
    '∈',
    '∊',
    '⋲',
    '⋳',
    '⋴',
    '⋵',
    '⋶',
    '⋷',
    '⋸',
    '⋹',
    '⋿'
];
const nonelementRelations = ['∉'];
const reelementRelations = ['∋', '∍', '⋺', '⋻', '⋼', '⋽', '⋾'];
const renonelementRelations = ['∌'];
const relations = [
    '⊢',
    '⊣',
    '⊦',
    '⊧',
    '⊨',
    '⊩',
    '⊪',
    '⊫',
    '⊬',
    '⊭',
    '⊮',
    '⊯',
    '⫞',
    '⫟',
    '⫠',
    '⫡',
    '⫢',
    '⫣',
    '⫤',
    '⫥',
    '⫦',
    '⫧',
    '⫨',
    '⫩',
    '⫪',
    '⫫',
    '⫬',
    '⫭'
];
const arrows = [
    '←',
    '↑',
    '→',
    '↓',
    '↔',
    '↕',
    '↖',
    '↗',
    '↘',
    '↙',
    '↚',
    '↛',
    '↜',
    '↝',
    '↞',
    '↟',
    '↠',
    '↡',
    '↢',
    '↣',
    '↤',
    '↥',
    '↦',
    '↧',
    '↨',
    '↩',
    '↪',
    '↫',
    '↬',
    '↭',
    '↮',
    '↯',
    '↰',
    '↱',
    '↲',
    '↳',
    '↴',
    '↵',
    '↶',
    '↷',
    '↸',
    '↹',
    '↺',
    '↻',
    '⇄',
    '⇅',
    '⇆',
    '⇇',
    '⇈',
    '⇉',
    '⇊',
    '⇍',
    '⇎',
    '⇏',
    '⇐',
    '⇑',
    '⇒',
    '⇓',
    '⇔',
    '⇕',
    '⇖',
    '⇗',
    '⇘',
    '⇙',
    '⇚',
    '⇛',
    '⇜',
    '⇝',
    '⇞',
    '⇟',
    '⇠',
    '⇡',
    '⇢',
    '⇣',
    '⇤',
    '⇥',
    '⇦',
    '⇧',
    '⇨',
    '⇩',
    '⇪',
    '⇫',
    '⇬',
    '⇭',
    '⇮',
    '⇯',
    '⇰',
    '⇱',
    '⇲',
    '⇳',
    '⇴',
    '⇵',
    '⇶',
    '⇷',
    '⇸',
    '⇹',
    '⇺',
    '⇻',
    '⇼',
    '⇽',
    '⇾',
    '⇿',
    '⌁',
    '⌃',
    '⌄',
    '⌤',
    '⎋',
    '➔',
    '➘',
    '➙',
    '➚',
    '➛',
    '➜',
    '➝',
    '➞',
    '➟',
    '➠',
    '➡',
    '➢',
    '➣',
    '➤',
    '➥',
    '➦',
    '➧',
    '➨',
    '➩',
    '➪',
    '➫',
    '➬',
    '➭',
    '➮',
    '➯',
    '➱',
    '➲',
    '➳',
    '➴',
    '➵',
    '➶',
    '➷',
    '➸',
    '➹',
    '➺',
    '➻',
    '➼',
    '➽',
    '➾',
    '⟰',
    '⟱',
    '⟲',
    '⟳',
    '⟴',
    '⟵',
    '⟶',
    '⟷',
    '⟸',
    '⟹',
    '⟺',
    '⟻',
    '⟼',
    '⟽',
    '⟾',
    '⟿',
    '⤀',
    '⤁',
    '⤂',
    '⤃',
    '⤄',
    '⤅',
    '⤆',
    '⤇',
    '⤈',
    '⤉',
    '⤊',
    '⤋',
    '⤌',
    '⤍',
    '⤎',
    '⤏',
    '⤐',
    '⤑',
    '⤒',
    '⤓',
    '⤔',
    '⤕',
    '⤖',
    '⤗',
    '⤘',
    '⤙',
    '⤚',
    '⤛',
    '⤜',
    '⤝',
    '⤞',
    '⤟',
    '⤠',
    '⤡',
    '⤢',
    '⤣',
    '⤤',
    '⤥',
    '⤦',
    '⤧',
    '⤨',
    '⤩',
    '⤪',
    '⤭',
    '⤮',
    '⤯',
    '⤰',
    '⤱',
    '⤲',
    '⤳',
    '⤴',
    '⤵',
    '⤶',
    '⤷',
    '⤸',
    '⤹',
    '⤺',
    '⤻',
    '⤼',
    '⤽',
    '⤾',
    '⤿',
    '⥀',
    '⥁',
    '⥂',
    '⥃',
    '⥄',
    '⥅',
    '⥆',
    '⥇',
    '⥈',
    '⥉',
    '⥰',
    '⥱',
    '⥲',
    '⥳',
    '⥴',
    '⥵',
    '⥶',
    '⥷',
    '⥸',
    '⥹',
    '⥺',
    '⥻',
    '⦳',
    '⦴',
    '⦽',
    '⧪',
    '⧬',
    '⧭',
    '⨗',
    '⬀',
    '⬁',
    '⬂',
    '⬃',
    '⬄',
    '⬅',
    '⬆',
    '⬇',
    '⬈',
    '⬉',
    '⬊',
    '⬋',
    '⬌',
    '⬍',
    '⬎',
    '⬏',
    '⬐',
    '⬑',
    '⬰',
    '⬱',
    '⬲',
    '⬳',
    '⬴',
    '⬵',
    '⬶',
    '⬷',
    '⬸',
    '⬹',
    '⬺',
    '⬻',
    '⬼',
    '⬽',
    '⬾',
    '⬿',
    '⭀',
    '⭁',
    '⭂',
    '⭃',
    '⭄',
    '⭅',
    '⭆',
    '⭇',
    '⭈',
    '⭉',
    '⭊',
    '⭋',
    '⭌',
    '￩',
    '￪',
    '￫',
    '￬',
    '↼',
    '↽',
    '↾',
    '↿',
    '⇀',
    '⇁',
    '⇂',
    '⇃',
    '⇋',
    '⇌',
    '⥊',
    '⥋',
    '⥌',
    '⥍',
    '⥎',
    '⥏',
    '⥐',
    '⥑',
    '⥒',
    '⥓',
    '⥔',
    '⥕',
    '⥖',
    '⥗',
    '⥘',
    '⥙',
    '⥚',
    '⥛',
    '⥜',
    '⥝',
    '⥞',
    '⥟',
    '⥠',
    '⥡',
    '⥢',
    '⥣',
    '⥤',
    '⥥',
    '⥦',
    '⥧',
    '⥨',
    '⥩',
    '⥪',
    '⥫',
    '⥬',
    '⥭',
    '⥮',
    '⥯',
    '⥼',
    '⥽',
    '⥾',
    '⥿'
];
const sumOps = [
    '⅀',
    '∏',
    '∐',
    '∑',
    '⋀',
    '⋁',
    '⋂',
    '⋃',
    '⨀',
    '⨁',
    '⨂',
    '⨃',
    '⨄',
    '⨅',
    '⨆',
    '⨇',
    '⨈',
    '⨉',
    '⨊',
    '⨋',
    '⫼',
    '⫿'
];
const intOps = [
    '∫',
    '∬',
    '∭',
    '∮',
    '∯',
    '∰',
    '∱',
    '∲',
    '∳',
    '⨌',
    '⨍',
    '⨎',
    '⨏',
    '⨐',
    '⨑',
    '⨒',
    '⨓',
    '⨔',
    '⨕',
    '⨖',
    '⨗',
    '⨘',
    '⨙',
    '⨚',
    '⨛',
    '⨜'
];
const geometryOps = [
    '∟',
    '∠',
    '∡',
    '∢',
    '⊾',
    '⊿',
    '△',
    '▷',
    '▽',
    '◁'
];
const prefixOps = ['∀', '∃', '∆', '∇', '∂', '∁', '∄'];
const prefixOpsBold = ['𝛁', '𝛛', '𝟊', '𝟋'];
const prefixOpsItalic = ['𝛻', '𝜕'];
const prefixOpsSansSerifBold = ['𝝯', '𝞉'];
const digitsNormal = [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9'
];
const digitsFullWidth = [
    '０',
    '１',
    '２',
    '３',
    '４',
    '５',
    '６',
    '７',
    '８',
    '９'
];
const digitsBold = ['𝟎', '𝟏', '𝟐', '𝟑', '𝟒', '𝟓', '𝟔', '𝟕', '𝟖', '𝟗'];
const digitsDoubleStruck = [
    '𝟘',
    '𝟙',
    '𝟚',
    '𝟛',
    '𝟜',
    '𝟝',
    '𝟞',
    '𝟟',
    '𝟠',
    '𝟡'
];
const digitsSansSerif = [
    '𝟢',
    '𝟣',
    '𝟤',
    '𝟥',
    '𝟦',
    '𝟧',
    '𝟨',
    '𝟩',
    '𝟪',
    '𝟫'
];
const digitsSansSerifBold = [
    '𝟬',
    '𝟭',
    '𝟮',
    '𝟯',
    '𝟰',
    '𝟱',
    '𝟲',
    '𝟳',
    '𝟴',
    '𝟵'
];
const digitsMonospace = [
    '𝟶',
    '𝟷',
    '𝟸',
    '𝟹',
    '𝟺',
    '𝟻',
    '𝟼',
    '𝟽',
    '𝟾',
    '𝟿'
];
const digitsSuperscript = [
    '²',
    '³',
    '¹',
    '⁰',
    '⁴',
    '⁵',
    '⁶',
    '⁷',
    '⁸',
    '⁹'
];
const digitsSubscript = [
    '₀',
    '₁',
    '₂',
    '₃',
    '₄',
    '₅',
    '₆',
    '₇',
    '₈',
    '₉'
];
const fractions = [
    '¼',
    '½',
    '¾',
    '⅐',
    '⅑',
    '⅒',
    '⅓',
    '⅔',
    '⅕',
    '⅖',
    '⅗',
    '⅘',
    '⅙',
    '⅚',
    '⅛',
    '⅜',
    '⅝',
    '⅞',
    '⅟',
    '↉'
];
const enclosedNumbers = [
    '①',
    '②',
    '③',
    '④',
    '⑤',
    '⑥',
    '⑦',
    '⑧',
    '⑨',
    '⑩',
    '⑪',
    '⑫',
    '⑬',
    '⑭',
    '⑮',
    '⑯',
    '⑰',
    '⑱',
    '⑲',
    '⑳',
    '⓪',
    '⓫',
    '⓬',
    '⓭',
    '⓮',
    '⓯',
    '⓰',
    '⓱',
    '⓲',
    '⓳',
    '⓴',
    '⓵',
    '⓶',
    '⓷',
    '⓸',
    '⓹',
    '⓺',
    '⓻',
    '⓼',
    '⓽',
    '⓾',
    '⓿',
    '❶',
    '❷',
    '❸',
    '❹',
    '❺',
    '❻',
    '❼',
    '❽',
    '❾',
    '❿',
    '➀',
    '➁',
    '➂',
    '➃',
    '➄',
    '➅',
    '➆',
    '➇',
    '➈',
    '➉',
    '➊',
    '➋',
    '➌',
    '➍',
    '➎',
    '➏',
    '➐',
    '➑',
    '➒',
    '➓',
    '㉈',
    '㉉',
    '㉊',
    '㉋',
    '㉌',
    '㉍',
    '㉎',
    '㉏',
    '㉑',
    '㉒',
    '㉓',
    '㉔',
    '㉕',
    '㉖',
    '㉗',
    '㉘',
    '㉙',
    '㉚',
    '㉛',
    '㉜',
    '㉝',
    '㉞',
    '㉟',
    '㊱',
    '㊲',
    '㊳',
    '㊴',
    '㊵',
    '㊶',
    '㊷',
    '㊸',
    '㊹',
    '㊺',
    '㊻',
    '㊼',
    '㊽',
    '㊾',
    '㊿'
];
const fencedNumbers = [
    '⑴',
    '⑵',
    '⑶',
    '⑷',
    '⑸',
    '⑹',
    '⑺',
    '⑻',
    '⑼',
    '⑽',
    '⑾',
    '⑿',
    '⒀',
    '⒁',
    '⒂',
    '⒃',
    '⒄',
    '⒅',
    '⒆',
    '⒇'
];
const punctuatedNumbers = [
    '⒈',
    '⒉',
    '⒊',
    '⒋',
    '⒌',
    '⒍',
    '⒎',
    '⒏',
    '⒐',
    '⒑',
    '⒒',
    '⒓',
    '⒔',
    '⒕',
    '⒖',
    '⒗',
    '⒘',
    '⒙',
    '⒚',
    '⒛',
    '🄀',
    '🄁',
    '🄂',
    '🄃',
    '🄄',
    '🄅',
    '🄆',
    '🄇',
    '🄈',
    '🄉',
    '🄊'
];
const numbers = fractions;
const otherNumbers = digitsSuperscript.concat(digitsSubscript, enclosedNumbers, fencedNumbers, punctuatedNumbers);
const trigonometricFunctions = [
    'cos',
    'cot',
    'csc',
    'sec',
    'sin',
    'tan',
    'arccos',
    'arccot',
    'arccsc',
    'arcsec',
    'arcsin',
    'arctan',
    'arc cos',
    'arc cot',
    'arc csc',
    'arc sec',
    'arc sin',
    'arc tan'
];
const hyperbolicFunctions = [
    'cosh',
    'coth',
    'csch',
    'sech',
    'sinh',
    'tanh',
    'arcosh',
    'arcoth',
    'arcsch',
    'arsech',
    'arsinh',
    'artanh',
    'arccosh',
    'arccoth',
    'arccsch',
    'arcsech',
    'arcsinh',
    'arctanh'
];
const algebraicFunctions = [
    'deg',
    'det',
    'dim',
    'hom',
    'ker',
    'Tr',
    'tr'
];
const elementaryFunctions = [
    'log',
    'ln',
    'lg',
    'exp',
    'expt',
    'gcd',
    'gcd',
    'arg',
    'im',
    're',
    'Pr'
];
const prefixFunctions = trigonometricFunctions.concat(hyperbolicFunctions, algebraicFunctions, elementaryFunctions);
const limitFunctions = [
    'inf',
    'lim',
    'liminf',
    'limsup',
    'max',
    'min',
    'sup',
    'injlim',
    'projlim',
    'inj lim',
    'proj lim'
];
const infixFunctions = ['mod', 'rem'];
const symbolSetToSemantic_ = [
    {
        set: generalPunctuations,
        type: "punctuation",
        role: "unknown"
    },
    {
        set: colons,
        type: "punctuation",
        role: "colon"
    },
    {
        set: commas,
        type: "punctuation",
        role: "comma"
    },
    {
        set: ellipses,
        type: "punctuation",
        role: "ellipsis"
    },
    {
        set: fullStops,
        type: "punctuation",
        role: "fullstop"
    },
    {
        set: dashes,
        type: "operator",
        role: "dash"
    },
    {
        set: tildes,
        type: "operator",
        role: "tilde"
    },
    {
        set: primes,
        type: "punctuation",
        role: "prime"
    },
    {
        set: degrees,
        type: "punctuation",
        role: "degree"
    },
    {
        set: leftFences,
        type: "fence",
        role: "open"
    },
    {
        set: rightFences,
        type: "fence",
        role: "close"
    },
    {
        set: topFences,
        type: "fence",
        role: "top"
    },
    {
        set: bottomFences,
        type: "fence",
        role: "bottom"
    },
    {
        set: neutralFences,
        type: "fence",
        role: "neutral"
    },
    {
        set: metricFences,
        type: "fence",
        role: "metric"
    },
    {
        set: smallLatin,
        type: "identifier",
        role: "latinletter",
        font: "normal"
    },
    {
        set: capitalLatin,
        type: "identifier",
        role: "latinletter",
        font: "normal"
    },
    {
        set: smallLatinFullWidth,
        type: "identifier",
        role: "latinletter",
        font: "normal"
    },
    {
        set: capitalLatinFullWidth,
        type: "identifier",
        role: "latinletter",
        font: "normal"
    },
    {
        set: smallLatinBold,
        type: "identifier",
        role: "latinletter",
        font: "bold"
    },
    {
        set: capitalLatinBold,
        type: "identifier",
        role: "latinletter",
        font: "bold"
    },
    {
        set: smallLatinItalic,
        type: "identifier",
        role: "latinletter",
        font: "italic"
    },
    {
        set: capitalLatinItalic,
        type: "identifier",
        role: "latinletter",
        font: "italic"
    },
    {
        set: smallLatinBoldItalic,
        type: "identifier",
        role: "latinletter",
        font: "bold-italic"
    },
    {
        set: capitalLatinBoldItalic,
        type: "identifier",
        role: "latinletter",
        font: "bold-italic"
    },
    {
        set: smallLatinScript,
        type: "identifier",
        role: "latinletter",
        font: "script"
    },
    {
        set: capitalLatinScript,
        type: "identifier",
        role: "latinletter",
        font: "script"
    },
    {
        set: smallLatinBoldScript,
        type: "identifier",
        role: "latinletter",
        font: "bold-script"
    },
    {
        set: capitalLatinBoldScript,
        type: "identifier",
        role: "latinletter",
        font: "bold-script"
    },
    {
        set: smallLatinFraktur,
        type: "identifier",
        role: "latinletter",
        font: "fraktur"
    },
    {
        set: capitalLatinFraktur,
        type: "identifier",
        role: "latinletter",
        font: "fraktur"
    },
    {
        set: smallLatinDoubleStruck,
        type: "identifier",
        role: "latinletter",
        font: "double-struck"
    },
    {
        set: capitalLatinDoubleStruck,
        type: "identifier",
        role: "latinletter",
        font: "double-struck"
    },
    {
        set: smallLatinBoldFraktur,
        type: "identifier",
        role: "latinletter",
        font: "bold-fraktur"
    },
    {
        set: capitalLatinBoldFraktur,
        type: "identifier",
        role: "latinletter",
        font: "bold-fraktur"
    },
    {
        set: smallLatinSansSerif,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif"
    },
    {
        set: capitalLatinSansSerif,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif"
    },
    {
        set: smallLatinSansSerifBold,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-bold"
    },
    {
        set: capitalLatinSansSerifBold,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-bold"
    },
    {
        set: smallLatinSansSerifItalic,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-italic"
    },
    {
        set: capitalLatinSansSerifItalic,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-italic"
    },
    {
        set: smallLatinSansSerifBoldItalic,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-bold-italic"
    },
    {
        set: capitalLatinSansSerifBoldItalic,
        type: "identifier",
        role: "latinletter",
        font: "sans-serif-bold-italic"
    },
    {
        set: smallLatinMonospace,
        type: "identifier",
        role: "latinletter",
        font: "monospace"
    },
    {
        set: capitalLatinMonospace,
        type: "identifier",
        role: "latinletter",
        font: "monospace"
    },
    {
        set: latinDoubleStruckItalic,
        type: "identifier",
        role: "latinletter",
        font: "double-struck-italic"
    },
    {
        set: smallGreek,
        type: "identifier",
        role: "greekletter",
        font: "normal"
    },
    {
        set: capitalGreek,
        type: "identifier",
        role: "greekletter",
        font: "normal"
    },
    {
        set: smallGreekBold,
        type: "identifier",
        role: "greekletter",
        font: "bold"
    },
    {
        set: capitalGreekBold,
        type: "identifier",
        role: "greekletter",
        font: "bold"
    },
    {
        set: smallGreekItalic,
        type: "identifier",
        role: "greekletter",
        font: "italic"
    },
    {
        set: capitalGreekItalic,
        type: "identifier",
        role: "greekletter",
        font: "italic"
    },
    {
        set: smallGreekBoldItalic,
        type: "identifier",
        role: "greekletter",
        font: "bold-italic"
    },
    {
        set: capitalGreekBoldItalic,
        type: "identifier",
        role: "greekletter",
        font: "bold-italic"
    },
    {
        set: smallGreekSansSerifBold,
        type: "identifier",
        role: "greekletter",
        font: "sans-serif-bold"
    },
    {
        set: capitalGreekSansSerifBold,
        type: "identifier",
        role: "greekletter",
        font: "sans-serif-bold"
    },
    {
        set: capitalGreekSansSerifBoldItalic,
        type: "identifier",
        role: "greekletter",
        font: "sans-serif-bold-italic"
    },
    {
        set: smallGreekSansSerifBoldItalic,
        type: "identifier",
        role: "greekletter",
        font: "sans-serif-bold-italic"
    },
    {
        set: greekDoubleStruck,
        type: "identifier",
        role: "greekletter",
        font: "double-struck"
    },
    {
        set: greekSpecial,
        type: "identifier",
        role: "greekletter",
        font: "normal"
    },
    {
        set: greekSpecialBold,
        type: "identifier",
        role: "greekletter",
        font: "bold"
    },
    {
        set: greekSpecialItalic,
        type: "identifier",
        role: "greekletter",
        font: "italic"
    },
    {
        set: greekSpecialSansSerifBold,
        type: "identifier",
        role: "greekletter",
        font: "sans-serif-bold"
    },
    {
        set: hebrewLetters,
        type: "identifier",
        role: "otherletter",
        font: "normal"
    },
    {
        set: digitsNormal,
        type: "number",
        role: "integer",
        font: "normal"
    },
    {
        set: digitsFullWidth,
        type: "number",
        role: "integer",
        font: "normal"
    },
    {
        set: digitsBold,
        type: "number",
        role: "integer",
        font: "bold"
    },
    {
        set: digitsDoubleStruck,
        type: "number",
        role: "integer",
        font: "double-struck"
    },
    {
        set: digitsSansSerif,
        type: "number",
        role: "integer",
        font: "sans-serif"
    },
    {
        set: digitsSansSerifBold,
        type: "number",
        role: "integer",
        font: "sans-serif-bold"
    },
    {
        set: digitsMonospace,
        type: "number",
        role: "integer",
        font: "monospace"
    },
    {
        set: numbers,
        type: "number",
        role: "float"
    },
    {
        set: otherNumbers,
        type: "number",
        role: "othernumber"
    },
    {
        set: additions,
        type: "operator",
        role: "addition"
    },
    {
        set: multiplications,
        type: "operator",
        role: "multiplication"
    },
    {
        set: subtractions,
        type: "operator",
        role: "subtraction"
    },
    {
        set: divisions,
        type: "operator",
        role: "division"
    },
    {
        set: prefixOps,
        type: "operator",
        role: "prefix operator"
    },
    {
        set: prefixOpsBold,
        type: "operator",
        role: "prefix operator",
        font: "bold"
    },
    {
        set: prefixOpsItalic,
        type: "operator",
        role: "prefix operator",
        font: "italic"
    },
    {
        set: prefixOpsSansSerifBold,
        type: "operator",
        role: "prefix operator",
        font: "sans-serif-bold"
    },
    {
        set: equalities,
        type: "relation",
        role: "equality"
    },
    {
        set: inequalities,
        type: "relation",
        role: "inequality"
    },
    {
        set: setRelations,
        type: "relation",
        role: "set"
    },
    {
        set: relations,
        type: "relation",
        role: "unknown"
    },
    {
        set: arrows,
        type: "relation",
        role: "arrow"
    },
    {
        set: elementRelations,
        type: "operator",
        role: "element"
    },
    {
        set: nonelementRelations,
        type: "operator",
        role: "nonelement"
    },
    {
        set: reelementRelations,
        type: "operator",
        role: "reelement"
    },
    {
        set: renonelementRelations,
        type: "operator",
        role: "renonelement"
    },
    {
        set: sumOps,
        type: "largeop",
        role: "sum"
    },
    {
        set: intOps,
        type: "largeop",
        role: "integral"
    },
    {
        set: geometryOps,
        type: "operator",
        role: "geometry"
    },
    {
        set: limitFunctions,
        type: "function",
        role: "limit function"
    },
    {
        set: prefixFunctions,
        type: "function",
        role: "prefix function"
    },
    {
        set: infixFunctions,
        type: "operator",
        role: "prefix function"
    }
];
const meaning_ = (function () {
    const result = {};
    for (let i = 0, st; (st = symbolSetToSemantic_[i]); i++) {
        st.set.forEach(function (symbol) {
            result[symbol] = {
                role: st.role || "unknown",
                type: st.type || "unknown",
                font: st.font || "unknown"
            };
        });
    }
    return result;
})();
function equal(meaning1, meaning2) {
    return (meaning1.type === meaning2.type &&
        meaning1.role === meaning2.role &&
        meaning1.font === meaning2.font);
}
exports.equal = equal;
function lookupType(symbol) {
    var _a;
    return ((_a = meaning_[symbol]) === null || _a === void 0 ? void 0 : _a.type) || "unknown";
}
exports.lookupType = lookupType;
function lookupRole(symbol) {
    var _a;
    return ((_a = meaning_[symbol]) === null || _a === void 0 ? void 0 : _a.role) || "unknown";
}
exports.lookupRole = lookupRole;
function lookupMeaning(symbol) {
    return (meaning_[symbol] || {
        role: "unknown",
        type: "unknown",
        font: "unknown"
    });
}
exports.lookupMeaning = lookupMeaning;
function invisibleTimes() {
    return invisibleTimes_;
}
exports.invisibleTimes = invisibleTimes;
function invisiblePlus() {
    return invisiblePlus_;
}
exports.invisiblePlus = invisiblePlus;
function invisibleComma() {
    return invisibleComma_;
}
exports.invisibleComma = invisibleComma;
function functionApplication() {
    return functionApplication_;
}
exports.functionApplication = functionApplication;
function isMatchingFence(open, close) {
    if (neutralFences.indexOf(open) !== -1 || metricFences.indexOf(open) !== -1) {
        return open === close;
    }
    return openClosePairs[open] === close || topBottomPairs[open] === close;
}
exports.isMatchingFence = isMatchingFence;
function isEmbellishedType(type) {
    return (type === "operator" ||
        type === "relation" ||
        type === "fence" ||
        type === "punctuation");
}
exports.isEmbellishedType = isEmbellishedType;
const secondary_ = new Map();
function secKey(kind, char) {
    return `${kind} ${char}`;
}
function addSecondary_(kind, chars, annotation = '') {
    for (const char of chars) {
        secondary_.set(secKey(kind, char), annotation || kind);
    }
}
addSecondary_('d', [
    'd',
    'ⅆ',
    'ｄ',
    '𝐝',
    '𝑑',
    '𝒹',
    '𝓭',
    '𝔡',
    '𝕕',
    '𝖉',
    '𝖽',
    '𝗱',
    '𝘥',
    '𝚍'
]);
addSecondary_('bar', dashes);
addSecondary_('tilde', tildes);
function lookupSecondary(kind, char) {
    return secondary_.get(secKey(kind, char));
}
exports.lookupSecondary = lookupSecondary;
