import { Message } from '@lumino/messaging';
import { CommandPalette, Panel } from '@lumino/widgets';
/**
 * Wrap the command palette in a modal to make it more usable.
 */
export declare class ModalCommandPalette extends Panel {
    constructor(options: ModalCommandPalette.IOptions);
    get palette(): CommandPalette;
    set palette(value: CommandPalette);
    attach(): void;
    detach(): void;
    /**
     * Hide the modal command palette and reset its search.
     */
    hideAndReset(): void;
    /**
     * Handle incoming events.
     */
    handleEvent(event: Event): void;
    /**
     * Find the element with search icon group.
     */
    protected get searchIconGroup(): HTMLDivElement | undefined;
    /**
     * Create element with search icon group.
     */
    protected createSearchIconGroup(): HTMLDivElement;
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    protected onAfterAttach(msg: Message): void;
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    protected onAfterDetach(msg: Message): void;
    protected onBeforeHide(msg: Message): void;
    protected onAfterShow(msg: Message): void;
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    protected onActivateRequest(msg: Message): void;
    /**
     * Handle the `'keydown'` event for the widget.
     */
    protected _evtKeydown(event: KeyboardEvent): void;
    private _commandPalette;
}
export declare namespace ModalCommandPalette {
    interface IOptions {
        commandPalette: CommandPalette;
    }
}
