/**
 * @packageDocumentation
 * @module mathjax-extension
 */
import { JupyterFrontEndPlugin } from '@jupyterlab/application';
import { ILatexTypesetter } from '@jupyterlab/rendermime';
import type { MathDocument } from 'mathjax-full/js/core/MathDocument';
/**
 * The MathJax Typesetter.
 */
export declare class MathJaxTypesetter implements ILatexTypesetter {
    protected _ensureInitialized(): Promise<void>;
    /**
     * Get an instance of the MathDocument object.
     */
    mathDocument(): Promise<MathDocument<any, any, any>>;
    /**
     * Typeset the math in a node.
     */
    typeset(node: HTMLElement): Promise<void>;
    protected _initialized: boolean;
    protected _mathDocument: MathDocument<any, any, any>;
}
/**
 * The MathJax extension.
 */
declare const mathJaxPlugin: JupyterFrontEndPlugin<ILatexTypesetter>;
export default mathJaxPlugin;
