import { ITranslator, TranslationBundle } from '@jupyterlab/translation';
import { SidePanel } from '@jupyterlab/ui-components';
import { Message } from '@lumino/messaging';
import { ListModel } from './model';
export declare namespace ExtensionsPanel {
    interface IOptions {
        model: ListModel;
        translator: ITranslator;
    }
}
export declare class ExtensionsPanel extends SidePanel {
    constructor(options: ExtensionsPanel.IOptions);
    /**
     * Dispose of the widget and its descendant widgets.
     */
    dispose(): void;
    /**
     * Handle the DOM events for the extension manager search bar.
     *
     * @param event - The DOM event sent to the extension manager search bar.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the search bar's DOM node.
     * It should not be called directly by user code.
     */
    handleEvent(event: Event): void;
    /**
     * A message handler invoked on a `'before-attach'` message.
     */
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    /**
     * A message handler invoked on an `'after-detach'` message.
     */
    protected onAfterDetach(msg: Message): void;
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    protected onActivateRequest(msg: Message): void;
    private _onStateChanged;
    /**
     * Toggle the focused modifier based on the input node focus state.
     */
    private _toggleFocused;
    protected model: ListModel;
    protected trans: TranslationBundle;
    private _searchInputRef;
    private _wasInitialized;
    private _wasDisclaimed;
}
