"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _lodash = _interopRequireDefault(require("lodash"));

var _lowdb = _interopRequireDefault(require("lowdb"));

var _FileAsync = _interopRequireDefault(require("lowdb/adapters/FileAsync"));

var _Memory = _interopRequireDefault(require("lowdb/adapters/Memory"));

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const debug = (0, _debug.default)('verdaccio:plugin:local-storage:token');
const TOKEN_DB_NAME = '.token-db.json';

class TokenActions {
  constructor(config) {
    _defineProperty(this, "config", void 0);

    _defineProperty(this, "tokenDb", void 0);

    this.config = config;
    this.tokenDb = null;
  }

  _dbGenPath(dbName, config) {
    return _path.default.join(_path.default.resolve(_path.default.dirname(config.self_path || ''), config.storage, dbName));
  }

  async getTokenDb() {
    if (!this.tokenDb) {
      debug('token database is not defined');
      let adapter;

      if (process.env.NODE_ENV === 'test') {
        debug('token memory adapter');
        adapter = new _Memory.default('');
      } else {
        debug('token async adapter');

        const pathDb = this._dbGenPath(TOKEN_DB_NAME, this.config);

        adapter = new _FileAsync.default(pathDb);
      }

      debug('token bd generated');
      this.tokenDb = await (0, _lowdb.default)(adapter);
    }

    return this.tokenDb;
  }

  async saveToken(token) {
    debug('token key %o', token.key);
    const db = await this.getTokenDb();
    const userData = await db.get(token.user).value();
    debug('user data %o', userData);

    if (_lodash.default.isNil(userData)) {
      await db.set(token.user, [token]).write();
      debug('token user %o new database', token.user);
    } else {
      // types does not match with valid implementation
      // @ts-ignore
      await db.get(token.user) // @ts-ignore
      .push(token).write();
    }

    debug('data %o', await db.getState());
    debug('token saved %o', token.user);
  }

  async deleteToken(user, tokenKey) {
    const db = await this.getTokenDb();
    const userTokens = await db.get(user).value();

    if (_lodash.default.isNil(userTokens)) {
      throw new Error('user not found');
    }

    debug('tokens %o - %o', userTokens, userTokens.length);
    const remainingTokens = userTokens.filter(({
      key
    }) => {
      debug('key %o', key);
      return key !== tokenKey;
    });
    await db.set(user, remainingTokens).write();
    debug('removed tokens key %o', tokenKey);
  }

  async readTokens(filter) {
    const {
      user
    } = filter;
    debug('read tokens with %o', user);
    const db = await this.getTokenDb();
    const tokens = await db.get(user).value();
    return tokens || [];
  }

}

exports.default = TokenActions;
//# sourceMappingURL=token.js.map