import { Callback, Config, IPackageStorage, IPluginStorage, LocalStorage, Logger } from '@verdaccio/types';
import TokenActions from './token';
declare class LocalDatabase extends TokenActions implements IPluginStorage<{}> {
    path: string;
    logger: Logger;
    data: LocalStorage;
    config: Config;
    locked: boolean;
    constructor(config: Config, logger: Logger);
    getSecret(): Promise<string>;
    setSecret(secret: string): Promise<Error | null>;
    add(name: string, cb: Callback): void;
    search(onPackage: Callback, onEnd: Callback, validateName: (name: string) => boolean): void;
    remove(name: string, cb: Callback): void;
    /**
     * Return all database elements.
     * @return {Array}
     */
    get(cb: Callback): void;
    getPackageStorage(packageName: string): IPackageStorage;
    clean(): void;
    private getTime;
    private _getCustomPackageLocalStorages;
    /**
     * Syncronize {create} database whether does not exist.
     * @return {Error|*}
     */
    private _sync;
    /**
     * Verify the right local storage location.
     * @param {String} path
     * @return {String}
     * @private
     */
    private _getLocalStoragePath;
    /**
     * Build the local database path.
     * @param {Object} config
     * @return {string|String|*}
     * @private
     */
    private _buildStoragePath;
    /**
     * Fetch local packages.
     * @private
     * @return {Object}
     */
    private _fetchLocalPackages;
}
export default LocalDatabase;
