import { CodeEditor, IEditorMimeTypeService, IEditorServices } from '@jupyterlab/codeeditor';
import { ABCWidgetFactory, DocumentRegistry, IDocumentWidget } from '@jupyterlab/docregistry';
import { Message } from '@lumino/messaging';
import { Widget } from '@lumino/widgets';
/**
 * A widget for editors.
 */
export declare class FileEditor extends Widget {
    /**
     * Construct a new editor widget.
     */
    constructor(options: FileEditor.IOptions);
    /**
     * Get the context for the editor widget.
     */
    get context(): DocumentRegistry.Context;
    /**
     * A promise that resolves when the file editor is ready.
     */
    get ready(): Promise<void>;
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the widget's node. It should
     * not be called directly by user code.
     */
    handleEvent(event: Event): void;
    /**
     * Handle `after-attach` messages for the widget.
     */
    protected onAfterAttach(msg: Message): void;
    /**
     * Handle `before-detach` messages for the widget.
     */
    protected onBeforeDetach(msg: Message): void;
    /**
     * Handle `'activate-request'` messages.
     */
    protected onActivateRequest(msg: Message): void;
    /**
     * Ensure that the widget has focus.
     */
    private _ensureFocus;
    /**
     * Handle actions that should be taken when the context is ready.
     */
    private _onContextReady;
    /**
     * Handle a change to the path.
     */
    private _onPathChanged;
    model: CodeEditor.IModel;
    editor: CodeEditor.IEditor;
    private _context;
    private _editorWidget;
    private _mimeTypeService;
    private _ready;
}
/**
 * The namespace for editor widget statics.
 */
export declare namespace FileEditor {
    /**
     * The options used to create an editor widget.
     */
    interface IOptions {
        /**
         * A code editor factory.
         */
        factory: CodeEditor.Factory;
        /**
         * The mime type service for the editor.
         */
        mimeTypeService: IEditorMimeTypeService;
        /**
         * The document context associated with the editor.
         */
        context: DocumentRegistry.CodeContext;
    }
    /**
     * File editor default configuration.
     */
    const defaultEditorConfig: Record<string, any>;
}
/**
 * A widget factory for editors.
 */
export declare class FileEditorFactory extends ABCWidgetFactory<IDocumentWidget<FileEditor>, DocumentRegistry.ICodeModel> {
    /**
     * Construct a new editor widget factory.
     */
    constructor(options: FileEditorFactory.IOptions);
    /**
     * Create a new widget given a context.
     */
    protected createNewWidget(context: DocumentRegistry.CodeContext): IDocumentWidget<FileEditor>;
    private _services;
}
/**
 * The namespace for `FileEditorFactory` class statics.
 */
export declare namespace FileEditorFactory {
    /**
     * The options used to create an editor widget factory.
     */
    interface IOptions {
        /**
         * The editor services used by the factory.
         */
        editorServices: IEditorServices;
        /**
         * The factory options associated with the factory.
         */
        factoryOptions: DocumentRegistry.IWidgetFactoryOptions<IDocumentWidget<FileEditor>>;
    }
}
