import { CodeEditor } from '@jupyterlab/codeeditor';
import { IEditorLanguageRegistry } from '@jupyterlab/codemirror';
import { ITranslator } from '@jupyterlab/translation';
import { VDomModel, VDomRenderer } from '@jupyterlab/ui-components';
import { CommandRegistry } from '@lumino/commands';
/**
 * StatusBar item to change the language syntax highlighting of the file editor.
 */
export declare class EditorSyntaxStatus extends VDomRenderer<EditorSyntaxStatus.Model> {
    /**
     * Construct a new VDomRenderer for the status item.
     */
    constructor(options: EditorSyntaxStatus.IOptions);
    /**
     * Render the status item.
     */
    render(): JSX.Element | null;
    /**
     * Create a menu for selecting the language of the editor.
     */
    private _handleClick;
    protected translator: ITranslator;
    private _commands;
    private _popup;
}
/**
 * A namespace for EditorSyntax statics.
 */
export declare namespace EditorSyntaxStatus {
    /**
     * A VDomModel for the current editor/mode combination.
     */
    class Model extends VDomModel {
        languages: IEditorLanguageRegistry;
        constructor(languages: IEditorLanguageRegistry);
        /**
         * The current editor language. If no editor is present,
         * returns the empty string.
         */
        get language(): string;
        /**
         * The current editor for the application editor tracker.
         */
        get editor(): CodeEditor.IEditor | null;
        set editor(editor: CodeEditor.IEditor | null);
        /**
         * If the editor mode changes, update the model.
         */
        private _onMIMETypeChange;
        /**
         * Trigger a rerender of the model.
         */
        private _triggerChange;
        private _language;
        private _editor;
    }
    /**
     * Options for the EditorSyntax status item.
     */
    interface IOptions {
        /**
         * The application command registry.
         */
        commands: CommandRegistry;
        /**
         * Editor languages.
         */
        languages: IEditorLanguageRegistry;
        /**
         * The language translator.
         */
        translator?: ITranslator;
    }
}
