import { CodeMirrorEditor } from '@jupyterlab/codemirror';
import { DocumentRegistry, IDocumentWidget } from '@jupyterlab/docregistry';
import { Document, IAdapterOptions, IVirtualPosition, VirtualDocument, WidgetLSPAdapter } from '@jupyterlab/lsp';
import { FileEditor } from './widget';
export interface IFileEditorAdapterOptions extends IAdapterOptions {
    /**
     * The document registry instance.
     */
    docRegistry: DocumentRegistry;
}
export declare class FileEditorAdapter extends WidgetLSPAdapter<IDocumentWidget<FileEditor>> {
    constructor(editorWidget: IDocumentWidget<FileEditor>, options: IFileEditorAdapterOptions);
    /**
     * The wrapped `FileEditor` widget.
     */
    readonly editor: FileEditor;
    /**
     * Promise that resolves once the adapter is initialized
     */
    get ready(): Promise<void>;
    /**
     * Get current path of the document.
     */
    get documentPath(): string;
    /**
     * Get the mime type of the document.
     */
    get mimeType(): string;
    /**
     * Get the file extension of the document.
     */
    get languageFileExtension(): string;
    /**
     * Get the CM editor
     */
    get ceEditor(): CodeMirrorEditor;
    /**
     * Get the activated CM editor.
     */
    get activeEditor(): Document.IEditor;
    /**
     * Get the inner HTMLElement of the document widget.
     */
    get wrapperElement(): HTMLElement;
    /**
     * Get current path of the document.
     */
    get path(): string;
    /**
     *  Get the list of CM editors in the document, there is only one editor
     * in the case of file editor.
     */
    get editors(): Document.ICodeBlockOptions[];
    /**
     * Dispose the widget.
     */
    dispose(): void;
    /**
     * Generate the virtual document associated with the document.
     */
    createVirtualDocument(): VirtualDocument;
    /**
     * Get the index of editor from the cursor position in the virtual
     * document. Since there is only one editor, this method always return
     * 0
     *
     * @param position - the position of cursor in the virtual document.
     * @return  {number} - index of the virtual editor
     */
    getEditorIndexAt(position: IVirtualPosition): number;
    /**
     * Get the index of input editor
     *
     * @param ceEditor - instance of the code editor
     */
    getEditorIndex(ceEditor: Document.IEditor): number;
    /**
     * Get the wrapper of input editor.
     *
     * @param ceEditor
     * @return  {HTMLElement}
     */
    getEditorWrapper(ceEditor: Document.IEditor): HTMLElement;
    /**
     * Initialization function called once the editor and the LSP connection
     * manager is ready. This function will create the virtual document and
     * connect various signals.
     */
    protected initOnceReady(): Promise<void>;
    /**
     * The document registry instance.
     */
    private readonly _docRegistry;
    private readonly _virtualEditor;
    private _readyDelegate;
}
