import * as Y from 'yjs';
import type { FileChange, ISharedFile, ISharedText } from './api.js';
import { IYText } from './ytext.js';
import { YDocument } from './ydocument.js';
/**
 * Shareable text file.
 */
export declare class YFile extends YDocument<FileChange> implements ISharedFile, ISharedText, IYText {
    /**
     * Create a new file
     *
     * #### Notes
     * The document is empty and must be populated
     */
    constructor();
    /**
     * Creates a standalone YFile
     */
    static create(): YFile;
    /**
     * YJS file text.
     */
    readonly ysource: Y.Text;
    /**
     * File text
     */
    get source(): string;
    set source(v: string);
    /**
     * Dispose of the resources.
     */
    dispose(): void;
    /**
     * Get the file text.
     *
     * @returns File text.
     */
    getSource(): string;
    /**
     * Set the file text.
     *
     * @param value New text
     */
    setSource(value: string): void;
    /**
     * Replace content from `start' to `end` with `value`.
     *
     * @param start: The start index of the range to replace (inclusive).
     * @param end: The end index of the range to replace (exclusive).
     * @param value: New source (optional).
     */
    updateSource(start: number, end: number, value?: string): void;
    /**
     * Handle a change to the ymodel.
     */
    private _modelObserver;
}
