import { JSONObject, JSONValue } from '@lumino/coreutils';
import { ISignal, Signal } from '@lumino/signaling';
import { Awareness } from 'y-protocols/awareness';
import * as Y from 'yjs';
import type { DocumentChange, ISharedDocument } from './api.js';
/**
 * Generic shareable document.
 */
export declare class YDocument<T extends DocumentChange> implements ISharedDocument {
    constructor(options?: YDocument.IOptions);
    /**
     * Creates a standalone YDocument
     */
    static create(): YDocument<DocumentChange>;
    /**
     * YJS document.
     */
    get ydoc(): Y.Doc;
    /**
     * Shared state
     */
    get ystate(): Y.Map<any>;
    /**
     * YJS document undo manager
     */
    get undoManager(): Y.UndoManager;
    /**
     * Shared awareness
     */
    get awareness(): Awareness;
    /**
     * The changed signal.
     */
    get changed(): ISignal<this, T>;
    /**
     * A signal emitted when the document is disposed.
     */
    get disposed(): ISignal<this, void>;
    /**
     * Whether the document is disposed or not.
     */
    get isDisposed(): boolean;
    /**
     * Document state
     */
    get state(): JSONObject;
    /**
     * Whether the object can undo changes.
     */
    canUndo(): boolean;
    /**
     * Whether the object can redo changes.
     */
    canRedo(): boolean;
    /**
     * Dispose of the resources.
     */
    dispose(): void;
    /**
     * Get the value for a state attribute
     *
     * @param key Key to get
     */
    getState(key: string): JSONValue | undefined;
    /**
     * Set the value of a state attribute
     *
     * @param key Key to set
     * @param value New attribute value
     */
    setState(key: string, value: JSONValue): void;
    /**
     * Undo an operation.
     */
    undo(): void;
    /**
     * Redo an operation.
     */
    redo(): void;
    /**
     * Clear the change stack.
     */
    clearUndoHistory(): void;
    /**
     * Perform a transaction. While the function f is called, all changes to the shared
     * document are bundled into a single event.
     */
    transact(f: () => void, undoable?: boolean): void;
    /**
     * Handle a change to the ystate.
     */
    protected onStateChanged: (event: Y.YMapEvent<any>) => void;
    protected _changed: Signal<this, T>;
    private _ydoc;
    private _ystate;
    private _undoManager;
    private _awareness;
    private _isDisposed;
    private _disposed;
}
declare namespace YDocument {
    interface IOptions {
        /**
         * The optional YJS document for YDocument.
         */
        ydoc?: Y.Doc;
    }
}
export {};
