declare type YarnEntry = {
    resolved: string;
    version: string;
};
declare type YarnEntries = Record<string, YarnEntry>;
declare type Package = {
    installedVersion: string;
    name: string;
    pkg: YarnEntry;
    satisfiedBy: Set<string>;
    candidateVersions?: string[];
    requestedVersion: string;
    bestVersion?: string;
    versions: Versions;
};
declare type Version = {
    pkg: YarnEntry;
    satisfies: Set<Package>;
};
declare type Versions = Map<string, Version>;
declare type Options = {
    includeScopes?: string[];
    includePackages?: string[];
    excludePackages?: string[];
    excludeScopes?: string[];
    useMostCommon?: boolean;
    includePrerelease?: boolean;
};
export declare const getDuplicates: (yarnEntries: YarnEntries, { includeScopes, includePackages, excludePackages, excludeScopes, useMostCommon, includePrerelease, }?: Options) => Package[];
export declare const listDuplicates: (yarnLock: string, options?: Options) => string[];
export declare const fixDuplicates: (yarnLock: string, options?: Options) => string;
export {};
//# sourceMappingURL=index.d.ts.map