import { Cell } from '@jupyterlab/cells';
import { WindowedLayout, WindowedList, WindowedListModel } from '@jupyterlab/ui-components';
import { Widget } from '@lumino/widgets';
/**
 * Notebook view model for the windowed list.
 */
export declare class NotebookViewModel extends WindowedListModel {
    protected cells: Cell[];
    /**
     * Default cell height
     */
    static DEFAULT_CELL_SIZE: number;
    /**
     * Default editor line height
     */
    static DEFAULT_EDITOR_LINE_HEIGHT: number;
    /**
     * Default cell margin (top + bottom)
     */
    static DEFAULT_CELL_MARGIN: number;
    /**
     * Construct a notebook windowed list model.
     */
    constructor(cells: Cell[], options?: WindowedList.IModelOptions);
    /**
     * Cell size estimator
     *
     * @param index Cell index
     * @returns Cell height in pixels
     */
    estimateWidgetSize: (index: number) => number;
    /**
     * Render the cell at index.
     *
     * @param index Cell index
     * @returns Cell widget
     */
    widgetRenderer: (index: number) => Widget;
}
/**
 * Windowed list layout for the notebook.
 */
export declare class NotebookWindowedLayout extends WindowedLayout {
    private _header;
    /**
     * Returns Notebook's header
     *
     * @return Widget | null
     */
    get header(): Widget | null;
    /**
     * Set Notebook's header
     *
     * @param v: Widget | null
     */
    set header(v: Widget | null);
    /**
     * Remove a widget from the layout.
     *
     * @param widget - The widget to remove from the layout.
     *
     * #### Notes
     * A widget is automatically removed from the layout when its `parent`
     * is set to `null`. This method should only be invoked directly when
     * removing a widget from a layout which has yet to be installed on a
     * parent widget.
     *
     * This method does *not* modify the widget's `parent`.
     */
    removeWidget(widget: Widget): void;
    /**
     * Attach a widget to the parent's DOM node.
     *
     * @param index - The current index of the widget in the layout.
     *
     * @param widget - The widget to attach to the parent.
     *
     * #### Notes
     * This method is called automatically by the panel layout at the
     * appropriate time. It should not be called directly by user code.
     *
     * The default implementation adds the widgets's node to the parent's
     * node at the proper location, and sends the appropriate attach
     * messages to the widget if the parent is attached to the DOM.
     *
     * Subclasses may reimplement this method to control how the widget's
     * node is added to the parent's node.
     */
    protected attachWidget(index: number, widget: Widget): void;
    /**
     * Detach a widget from the parent's DOM node.
     *
     * @param index - The previous index of the widget in the layout.
     *
     * @param widget - The widget to detach from the parent.
     *
     * #### Notes
     * This method is called automatically by the panel layout at the
     * appropriate time. It should not be called directly by user code.
     *
     * The default implementation removes the widget's node from the
     * parent's node, and sends the appropriate detach messages to the
     * widget if the parent is attached to the DOM.
     *
     * Subclasses may reimplement this method to control how the widget's
     * node is removed from the parent's node.
     */
    protected detachWidget(index: number, widget: Widget): void;
    /**
     * Move a widget in the parent's DOM node.
     *
     * @param fromIndex - The previous index of the widget in the layout.
     *
     * @param toIndex - The current index of the widget in the layout.
     *
     * @param widget - The widget to move in the parent.
     *
     * #### Notes
     * This method is called automatically by the panel layout at the
     * appropriate time. It should not be called directly by user code.
     *
     * The default implementation moves the widget's node to the proper
     * location in the parent's node and sends the appropriate attach and
     * detach messages to the widget if the parent is attached to the DOM.
     *
     * Subclasses may reimplement this method to control how the widget's
     * node is moved in the parent's node.
     */
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    /**
     * A message handler invoked on a `'child-removed'` message.
     *
     * @param msg Message
     */
    protected onChildRemoved(msg: Widget.ChildMessage): void;
    private _findNearestChildBinarySearch;
    private _willBeRemoved;
    private _topHiddenCodeCells;
}
